﻿function ExcelHelper()
{

};
/*获取excel表格中的工作表集合*/
/*
参数说明：
FileName：文件路径
PassWord：打开文件的密码，如果没有就默认为空字符串''
*/
ExcelHelper.ReadSheet=function(FileName,PassWord)
{
    var sheetGroup="";
    try
    {
        sheetGroup=window.external.Excel_ReadSheet(FileName,PassWord);        
    }
    catch(e)
    {
        alert("ExcelHelper.ReadSheet:"+e.message);
    }
    CollectGarbage();
    return sheetGroup;
};
/*获取指定工作表中的列集合*/
/*
参数说明：
FileName：文件路径
PassWord：打开文件的密码，如果没有就默认为空字符串''
SheetIndex：指定的工作表序号
HeadIndex：表头所在的行序号，excel的开始序号是从1开始，不是0开始
*/
ExcelHelper.ReadColumn=function(FileName,PassWord,SheetIndex,HeadIndex)
{
    var ColumnGroup="";
    try
    {
        ColumnGroup=window.external.Excel_ReadColumn(FileName,PassWord,SheetIndex,HeadIndex);
    }
    catch(e)
    {
        alert("ExcelHelper.ReadColumn"+e.message);
    }
    CollectGarbage();
    return ColumnGroup;
};
/*导入excel数据*/
/*
参数说明：
FileName：文件路径
PassWord：打开文件的密码，如果没有就默认为空字符串''
SheetIndex：指定的工作表序号
HeadIndex：表头所在的行序号，excel的开始序号是从1开始，不是0开始
DataObj：数据对象
数据对象格式如：
var obj=new Object();
obj.SoucreIndex="1,2,3,4,5,6,7";//从配置列表中获取到的来源列序号
obj.SoucreColGroup="A1,B2,C3,D4,E5,F6,G7";//从配置列表中获取到的来源列名
obj.SaveColumnGroup="T.T1,T.T2,E.E3,T.T3,E.E2,T.T4,E.E1";//从配置列表中获取到的保存字段集合，其中来源列的顺序和保存字段集合的顺序必须一一对应。
*/
ExcelHelper.ImportData=function(FileName,PassWord,SheetIndex,HeadIndex,DataObj,GroupID)
{
    var IsOK=false;
    try
    {
        IsOK=window.external.Excel_SaveDataToStore(FileName,PassWord,SheetIndex,HeadIndex,DataObj,GroupID);
    }
    catch(e)
    {
        alert("ExcelHelper.ImportData"+e.message);
    }
    CollectGarbage();
    return IsOK;
};