﻿//调用方式：
/*
<span>
        <table width="100%" height="100%" id="cover" style="position:absolute;top:0px;left:0px;display:none;" onselectstart="javascript:return false;">
      <tr>
        <td id="dlg" width="100%" height="100%" align="center" valign="center">
        </td>
      </tr>
    </table>
    <script type="text/javascript" src="../../jsHelper/jsControl/MessageBox.js"></script>
    <input type="button" value="点我" onclick="javascript:objDlg.DoModal('注意', '吃饭了', MB_OK, 'objDlg');">
    <input type="button" value="然后点我" onclick="javascript:objDlg2.DoModal('注意', '吃饭了？', MB_YES+MB_NO, 'objDlg2');">
</span>
*/

<!--
//按钮类型
var MB_OK = 1;
var MB_CANCEL = 2;
var MB_YES = 4;
var MB_NO = 8;
/*================================================================================*/
/*================================================================================*/
//MessageBox类
//因为利用层不可能实现真正模态对话框，用户仍然可以点击对话框以外的区域，所以需要一个覆盖框－coverIdStr
//另一方面为了承载对话框，需要dlgIdStr
function CMessageBox(coverIdStr, dlgIdStr)
{
    this.coverIdStr = coverIdStr;
    this.coverId = document.getElementById(this.coverIdStr);
    this.dlgIdStr = dlgIdStr;
    this.dlgId = document.getElementById(this.dlgIdStr);
    
    this.dlgCaptionId = null;
    this.dlgInfoId = null;
    this.dlgButtonsId = null;
    
    this.caption = "";
    this.info = "";
    this.buttons = MB_OK;
    this.returnValue = 0; //返回值，0表示不确定，其它值可能是MB_OK、MB_CANCEL、MB_YES、MB_NO
    
    this.DoModal = DoModal;
    this.IniDlg = IniDlg;
    this.ShowDlg = ShowDlg;
}

//caption 对话框标题
//info 对话框内容，HTML无效
//buttons 对话框按钮，使用一个按钮类型值或多个按钮类型值相加（但不能重复相加），HTML有效
//objNameStr CMessageBox对象名称
function DoModal(caption, info, buttons, objNameStr)
{
    this.dlgId.innerHTML = "<div style=\"padding:0px;width:300px;background-color:buttonface;filter:alpha(opacity=100);" +
                           "border-top:buttonhighlight 2px solid;" +
                           "border-right:buttonshadow 2px solid;" +
                           "border-bottom:buttonshadow 2px solid;" +
                           "border-left:buttonhighlight 2px solid;" +
                           "cursor:default;\" onselectstart=\"javascript:return false;\">" +
                           "  <div id=\"" + this.dlgIdStr + "_caption\" style=\"padding:2px;width:100%;background-color:#000066;text-align:left;color:#FFFFFF;\" onselectstart=\"javascript:return false;\"></div>" +
                           "  <div id=\"" + this.dlgIdStr + "_info\" style=\"padding:10px;width:100%;background-color:buttonface;text-align:center;color:#000000;\" onselectstart=\"javascript:return false;\"></div>" +
                           "  <div id=\"" + this.dlgIdStr + "_buttons\" style=\"padding:10px;width:100%;background-color:buttonface;text-align:center;color:#000000;\" onselectstart=\"javascript:return false;\"></div>" +
                           "</div>";
    
    this.dlgCaptionId = document.getElementById(this.dlgIdStr + "_caption");
    this.dlgInfoId = document.getElementById(this.dlgIdStr + "_info");
    this.dlgButtonsId = document.getElementById(this.dlgIdStr + "_buttons");
    
    this.IniDlg(caption, info, buttons, objNameStr);
    this.ShowDlg(true);
}

//初始化对话框
function IniDlg(caption, info, buttons, objNameStr)
{
    this.dlgCaptionId.innerText = caption;
    this.dlgInfoId.innerHTML = info;
    this.dlgButtonsId.innerHTML = "";
    
    if (parseInt(buttons/8) == 1)
    {
        this.dlgButtonsId.innerHTML = " <input type=\"button\" value=\"　否　\"" +
                                      " onclick=\"javascript:" + objNameStr + ".ShowDlg(false, MB_NO);OnDlgReturn('" + objNameStr + "', MB_NO);\"> " +
                                      this.dlgButtonsId.innerHTML;//前后空格，避免各个按钮之间离得太近
        buttons -= 8;
    }
    
    if (parseInt(buttons/4) == 1)
    {
        this.dlgButtonsId.innerHTML = " <input type=\"button\" value=\"　是　\"" +
                                      " onclick=\"javascript:" + objNameStr + ".ShowDlg(false, MB_YES);OnDlgReturn('" + objNameStr + "', MB_YES);\"> " +
                                      this.dlgButtonsId.innerHTML;
        buttons -= 4;
    }
    if (parseInt(buttons/2) == 1)
    {
        this.dlgButtonsId.innerHTML = " <input type=\"button\" value=\" 取 消 \"" +
                                      " onclick=\"javascript:" + objNameStr + ".ShowDlg(false, MB_CANCEL);OnDlgReturn('" + objNameStr + "', MB_CANCEL);\"> " +
                                      this.dlgButtonsId.innerHTML;
        buttons -= 2;
    }
    if (buttons == 1)
    {
        this.dlgButtonsId.innerHTML = " <input type=\"button\" value=\" 确 定 \"" +
                                      " onclick=\"javascript:" + objNameStr + ".ShowDlg(false, MB_OK);OnDlgReturn('" + objNameStr + "', MB_OK);\"> " +
                                      this.dlgButtonsId.innerHTML;
    }
}

//显示、隐藏对话框，并确定是点击哪个按钮关闭对话框的
//display为true－显示
//display为false－隐藏
function ShowDlg(display, returnValue)
{
    if (display)
    {
        ReSizeDlg();
        this.coverId.style.display = "block";
    }
    else
    {
        this.coverId.style.display = "none";
    }
    
    this.returnValue = returnValue;
}
/*================================================================================*/
/*================================================================================*/
//对话框返回函数
//自行修改函数代码
function OnDlgReturn(objNameStr, returnValue)
{
    alert("CMessageBox 对象 " + objNameStr + " 的返回值是" + returnValue);
}

//保持cover框覆盖整个客户区
//保持对话框在预期位置
//如果覆盖框id不为cover，则需要手动修改此函数。
//document.body.onscroll和document.body.onresize触发本函数
//同时此函数也被CMessageBox调用
function ReSizeDlg()
{
    var cover = document.getElementById("cover");
    cover.style.pixelTop = document.body.scrollTop;
    cover.style.pixelLeft = document.body.scrollLeft;
    cover.style.width = document.body.clientWidth;
    cover.style.height = document.body.clientHeight;
}

document.body.onscroll = ReSizeDlg;
document.body.onresize = ReSizeDlg;
/*================================================================================*/
/*================================================================================*/
var objDlg = new CMessageBox("cover", "dlg");
var objDlg2 = new CMessageBox("cover", "dlg");
//-->