#!/system/bin/sh

#EMMC flash lifetime ---- add by chenxi. 2016.12.21
mmc_lifetime -t 86400 -e 1 &

busybox date -s 201501010000.00

HIETHENABLE=`getprop persist.sys.doublenet`
case $HIETHENABLE in
 true)
  ip link add link eth0 eth1 type macvlan
  ;;
 esac

# OptimizedNetwork
test -f /system/bin/hioptimizednetwork && /system/bin/hioptimizednetwork

QBENABLE=`getprop persist.sys.qb.enable`
case $QBENABLE in
 true)
  ;;
 *)
  setprop sys.insmod.ko 1
  ;;
 esac

#GPU
#add by hyhao for eht0 optimize
busybox ifconfig eth0 up

#add by zlq for wifi static arp config
echo 1 >/proc/sys/net/ipv4/conf/all/arp_ignore

echo 0 > /sys/module/mali/parameters/mali_avs_enable
echo 750000 > /sys/module/mali/parameters/mali_dvfs_max_freqency

echo 2 4 1 7 > /proc/sys/kernel/printk

echo "\n\nWelcome to HiAndroid\n\n" > /dev/kmsg
LOW_RAM=`getprop ro.config.low_ram`
case $LOW_RAM in
 true)
  echo "\n\nenter low_ram mode\n\n" > /dev/kmsg
  #modules(memopt): Enable KSM in low ram device
  echo 134217728 > /sys/block/zram0/disksize 
  mkswap /dev/block/zram0
  swapon /dev/block/zram0
  echo 1 > /sys/kernel/mm/ksm/run
  echo 300 > /sys/kernel/mm/ksm/sleep_millisecs
  ;;
 *)
  ;;
 esac

#specified by stb beigin
if [ -e /system/bin/recoverywifi ];then
   /system/bin/recoverywifi &
fi
/system/bin/fixwifi.sh &

#add by HMW from c80_8v9 begin
echo "2" > /proc/sys/net/ipv4/conf/default/force_igmp_version
echo "2" > /proc/sys/net/ipv4/conf/eth0/force_igmp_version
echo "2048000" > /proc/sys/net/core/rmem_max

/system/etc/init.thirdos.sh &

if [ -e /system/bin/checksoftversion ];then
    /system/bin/checksoftversion &
fi

FastplayExist=`getprop persist.sys.fastplay.exist`
if [ ! "true" = "$FastplayExist" ]; then
        if [ -e /system/iptv/fastplay/boot.ts ];then
        cp /system/iptv/fastplay/boot.ts /data/local/boot.ts
        setprop persist.sys.fastplay.exist true
    fi
fi

#add by HMW from c80_8v9 end



#feature: set memsize for settings and hmw
MemTotal=`cat /proc/meminfo | grep MemTotal | busybox awk '{print $2}'`
setprop ro.total.memsize $MemTotal

FlashTotal=`busybox fdisk -l /dev/block/mmcblk0| grep mmcblk0: | busybox awk '{print $3}'`
if [ $FlashTotal -lt 4096 ];then
    setprop ro.total.flash "4G"
elif [ $FlashTotal -lt 8192 ];then
    setprop ro.total.flash "8G"
else
    setprop ro.total.flash "4G"
fi
#specified by stb end

#add for disable location manager service
setprop config.disable_location true

#w00356654 macvlan control logic
ETHMAC_CMD=`getprop ro.mac`
ETHMAC=$ETHMAC_CMD
PETHMAC='00:00:01:'${ETHMAC:9:16}
ip link add link eth0 dev peth0 address ${PETHMAC} type macvlan
#do not pull up peth0 interface
#busybox ifconfig peth0 up

#x00311212 ipv6 control except wlan0
EnableIPv6=`getprop persist.hw.sys.net.ipv6`
case $EnableIPv6 in
	1)
	setprop persist.hw.sys.net.ipv6 1
	setprop persist.hw.sys.net.ipv6 1
	;;
	*)
	setprop persist.hw.sys.net.ipv6 0
	setprop persist.hw.sys.net.ipv6 0
	;;
	esac

#add by l00272627, UPG system parameters control 
/system/bin/config_client &

#add by lWX464723 delete pppoe pid file
rm /data/ppp/pppd.pid
rm /data/ppp/pppoe.pid

#this cmd must be sleep 25s to execute ,so if you need add other cmds,please add this line above.
sleep 25
#add by stb for DTS2017090401922 
echo 500000 > /sys/module/mali/parameters/mali_dvfs_max_freqency

setprop service.adb.tcp.port 5555

adbd &


