Widget.extend('ProcessWidget', {
    init: function(container, option)
    {
        this._super('vod_process_widget', container);
		$("<div>",{id:"vod_process_info"}).appendTo(this.$widget);
		this.$widget.find("#vod_process_info").css("background-image","url("+Util.localImage('black.png')+")");
		$("<div>",{id:"vod_process_name"}).appendTo(this.$widget);
		$("<div>",{id:"vod_process_speed"}).appendTo(this.$widget);
		
		this.$vod_process_layer = $("<div>",{id:"vod_process_layer"}).appendTo(this.$widget);
		$("<div>",{id:"vod_process_curr_time"}).appendTo(this.$vod_process_layer);
		this.$widget.find("#vod_process_curr_time").css("background-image","url("+Util.localImage('proess_curtime_text.png')+")");
		$("<div>",{id:"vod_process_start_time"}).appendTo(this.$vod_process_layer);
		$("<div>",{id:"vod_process_end_time"}).appendTo(this.$vod_process_layer);
		$("<div>",{id:"vod_process_bg"}).appendTo(this.$vod_process_layer);
		this.$widget.find("#vod_process_bg").css("background-image","url("+Util.localImage('process_timeBox.png')+")");
		$("<div>",{id:"processImg"}).appendTo(this.$vod_process_layer);
		this.$widget.find("#processImg").css("background-image","url("+Util.localImage('process_bgBox.png')+")");
		$("<div>",{id:"vod_process_curr_ico"}).appendTo(this.$vod_process_layer);
		this.$widget.find("#vod_process_curr_ico").css("background-image","url("+Util.localImage('timePro.gif')+")");
		
		this.$operation_ico = $("<div>",{id:"operation_ico"}).appendTo(this.$widget);
		$("<div>",{id:"play_pause_ico"}).addClass("ico").appendTo(this.$operation_ico);
		this.$widget.find("#play_pause_ico").css("background-image","url("+Util.localImage('PlayPause.png')+")");
		this.$play_pause_text = $("<div>",{id:"play_pause_text"}).addClass("text").appendTo(this.$operation_ico);
		this.$play_pause_text.text(Util.localString("process_play_pause"));
		
		$("<div>",{id:"rwd_ico"}).addClass("ico").appendTo(this.$operation_ico);
		this.$widget.find("#rwd_ico").css("background-image","url("+Util.localImage('RWD.png')+")");
		this.$rwd_text = $("<div>",{id:"rwd_text"}).addClass("text_ioc").appendTo(this.$operation_ico);
		this.$rwd_text.text(Util.localString("tvod_info_rwd"));
		
		$("<div>",{id:"fwd_ico"}).addClass("ico").appendTo(this.$operation_ico);
		this.$widget.find("#fwd_ico").css("background-image","url("+Util.localImage('FWD.png')+")");
		this.$fwd_text = $("<div>",{id:"fwd_text"}).addClass("text_ioc").appendTo(this.$operation_ico);
		this.$fwd_text.text(Util.localString("tvod_info_fwd"));
		
		$("<div>",{id:"to_the_beginning_ico"}).addClass("ico").appendTo(this.$operation_ico);
		this.$widget.find("#to_the_beginning_ico").css("background-image","url("+Util.localImage('To_the_beginning.png')+")");
		this.$to_the_beginning_text = $("<div>",{id:"to_the_beginning_text"}).addClass("to_the_beginning_text").appendTo(this.$operation_ico);
		this.$to_the_beginning_text.text(Util.localString("tvod_info_begin"));
		
		$("<div>",{id:"to_the_end_ico"}).addClass("ico").appendTo(this.$operation_ico);
		this.$widget.find("#to_the_end_ico").css("background-image","url("+Util.localImage('To_the_end.png')+")");
		this.$to_the_end_text = $("<div>",{id:"to_the_end_text"}).addClass("to_the_end_text").appendTo(this.$operation_ico);
		this.$to_the_end_text.text(Util.localString("process_to_end"));
		
		this.playTimeout = -1;
		this.playTimer = 3*1000;
		this.progTime = "";
		
		this.vodDetail = {}; 
		
		this.vodDetail = {};
		this.process = new Process('#processImg', '#vod_process_curr_ico', 142, 710,'#vod_process_curr_time',95,'#vod_process_end_time');
		this.vodPauseRecommend = new VodPauseRecommend(this.container);
		this.vodPauseRecommend.hide({deactive:true});
    },
	
	show: function(showOption)
    {
		Log.v("ProcessWidget.js	show()	this.vodDetail.name = " + this.vodDetail.name);
		$("#vod_process_name").text(this.vodDetail.name);
		$("#vod_process_start_time").text("00:00:00");
		
        this.$widget.show();
        if (showOption && showOption.active)
        {
            this.active();
        }
    },
			
    handleEvent: function(event)
    {
		Log.v(">>>=============>>	ProcessWidget.js event = " + event);
        switch(event)
        {
			case KeyEvent.UP_KEY:
			case KeyEvent.DOWN_KEY:
				break;
			case KeyEvent.LEFT_KEY:	//模糊定位
				this.leftAction();
				break;
			case KeyEvent.RIGHT_KEY:	//模糊定位
				this.rightAction();
				break;
            case KeyEvent.PAUSEPLAY_KEY:
				this.process.keyPause();	
				var tempStatus = EPGMedia.getPlaybackMode();
				Log.v(">>>> limengli  ===== Global.playCtrlChan.getCurrentPlayPage()  =="+Global.playCtrlChan.getCurrentPlayPage());
				if(typeof(this.vodDetail.contenttype) != "undefined" && "Pause" == tempStatus.PlayMode && "VOD" == Global.playCtrlChan.getCurrentPlayPage())
				{
					this.vodPauseRecommend.show({active:true});
					this.vodPauseRecommend.showLikePoster({vodId:this.vodDetail.id,rectype:this.vodDetail.isSitcomSup});
				}
				else 
				{
					this.vodPauseRecommend.hide({deactive:true});
				}		
                break;
            case KeyEvent.FBWD_KEY:	/*上翻页代替快退*/
				if(Constants.CONTENT_TYPE_VOD_AUDIO != this.vodDetail.contenttype)
				{
					this.vodPauseRecommend.hide({deactive:true});
					this.process.keyFastRewind();
				}
				break;
            case KeyEvent.FFWD_KEY:	/*下翻页代替快进*/
				if(Constants.CONTENT_TYPE_VOD_AUDIO != this.vodDetail.contenttype)
				{
					this.vodPauseRecommend.hide({deactive:true});
					this.process.keyFastForward();
				}
				break;
			case KeyEvent.PAGEDOWN_KEY:
				this.vodPauseRecommend.hide({deactive:true});
				this.process.keyPageDn();
				break;
			case KeyEvent.PAGEUP_KEY:
				this.vodPauseRecommend.hide({deactive:true});
				this.process.keyPageUp();
				break;
            case KeyEvent.OK_KEY:
				this.oKAction();
                break;	
			case STBEvent.EVENT_PLAYMODE_CHANGE:
				this.refreshStatus();
				break;
			case STBEvent.EVENT_MEDIA_END:
				this.playEnd();
				return 0;
				break;
            case KeyEvent.BACK_KEY:
				this.minimizeWidget();
				return 0;
                break;
            default:
				this.minimizeWidget();
                return 0;
        }
        return 1;
    },
	
	rightAction:function()
	{
		var mode = EPGMedia.getPlaybackMode().PlayMode
		if("Pause" == mode)	
		{
			this.process.keyRight();
			return 0;
		}
		else if("Normal Play" == mode)
		{
			this.minimizeWidget();
			return 1;
		}
	},
	
	minimizeWidget:function()
	{
		clearInterval(this.process.loopTimeout);
		clearTimeout(this.playTimeout);
		this.vodPauseRecommend.hide({deactive:true});
		this.hide({deactive:true});
	},
	
	leftAction:function()
	{
		var mode = EPGMedia.getPlaybackMode().PlayMode;
		if("Pause" == mode)
		{
			this.process.keyLeft();
			return 0;
		}
		else if("Normal Play" == mode)
		{
			this.minimizeWidget();
			return 1;
		}	
	},
	
	oKAction:function()
	{
		if("Pause" == EPGMedia.getPlaybackMode().PlayMode)	this.process.keyOk();	
	},
	
	refreshStatus:function()
	{
		clearTimeout(this.playTimeout);
		var status = EPGMedia.getPlaybackMode();
		this.process.showProcess();
		if("Trickmode" == status.PlayMode)
		{
			var tempSpeed = status.Speed;
			$("#vod_process_speed").css("background-image","url(" + Util.localImage(tempSpeed + ".png") + ")");			
//			var speed = tempSpeed.substr(0,tempSpeed.indexOf("x"));
//			if(speed > 0)	$("#vod_process_speed").css("background-image","url(" + Util.localImage(tempSpeed + ".png") + ")");
//			else if(speed < 0)	$("#vod_process_speed").css("background-image","url(" + Util.localImage("speed_pic.png") + ")");
		}
		else
		{
			if("Normal Play" == status.PlayMode)
			{
				$("#vod_process_speed").css("background-image","url(" + Util.localImage("play.png") + ")");
				this.playTimeout = setTimeout(this.callback("minimizeWidget"), this.playTimer);
			}
			else if("Pause" == status.PlayMode)
			{
				$("#vod_process_speed").css("background-image","url(" + this.showPic() + ")");
			}
		}	
	},
	
	showPic:function()
	{
		//this.container.playlist.displayPauseAD();
		return Util.localImage("stop.png");
	},
	
	playEnd:function()
	{		
		this.process.end();					
		this.minimizeWidget();	
	}
});
