<?xml version="1.0"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:include href="..\..\skin\imhist\Lang.xsl"/>


 <xsl:variable name="PageCount">10</xsl:variable>
 <xsl:variable name="isc" select="/Log/@Crypt"/>
 <xsl:variable name="chvc" select="/Log/HistoryCHV/@CHVCount"/>

  <xsl:template match="/">
    <html>
      <head>
        <title>KC</title>
	<link href="../../skin/imhist/main.css" rel="stylesheet" type="text/css"  />
		<script langauge="javascript">
		var lastpage="<xsl:value-of select="$lastpage"/>";
		var nextpage="<xsl:value-of select="$nextpage"/>";
		var previouspage="<xsl:value-of select="$previouspage"/>";
		var firstpage="<xsl:value-of select="$firstpage"/>";
		var Totlepage="<xsl:value-of select="$Totlepage"/>";	
		var page="<xsl:value-of select="$page"/>";
		var goto="<xsl:value-of select="$goto"/>";
		var search_btn_text="<xsl:value-of select="$search_btn_text"/>";
		var delete_btn_text="<xsl:value-of select="$delete_btn_text"/>";
	</script>
        <script langauge="javascript">
          <xsl:comment>
            <![CDATA[
	      var KCShellSTYLE2;
              var CurrentPage = 1;
              var PageCount = 20;
              
              function InitMessage()
              {
				document.getElementById('search_btn').value = search_btn_text;
				document.getElementById('delete_btn').value = delete_btn_text;
				PageChange('L');
              }
              function GetTotlePage()
              {
                var XMLObj = document.XMLDocument;                                    
                var totlePage = XMLObj.documentElement.selectNodes("//Log/*");   
		
                if( parseInt(totlePage.length/20)*20 == totlePage.length )
                  totlePage =  parseInt(totlePage.length/PageCount);
                else
                  totlePage =  parseInt(totlePage.length/PageCount) + 1;
                  
                return totlePage;
              }
              function PageChange( expr, pageindex )
              {
				if(arguments.length==1){
					pageindex = 0;
					}   

				if(pageindex==0){
					switch( expr  )
					{
						case "F":
						CurrentPage = 1;
						break;
						case "P":
						if(CurrentPage>1)
							CurrentPage -= 1;
						break;
						case "N":
						if(CurrentPage<GetTotlePage())
							CurrentPage += 1;
						break;
						case "L":
						CurrentPage = GetTotlePage();
						break;
					}
				}
				else{
					CurrentPage = pageindex;
				}

                var XSLObj = document.XSLDocument;
                var XMLObj = document.XMLDocument;                                    
                var expr = "*[position() < "+ CurrentPage*PageCount +" and position() > "+ (CurrentPage-1)*PageCount +"]";                            
                document.XSLDocument.selectSingleNode("//xsl:for-each/@select").value = expr;        
                ConXML.innerHTML = XMLObj.documentElement.transformNode(XSLObj);
		
		var TotlePage = GetTotlePage();

		PageStr="<a href=\"javascript:PageChange('L')\"><div class=\"turndiv\" onmouseover=\"this.className='turndiv1'\" onmouseout=\"this.className='turndiv'\"><img src=\"../../skin/imhist/icon_last.gif\" align=\"absmiddle\" alt=\""+lastpage+"\" />"+lastpage+"</div></a><a href=\"javascript:PageChange('N')\"><div class=\"turndiv\" onmouseover=\"this.className='turndiv1'\" onmouseout=\"this.className='turndiv'\"><img src=\"../../skin/imhist/icon_next.gif\" align=\"absmiddle\" alt=\""+nextpage+"\" />"+nextpage+"</div></a><a href=\"javascript:PageChange('P')\"><div class=\"turndiv\" onmouseover=\"this.className='turndiv1'\" onmouseout=\"this.className='turndiv'\"><img src=\"../../skin/imhist/icon_pre.gif\" align=\"absmiddle\" alt=\""+previouspage+"\" />"+previouspage+"</div></a><a href=\"javascript:PageChange('F')\"><div class=\"turndiv\" onmouseover=\"this.className='turndiv1'\" onmouseout=\"this.className='turndiv'\"><img src=\"../../skin/imhist/icon_first.gif\" align=\"absmiddle\" alt=\""+firstpage+"\" />"+firstpage+"</div></a><div class=\"turndiv2\">"+Totlepage+"<span class=\"pagenb\"> "+CurrentPage+"</span>/<span class=\"pagenb\">"+TotlePage+"</span> "+page+"</div>";

		LastPageStr="<div class=\"turndiv3\" ><img src=\"../../skin/imhist/icon_last_gray.gif\" align=\"absmiddle\" alt=\""+lastpage+"\" />"+lastpage+"</div><div class=\"turndiv3\" ><img src=\"../../skin/imhist/icon_next_gray.gif\" align=\"absmiddle\" alt=\""+nextpage+"\" />"+nextpage+"</div><a href=\"javascript:PageChange('P')\"><div class=\"turndiv\" onmouseover=\"this.className='turndiv1'\" onmouseout=\"this.className='turndiv'\"><img src=\"../../skin/imhist/icon_pre.gif\" align=\"absmiddle\" alt=\""+previouspage+"\" />"+previouspage+"</div></a><a href=\"javascript:PageChange('F')\"><div class=\"turndiv\" onmouseover=\"this.className='turndiv1'\" onmouseout=\"this.className='turndiv'\"><img src=\"../../skin/imhist/icon_first.gif\" align=\"absmiddle\" alt=\""+firstpage+"\" />"+firstpage+"</div></a><div class=\"turndiv2\">"+Totlepage+"<span class=\"pagenb\"> "+CurrentPage+"</span>/<span class=\"pagenb\">"+TotlePage+"</span> "+page+"</div>";

		FirstPageStr="<a href=\"javascript:PageChange('L')\"><div class=\"turndiv\" onmouseover=\"this.className='turndiv1'\" onmouseout=\"this.className='turndiv'\"><img src=\"../../skin/imhist/icon_last.gif\" align=\"absmiddle\" alt=\""+lastpage+"\" />"+lastpage+"</div></a><a href=\"javascript:PageChange('N')\"><div class=\"turndiv\" onmouseover=\"this.className='turndiv1'\" onmouseout=\"this.className='turndiv'\"><img src=\"../../skin/imhist/icon_next.gif\" align=\"absmiddle\" alt=\""+nextpage+"\" />"+nextpage+"</div></a><div class=\"turndiv3\" ><img src=\"../../skin/imhist/icon_pre_gray.gif\" align=\"absmiddle\" alt=\""+previouspage+"\" />"+previouspage+"</div><div class=\"turndiv3\" ><img src=\"../../skin/imhist/icon_first_gray.gif\" align=\"absmiddle\" alt=\""+firstpage+"\" />"+firstpage+"</div><div class=\"turndiv2\">"+Totlepage+"<span class=\"pagenb\"> "+CurrentPage+"</span>/<span class=\"pagenb\">"+TotlePage+"</span> "+page+"</div>";

		Onepagestr="<div class=\"turndiv3\" ><img src=\"../../skin/imhist/icon_last_gray.gif\" align=\"absmiddle\" alt=\""+lastpage+"\" />"+lastpage+"</div><div class=\"turndiv3\" ><img src=\"../../skin/imhist/icon_next_gray.gif\" align=\"absmiddle\" alt=\""+nextpage+"\" />"+nextpage+"</div><div class=\"turndiv3\" ><img src=\"../../skin/imhist/icon_pre_gray.gif\" align=\"absmiddle\" alt=\""+previouspage+"\" />"+previouspage+"</div><div class=\"turndiv3\" ><img src=\"../../skin/imhist/icon_first_gray.gif\" align=\"absmiddle\" alt=\""+firstpage+"\" />"+firstpage+"</div><div class=\"turndiv2\">"+Totlepage+"<span class=\"pagenb\"> "+CurrentPage+"</span>/<span class=\"pagenb\">"+TotlePage+"</span> "+page+"</div>";

		Onepagestr="<div class=\"turndiv3\" ><img src=\"../../skin/imhist/icon_last_gray.gif\" align=\"absmiddle\" alt=\""+lastpage+"\" />"+lastpage+"</div><div class=\"turndiv3\" ><img src=\"../../skin/imhist/icon_next_gray.gif\" align=\"absmiddle\" alt=\""+nextpage+"\" />"+nextpage+"</div><div class=\"turndiv3\" ><img src=\"../../skin/imhist/icon_pre_gray.gif\" align=\"absmiddle\" alt=\""+previouspage+"\" />"+previouspage+"</div><div class=\"turndiv3\" ><img src=\"../../skin/imhist/icon_first_gray.gif\" align=\"absmiddle\" alt=\""+firstpage+"\" />"+firstpage+"</div><div class=\"turndiv2\">"+Totlepage+"<span class=\"pagenb\"> "+CurrentPage+"</span>/<span class=\"pagenb\">"+TotlePage+"</span> "+page+"</div>";

		GotoStr = "<div class=\"turndiv4\">" + page + "</div>";
		GotoStr += "<div class=\"turndiv4\"><select class=\"selectbox\" name=\"Goto\" onChange=\"PageChange(\'\', this.value)\">";
				
		for(i = 1; i <= TotlePage; i++){
			if(i == CurrentPage){
				GotoStr += "<option value=" + i + " selected=\"selected\">" + i + "</option>";
			}
			else{
				GotoStr += "<option value=" + i + ">" + i + "</option>";
			}
		}

		GotoStr += "</select></div>";
		GotoStr += "<div class=\"turndiv5\">" + goto + "</div>";	

		if (TotlePage==1) { 
			 bottompage.innerHTML=Onepagestr;
			 toppage.innerHTML=Onepagestr;
			 return ;	
		}

		if (TotlePage==CurrentPage) {
			bottompage.innerHTML=GotoStr + LastPageStr;
			toppage.innerHTML=LastPageStr;
			//alert(toppage.innerHTML);
			return ;
		}

		if (CurrentPage==1)  {
			bottompage.innerHTML=GotoStr + FirstPageStr;
			toppage.innerHTML=FirstPageStr;
			return;
		}

		 bottompage.innerHTML=GotoStr + PageStr;
		 toppage.innerHTML=PageStr;
              }
		
		function onKeyDown(event)
		{
			if (event.keyCode == 13)
			{
				LoadMsg();
			}
		}
		
		function LoadMsg()
		{
			var searchtext = document.getElementById('search_text').value;
			external.LoadMsg(searchtext);
		}
		
		function Delete()
		{
			var delids = "";
			var checks = document.getElementsByName("del_check");
			for (var i=0; i<checks.length; i++) {
				if (checks[i].checked) {
					delids = delids + checks[i].id + "," 
				}
			}
			var searchtext = document.getElementById('search_text').value;
			external.DeleteMsg(delids, searchtext);
		}
       
          ]]>
          </xsl:comment>
        </script>

      </head>
      <body oncontextmenu="self.event.returnValue=false" onload="InitMessage()">
      <div id="warp">
	  
	<div id="toptitle">
		<ul>
			<li class="totalpage">
				<table class="fixtable" width="100%" border="0" cellpadding="0" cellspacing="0" style="table-layout:fixed;">
					<tbody>
						<tr>
							<td style="display:block;">
							<xsl:value-of select="$search_text"/>
							<input type="text" id="search_text" onKeyDown="javascript:onKeyDown(event);" style="height=20;">
							<xsl:attribute name="value"><xsl:value-of select="Log/@searchtext"/></xsl:attribute></input>
							<input type="button" id="search_btn" onclick="LoadMsg();" style="text-align:center;width=62;height=21;font:12px Verdana, Arial, Helvetica, sans-serif;" />
							</td>
							<td  id="toppage" width="375"></td>
						</tr>
					</tbody>
				</table>
			</li>
		</ul>
	</div>
	
        <div id="ConXML">
          <xsl:apply-templates select="Log"></xsl:apply-templates>
        </div>

	<div id="bottomtitle">
	<li class="totalpage">
	<input type="button" id="delete_btn" onclick="Delete()"  style="text-align:center;width=100;height=21;font:12px Verdana, Arial, Helvetica, sans-serif;"/></li>
	<li id="bottompage" class="turnpage"></li>
	</div>

	</div>

      </body>
    </html>
  </xsl:template>

  <xsl:template match="Log/HistoryCHV/CHV">

	<option>
		<xsl:attribute name="value"> 
			<xsl:value-of select="@RealFileName"/> 
		</xsl:attribute>
		<xsl:value-of select="@FirstDate"/>
		<xsl:value-of select="$tostr"/>
		<xsl:value-of select="@LastDate"/>
	</option>
					
  </xsl:template>

  <xsl:template match="Log">
    	<table id="content" border="0" width="100%" cellpadding="0" cellspacing="1" bgcolor="#BED6E0">
	<tbody>

      <xsl:for-each select="*[position() &lt; 0]">
        <xsl:sort order="ascending" select="@SessionID" data-type="number"></xsl:sort>
			<xsl:if test="@Date !='' ">
			<tr class="trwhite">
				<!--xsl:attribute name="style"> color:<xsl:value-of select="@TextColor"/>; </xsl:attribute-->
			    <xsl:if test="(@SessionID mod 2) = 1">
					<xsl:attribute name="style"> background:#E0EDFF; </xsl:attribute>
			    </xsl:if>
				<td width="70"  valign="center" color="red" id="del_op">
					<xsl:if test="@type = 0">
					<div class="username">
					<!--xsl:attribute name="style"> color:<xsl:value-of select="From/@TextColor"/>; </xsl:attribute-->
					<input name="del_check" type="checkbox"> <xsl:attribute name="id"><xsl:value-of select="@MsgID"/></xsl:attribute></input>
					<xsl:value-of select="From/User/@FriendlyName"/></div>
					</xsl:if>
					<xsl:if test="@type = 1">
					<div class="username1">
					<!--xsl:attribute name="style"> color:<xsl:value-of select="From/@TextColor"/>; </xsl:attribute-->
					<xsl:attribute name="style"> color:black; </xsl:attribute>
					<input name="del_check" type="checkbox"> <xsl:attribute name="id"><xsl:value-of select="@MsgID"/></xsl:attribute></input>
					<xsl:value-of select="From/User/@FriendlyName"/>
					<xsl:value-of select="$arrow"/>
					<xsl:value-of select="To/User/@FriendlyName"/>
					</div>
					</xsl:if>
				</td>
				<td class="tdwhite2" valign="center">
				<!--xsl:attribute name="style"> color:<xsl:value-of select="From/@TextColor"/>; </xsl:attribute-->
				<xsl:value-of select="@DateTime"/>
				</td>
				<td class="tdwhite3" valign="top">
                    <!--xsl:attribute name="style"> color:<xsl:value-of select="Text/@TextColor"/>; </xsl:attribute-->
                    <xsl:value-of select="string(Text)"/>
                </td>
			</tr>
			</xsl:if>
      </xsl:for-each>
    </tbody>
    </table>
  </xsl:template>
</xsl:stylesheet>
