-- 公用函数
-- print_globals 可以打印出所有的全局数据
-- print_table  可以打印出某个table的结构

get_global_keys = function()
	local globals = {}
	for key, value in pairs(_G) do
		local address = tostring(value)
		globals[address] = true
	end
	return globals
end

print_value = function(key, value, globals, indent, indentSize, printed)
	logger:info(string.rep(" ", indent*indentSize))
	if type(value) == "table" and not printed[value] and not globals[tostring(value)] then
		printed[value] = true
		logger:info(string.format("[%s]    =>    %s\n", tostring (key), tostring(value)))
		print_table(value, globals, indent+1, indentSize, printed)
	else
		logger:info(string.format("[%s]    =>    %s\n", tostring (key), tostring(value)))
	end
end

print_table = function(tt, globals, indent, indentSize, printed)
	globals = globals or get_global_keys()
	indent = indent or 0
	indentSize = indentSize or 4
	printed = printed or {}
	if type(tt) == "table" then
		for key, value in pairs(tt) do
			print_value(key, value, globals, indent, indentSize, printed)
		end
	else
		logger:info(tostring(tt) .. "\n")
	end
end

print_globals = function()
	local globals = get_global_keys()
	local indent = 1
	local indentSize = 4
	local printed = {}

	for key, value in pairs(_G) do
		if type(value) ~= "table" then
			print_value(key, value, globals, 0, indentSize, printed)
		end
	end

	for key, value in pairs(_G) do
		if type(value) == "table" then
			logger:info("\n["..key.."]:\n")
			print_table(value, globals, indent, indentSize, printed)
		end
	end
end


function split(str, pat)
   local t = {}  -- NOTE: use {n = 0} in Lua-5.0
   local fpat = "(.-)" .. pat
   local last_end = 1
   local s, e, cap = str:find(fpat, 1)
   while s do
      if s ~= 1 or cap ~= "" then
	 table.insert(t,cap)
      end
      last_end = e+1
      s, e, cap = str:find(fpat, last_end)
   end
   if last_end <= #str then
      cap = str:sub(last_end)
      table.insert(t, cap)
   end
   return t
end

function trim(s)
  -- from PiL2 20.4
  return (s:gsub("^%s*(.-)%s*$", "%1"))
end

--print_globals()
