
--数据库访问库
--使用方法:
--查询数据:
--for id, name in db.query("select id, name from table1 where id=? and name=?;", 123, "john")
--    --do something
--end
--更新数据:
--db.update("insert into table1 (id, name, gid) values (?, ?, ?);", 123, "john", 456)
--db.update("update table1 set name=? where id=? limit 1;", "john", 123)
--db.update("delete from table1 where id=? limit 1;", 123)
--注意: 更新数据的时候必须要加 where 条件, 不然不会执行



db = {}

require("luasql.sqlite3")
local dbEnv = luasql.sqlite3()

local makeConnection = function()
	return dbEnv:connect(CONF_DB_FILE_NAME)
end

--the global db connection
--local dbConn = makeConnection()
function db.opendb()
	return dbEnv:connect(CONF_DB_FILE_NAME)
end

function db.prepareSQL(sql, ...)
	for _, v in ipairs(arg) do
		if v == nil then
			sql = string.gsub(sql, "?", "''", 1)
		else
			if type(v) == 'number' then
				sql = string.gsub(sql, "?", tostring(v), 1)
			else
				v = string.gsub(v, "\\", "\\\\")
				v = string.gsub(v, "'", "\\'")
				v = string.gsub(v, "?", "/qU35t|0Nm@rK/")
				sql = string.gsub(sql, "?", "'"..v.."'", 1)
			end
		end
	end
	sql = string.gsub(sql, "/qU35t|0Nm@rK/", "?")
	return sql
end

function db.has_row(sql)
	local dbConn = makeConnection()

	local result = false

	local cur, err = dbConn:execute(sql)
	if cur ~= nil and cur:fetch({}, 'a') ~= nil then
		result = true
	end

	if cur ~= nil then cur:close() end
	if dbConn ~= nil then dbConn:close() end

	return result
end
function db.has_row_Commit(sql,dbConn)

	local result = false

	local cur, err = dbConn:execute(sql)
	if cur ~= nil and cur:fetch({}, 'a') ~= nil then
		result = true
	end

	if cur ~= nil then cur:close() end

	return result
end
function db.query(sql, ...)
	local dbConn = makeConnection()
	sql = db.prepareSQL(sql, unpack(arg))
	logger:debug(sql)
	local cur = dbConn:execute(sql)
	return function()
		--local v1,v2,v3 = cur:fetch()
		--if v1 or v2 or v3 then
		--	return v1, v2, v3
		--end
		--cur:close()
		return cur:fetch()
	end
end

function db.update(sql, ...)
	local sqlLower = " "..sql
	sqlLower = string.gsub(sqlLower, "\r", "")
	sqlLower = string.gsub(sqlLower, "\n", " ")
	sqlLower = string.lower(sqlLower)
	if (string.find(sqlLower, " update ") or string.find(sqlLower, " delete ")) then
		if (not string.find(sqlLower, " where ")) then
			logger:error("No 'where' in sql: "..sql)
			return
		end
	end
	sql = db.prepareSQL(sql, unpack(arg))
	logger:debug("sql: "..sql)

	local dbConn = makeConnection()
	local result, err = dbConn:execute(sql)

	if result == nil then
		logger:error(err)
	else
		dbConn:commit()
	end

	if dbConn ~= nil then dbConn:close() end

	return result
end
function db.MakeArgs(sql, ...)
	local sqlLower = " "..sql
	sqlLower = string.gsub(sqlLower, "\r", "")
	sqlLower = string.gsub(sqlLower, "\n", " ")
	sqlLower = string.lower(sqlLower)

	sql = db.prepareSQL(sql, unpack(arg))
	--logger:debug("sql: "..sql)

	return sql
end
function db.commit()
	dbConn:commit()
end

function db.existTable(tableName)
	local dbConn = makeConnection()

	local result = false
	--logger:debug("existTable: tablename = "..tableName)
	local sql = string.format("select count(*) as cnt from sqlite_master where type='table' and name='%s'", tableName)

	--logger:debug("sql: "..sql)

	local cur, err = dbConn:execute(sql)
	if cur ~= nil  then
		local t = cur:fetch({}, 'a')

		if t ~= nil then
			if tonumber(t.cnt) == 0 then
				result = false
			else
				result = true
			end
		else
			result = false
		end
		--result = (t ~= nil and t.cnt ~= 0)
	else
		logger:error(err)
	end

	if cur ~= nil then cur:close() end

	if dbConn ~= nil then dbConn:close() end

	return result
end

return db
