

--内部接口:获取最大的用户 cid
function nextmaxcid()
	local dbConn = db.opendb()

	local maxcid = 0

	local cur,err
	if db.has_row("select cid from t_contactinfo LIMIT 1;") then

		cur, err = dbConn:execute("select max(cid)+1 AS cid from t_contactinfo")

		if cur == nil then
			logger:debug(err)
		end

		maxcid = cur:fetch({}, 'a').cid
	end

	if cur ~= nil then cur:close() end
	if dbConn ~= nil then dbConn:close() end

	logger:debug(string.format("get_max_cid's result: %d", maxcid))
	return maxcid
end

--外部接口
function addContact(contactInfoJson) --添加一个联系人
	logger:debug("addContact: "..contactInfoJson)

	local contactInfo = json.decode(contactInfoJson)

	contactInfo.gid = contactInfo.gid or 0

	if contactInfo.birthday == "" then
		contactInfo.birthday = "0" --服务器要求必须有值
	end

	if (contactInfo and string.len(contactInfo.nickname)) then
		if bOnLine  then
			local resultJson = callService("addContact", {
				uid = CONF_USER_ID,
				contactinfo = {
					gid = contactInfo.gid,
					kcuid = contactInfo.kcuid,
					nickname=contactInfo.nickname,
					mobile1=contactInfo.mobile1,
					mobile2=contactInfo.mobile2,
					homephone1=contactInfo.homephone1,
					homephone2=contactInfo.homephone2,
					email1=contactInfo.email1,
					email2=contactInfo.email2,
					msn1=contactInfo.msn1,
					msn2=contactInfo.msn2,
					qq1=contactInfo.qq1,
					qq2=contactInfo.qq2,
					fax1=contactInfo.fax1,
					fax2=contactInfo.fax2,
					company=contactInfo.company,
					picture=contactInfo.picture,
					department=contactInfo.department,
					position=contactInfo.position,
					postcode=contactInfo.postcode,
					college=contactInfo.college,
					personweb=contactInfo.personweb,
					personnote=contactInfo.personnote,
					street=contactInfo.street,
					pybm=contactInfo.pybm,
					sex=contactInfo.sex,
					birthday=contactInfo.birthday,
					area=contactInfo.area
				}
			})

			local result = json.decode(resultJson)
			if (result.error) then
				logger:debug("-------------addContact the result is error")
				return resultJson --error return
			end

			if (result.uid and result.group_version) then
				db.update("insert into t_contactinfo (cid, gid, nickname,kcuid,mobile1,mobile2"..
					",homephone1,homephone2,email1,email2,qq1,qq2"..
					",msn1,msn2,company"..
					",sex,birthday,area,fax1,fax2"..
					",department,position,street,postcode,college,personweb"..
					",personnote,onlinenote,invite,cardconfig,pybm,sex,birthday,area,picture) "..
					"values (?, ?, ?, ?, ? , ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ? ,?, ?, ?, ?,?);"
					, result.cid, result.gid, contactInfo.nickname,contactInfo.kcuid,contactInfo.mobile1,contactInfo.mobile2,
					contactInfo.homephone1,contactInfo.homephone2,contactInfo.email1,contactInfo.email2,contactInfo.qq1,contactInfo.qq2,
					contactInfo.msn1,contactInfo.msn2,contactInfo.company,
					contactInfo.sex,contactInfo.birthday,contactInfo.area,contactInfo.fax1,contactInfo.fax2,
					contactInfo.department,contactInfo.position,contactInfo.street,contactInfo.postcode,contactInfo.college,contactInfo.personweb,
					contactInfo.personnote,contactInfo.onlinenote,contactInfo.invite,contactInfo.cardconfig,contactInfo.pybm,
					contactInfo.sex,contactInfo.birthday,contactInfo.area, contactInfo.picture)

				--更新本地状态
				db.update("update t_contgroup set gversion="..result.group_version.." where gid="..result.gid..";")
				if contactInfo.kcuid ~= nil and contactInfo.kcuid ~= 0 and contactInfo.kcuid ~= '0' then
					db.update("delete from t_kconline where account="..contactInfo.kcuid..";")
					db.update("insert into t_kconline(account,status,onlinelevel) values(?,?,?)",contactInfo.kcuid,contactInfo.kcstatus,contactInfo.onlinelevel)
				end
				db.update("update t_version set versionNumber="..result.global_version .. " where 1;")
				return json.encode({idkey=result.cid})
			end
		else -- 离线新增联系人
			-- 直接将当前资料写入本地数据库，标志为 1
			--获取当前最大的 cid
			local nmaxcid = nextmaxcid()

			db.update("insert into t_contactinfo (cid, gid, nickname,kcuid,mobile1,mobile2"..
					",homephone1,homephone2,email1,email2,qq1,qq2"..
					",msn1,msn2,company"..
					",sex,birthday,area,fax1,fax2"..
					",department,position,street,postcode,college,personweb"..
					",personnote,onlinenote,invite,cardconfig,pybm ,rowstatus,picture) "..
					"values (?, ?, ?, ?, ? , ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ? ,? , 1,?);"
					, nmaxcid, contactInfo.gid, contactInfo.nickname,contactInfo.kcuid,contactInfo.mobile1,contactInfo.mobile2,
					contactInfo.homephone1,contactInfo.homephone2,contactInfo.email1,contactInfo.email2,contactInfo.qq1,contactInfo.qq2,
					contactInfo.msn1,contactInfo.msn2,contactInfo.company,
					contactInfo.sex,contactInfo.birthday,contactInfo.area,contactInfo.fax1,contactInfo.fax2,
					contactInfo.department,contactInfo.position,contactInfo.street,contactInfo.postcode,contactInfo.college,contactInfo.personweb,
					contactInfo.personnote,contactInfo.onlinenote,contactInfo.invite,contactInfo.cardconfig,contactInfo.pybm, contactInfo.picture)
		end
	end
end
--根据cid获取当前用户所在分组
function groupidbycid(cid)
	logger:debug("groupidbycid: "..cid)
	local dbConn = db.opendb()

	local gidTemp = 0

	local cur,err = dbConn:execute("select gid from t_contactinfo where cid="..cid..";")
	if cur ~= nil then
		gidTemp = cur:fetch({}, 'a').gid
	end
	cur:close()
	dbConn:close()

	return gidTemp
end

--外部接口
function deleteContact(contactId) --删除一个联系人
	logger:debug("deleteContact: "..contactId)

	if (tonumber(contactId) > 0) then
		if bOnLine then
			local resultJson = callService("delContact",{uid = CONF_USER_ID,cid = contactId})

			--uid, cid, gid, global_version, group_version
			local result = json.decode(resultJson)
			if (result.error) then
				return resultJson --error return
			end
			local local_gid = 0
			if (result.group_version) then
				local_gid = groupidbycid(contactId)

				logger:debug("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!---gid:"..local_gid)
				db.update("delete from t_contactinfo where cid=?;", tonumber(contactId))
				db.update("update t_contgroup set gversion="..result.group_version.." where gid="..local_gid..";")
				db.update("update t_version   set versionNumber="..result.global_version.." where 1;")
			end
		else -- 离线处理
			--如果是离线新增的，则直接删除
			if db.has_row("select cid from t_contactinfo where cid="..contactId.." and rowstatus=1;") then
				db.update("delete from t_contactinfo where cid="..contactId.." and rowstatus=1;")
			else
				db.update("update t_contactinfo set rowstatus=3 where cid=?;", tonumber(contactId))
			end
		end
	end
end

function editContact(contactInfoJson) --3.修改联系人信息（修改所在组、名称、手机、固话、qq、msn、邮件等等）
	logger:debug("editContact: "..contactInfoJson)

	local cont = json.decode(contactInfoJson)
	logger:debug("decode:contactInfo:begin-------------------------" )

	if cont.birthday == "" then
		cont.birthday = "0" --服务器要求必须有?
	end


	if (cont and cont.gid and cont.cid) then
			local sql = "update t_contactinfo set ";
			local criterions = {};

			--修改
			for i,v in pairs(cont) do
				if type(cont[i]) == 'string' then
					table.insert(criterions, {column=i, prop=i, value=(cont[i] or '')})
				else
					table.insert(criterions, {column=i, prop=i, value=(cont[i] or 0)})
				end
			end

			local n = table.getn(criterions);
			logger:debug("================================= the table.getn is :"..n)
			if (n) then
				if bOnLine then -- 在线情况
					--调用远程服务
					local resultJson = callService("updateContact", {
								uid=CONF_USER_ID,
								contactinfo = {
										gid = cont.gid,
										cid = cont.cid,
										kcuid = cont.kcuid,
										nickname=cont.nickname,
										mobile1=cont.mobile1,
										mobile2=cont.mobile2,
										homephone1=cont.homephone1,
										homephone2=cont.homephone2,
										email1=cont.email1,
										email2=cont.email2,
										msn1=cont.msn1,
										msn2=cont.msn2,
										qq1=cont.qq1,
										qq2=cont.qq2,
										fax1=cont.fax1,
										fax2=cont.fax2,
										company=cont.company,
										department=cont.department,
										position=cont.position,
										postcode=cont.postcode,
										college=cont.college,
										personweb=cont.personweb,
										personnote=cont.personnote,
										street=cont.street,
										pybm=cont.pybm,
										sex=cont.sex,
										birthday=cont.birthday,
										area=cont.area
								}});

					local result = json.decode(resultJson);
					if (result.error) then
						logger:debug("the updateContact result is error")
						return resultJson;
					end
					db.update("update t_contgroup set gversion="..result.group_version.." where gid="..cont.gid)
					db.update("update t_version set versionNumber="..result.global_version.." where 1;")
				end

				logger:debug("mobile1："..cont.mobile1.." mobile2: "..cont.mobile2);
				values = {} -- for database
				n = table.getn(criterions);
				logger:debug("the updateContact remote run is ok")

				local sql2 = "update t_contactinfo set ";
				for i, v in ipairs(criterions) do
					if v.column ~= 'onlinelevel' and v.column ~='kcstatus' then
						sql2 = sql2..v.column.."=?"
						if (i < n) then
							sql2 = sql2..", "
						else
							sql2 = sql2.." "
						end
						table.insert(values, v.value)
					end
				end

				--补充一条离线命令,如果改用户是离线新增的，则不修改标志
				if not bOnLine then
					if db.has_row("select cid from t_contactinfo where cid="..cont.cid.." and rowstatus=1;") then
						--不再修改标志
					else
						sql2 = sql2..",rowstatus=2 "
					end
				end

				sql2 = sql2.." where  cid = ?;"
				table.insert(values, tonumber(cont.cid))
				db.update(sql2, unpack(values))

				if bOnLine and cont.kcuid ~= nil and cont.kcuid ~= 0 and cont.kcuid ~= '0'  then

					db.update("delete from t_kconline where account="..cont.kcuid..";")
					db.update("insert into t_kconline(account,status,onlinelevel) values(?,?,?)",cont.kcuid,cont.kcstatus,cont.onlinelevel)
				end


				return 1;
			end
	end
end

--外部接口：批量更新状态
--{"nstatus":[{"kcuid":"10001","status":0,"onlinelevel":0},{"kcuid":"10001","status":0,"onlinelevel":0},{}]}
function modify_morekcstatus(var)
	logger:debug("modify_morekcstatus: begin")

	local params = json.decode(var)
	if  table.getn(params.nstatus) == 0 then
		return
	end

	--优化批量插入数据，数据库连接打开、关闭 只执行一次
	local dbConn = db.opendb()
	dbConn:setautocommit(false)
	local sql

	for j=1,table.getn(params.nstatus) do
		local params = json.decode(json.encode(params.nstatus[j]))

		if params.kcuid ~= 0 then --  只处理存在kcuid的情况
			local onlinelevel
			onlinelevel = params.onlinelevel or 1
			local hasrecord = db.has_row_Commit("select account from t_kconline where account='"..params.kcuid.."';",dbConn)

			if params.kcuid ~= nil and params.kcuid ~= 0 and params.kcuid ~= '0'  then
				if hasrecord then
					dbConn:execute("update t_kconline set status="..params.status.." where account='"..params.kcuid.."';")
				else
					sql = db.MakeArgs("insert into t_kconline(account,status,onlinelevel) values(?,?,?);",
					params.kcuid,params.status,onlinelevel)
					dbConn:execute(sql)
				end
			end
		end
	end

	dbConn:commit()
	if dbConn ~= nil then dbConn:close() end
	logger:debug("modify_morekcstatus: end")
end


--外部接口
--{"kcuid":"10001","status":0,"onlinelevel":0}
function modify_kcstatus(var)
	logger:debug("modify_kcstatus: ")

	local params = json.decode(var)
	if params.kcuid == nil or params.kcuid == 0 or params.kcuid == '0' then -- 如果当前无kcuid则直接返回
		return
	end

	local hasrecord = db.has_row("select account from t_kconline where account='"..params.kcuid.."';")

	local onlinelevel
	onlinelevel = params.onlinelevel or 1

	if hasrecord then
		db.update("update t_kconline set status="..params.status.." where account='"..params.kcuid.."';")
	else
		db.update("insert into t_kconline(account,status,onlinelevel) values(?,?,?);",
		params.kcuid,params.status,onlinelevel)
	end
end
--外部接口
--{"qq":"123456","status":0}
function modify_qqstatus(var)
	logger:debug("modify_qqstatus: "..var)

	local params = json.decode(var)
	if params.qq == nil or params.qq == 0 or params.qq == '0' then
		return
	end

	local hasrecord = db.has_row("select account from t_qqonline where account='"..params.qq.."';")
	if hasrecord then
		db.update("update t_qqonline set status="..params.status.." where account='"..params.qq.."';")
	else
		db.update("insert into t_qqonline(account,status) values(?,?);",
		params.qq,params.status)
	end
end
--直接获取指定帐号的状态
function getStatus(var)
	for st in db.query("select status from t_kconline where account='"..var.."'") do
		logger:debug("getStatus:the st="..st)
		return st
	end

	return 0
end

--外部接口
--{"msn":"123xx","status":0}
function modify_msnstatus(var)
	logger:debug("modify_msnstatus: "..var)

	local params = json.decode(var)
	local hasrecord = db.has_row("select account from t_msnonline where account='"..params.msn.."';")

	if hasrecord then
		db.update("update t_msnonline set status="..params.status.." where account='"..params.msn.."';")
	else
		db.update("insert into t_msnonline(account,status) values(?,?);",
		params.msn,params.status)
	end
end

--清除远程通讯录所有数据
function killall()
	logger:debug("killall")
	local cids = {}

	local dbConn = db.opendb()
	local cur,err = dbConn:execute("select cid from t_contactinfo where 1;")

	if cur ~= nil then
		local row = cur:fetch({}, 'a')

		while row ~= nil do
			cids[#cids+1] = row.cid
			row = cur:fetch(row, 'a')
		end
	end

	cur:close()
	dbConn:close()

	for _,cid in ipairs(cids) do
		callService("delContact", {uid=CONF_USER_ID, cid = tonumber(cid)})
	end
end

