--[[
	该模块主要处理消息的存取
	MSGTYPE_SYS = 0,			//系统消息
	MSGTYPE_PERSONAL=1,			//普通聊天信息
	MSGTYPE_PHONE=2,			//电话消息
	MSGTYPE_MOBILE=3,			//手机来电消息
	MSGTYPE_CROWD=4,			//群聊消息
	MSGTYPE_DISCUS=5,			//讨论组消息
	MSGTYPE_UPMESSAGE=6,		//上行短信
	MSGTYPE_ADDFRIEND=7,		//加好友申请(个人)
	MSGTYPE_ADDGROUPFRIEND=8,	//加好友申请(群组)
	MSGTYPE_EMAIL=9				//邮件冒泡
]]--

gAllMsg = {}
function savemsg(var)
	--var:the database input
	local inf = json.decode(var)
	--不能用统一的表结构来存储
	local tb ={}

	-- 检查时候同类消息超过100条，如果超过，则反向删除 1条，因为数据总是每次进入 1条
	if  checksamecnt(tonumber(inf.types),tonumber(inf.id)) > 99 then
		delOne(tonumber(inf.types),tonumber(inf.id))
	end

	if  tonumber(inf.types) == 4 or tonumber(inf.types) == 5 then
			tb = {
					types =tonumber(inf.types) or 0,
					names = inf.names or "",
					msg = inf.msg or "",
					id = tonumber(inf.id) or 0,
					uid = tonumber(inf.uid) or 0,
					bhasheadpic = inf.bhasheadpic or "",
					strheadpic = inf.strheadpic or "",
					strrevtime = inf.strrevtime or "",
					strNickName = inf.strNickName or ""
				}
	else
		-- 普通聊天信息 同一个人的只能存储一次
		if gAllMsg ~= nil and getlen(gAllMsg) ~= 0 and tonumber(inf.types) == 1  then
			for i,v in ipairs(gAllMsg) do
				if tonumber(inf.id) == v.id then
					return
				end
			end
		end

		--存储--fromuid
			tb ={
					types = tonumber(inf.types) or 0,
					id = tonumber(inf.id) or 0,
					KCStatus = tonumber(inf.KCStatus) or 0,
					nSubType = tonumber(inf.nSubType) or 0,
					strMsg = inf.strMsg or "",
					strName = inf.strName or "",
					szAccount = tonumber(inf.szAccount) or 0,
					szType = inf.szType or "",
					token = tonumber(inf.token) or 0
				}
	end

	table.insert(gAllMsg,tb)
	--print_table(gAllMsg)
end

--检查同类消息的条数
function checksamecnt(types,id)
	if gAllMsg == nil then return end
	local nCnt = 0
	for i,v in ipairs(gAllMsg) do
		if types == v.types and id == v.id then
			nCnt = nCnt + 1
		end
	end

	return nCnt
end

--删除指定类型的第一条消息
function delOne(types,id)
	if gAllMsg == nil then return end

	for i,v in ipairs(gAllMsg) do
		if types == v.types and id == v.id then
			table.remove(gAllMsg,i)--1条

			return
		end
	end
end

--每次提取一组消息：具有随即性
function takeoffmsg()
	--print_table(gAllMsg)

	local bags={}
	local temp_type,temp_id

	if gAllMsg == nil then
		return ""
	end
	local bag={}

	for i,v in ipairs(gAllMsg) do--Index,column
		if i == 1 then
			temp_type = v.types
		end

		if  temp_type == 4 or temp_type == 5 then
			--取第一条记录
			if i == 1 then
				temp_id = v.id
			end
			--如果和第一条消息一致，则都提取
			if temp_type == v.types and temp_id == v.id then
				--take all the same message
				bag = {types=v.types,names=v.names,msg=v.msg,id=v.id,uid=v.uid,bhasheadpic=v.bhasheadpic,strheadpic=v.strheadpic,strrevtime=v.strrevtime,strNickName=v.strNickName}
				table.insert(bags, bag)
			end
		else
			if i == 1 then
				temp_id = v.id
			end
			if temp_type == v.types and temp_id == v.id then
				bag = {types=v.types,id=v.id,KCStatus=v.KCStatus,nSubType=v.nSubType,strMsg=v.strMsg,strName=v.strName,szAccount=v.szAccount,szType=v.szType,token=v.token}
				table.insert(bags, bag)
			end
		end
	end

	--print_table(bag)
	--提取消息完成，清除缓存中已经提取的消息
	--if  temp_type == 4 or temp_type == 5 then
		clearmsg(temp_type, temp_id, false)
	--else
		--clearIndex(1)--其他情况下默认取第一条
	--end

	return json.encode(bags);
end

--指定类型提取消息:如果是IM消息，则id默认为0
function takeoffinf(var)
	--type,id,Numbers   群组编号，idkey, Numbers(当是系统消息时只取一条)
	local inf = json.decode(var)
	inf.type = tonumber(inf.type) or 0
	inf.id = tonumber(inf.id) or 0
	inf.Numbers = tonumber(inf.Numbers) or 0

	logger:debug("takeoffinf args: type="..inf.type..",id="..inf.id..",Numbers="..inf.Numbers)

	if gAllMsg == nil then
		return ""
	end

	local bags= {}
	local bag = {}
	local iIndex = 1

	for i,v in ipairs(gAllMsg) do--Index,column
		iIndex = i -- 需要清除的
		logger:debug("ipairs: the type is ="..v.types)
		if inf.type == 4 or inf.type == 5 then
			if inf.type == v.types and inf.id == v.id then
				bag = {types=v.types,names=v.names,msg=v.msg,id=v.id,uid=v.uid,bhasheadpic=v.bhasheadpic,strheadpic=v.strheadpic,strrevtime=v.strrevtime,strNickName=v.strNickName}
				table.insert(bags, bag)
			end
		--
		elseif inf.type == v.types then
			if inf.id ~= 0 then
			if inf.id == v.szAccount then --面板上的 cid
					bag = {types=v.types,id=v.id,KCStatus=v.KCStatus,nSubType=v.nSubType,strMsg=v.strMsg,strName=v.strName,szAccount=v.szAccount,szType=v.szType,token=v.token}
					table.insert(bags, bag)
				end
			else
				bag = {types=v.types,id=v.id,KCStatus=v.KCStatus,nSubType=v.nSubType,strMsg=v.strMsg,strName=v.strName,szAccount=v.szAccount,szType=v.szType,token=v.token}
				table.insert(bags, bag)
			end
		end

		if inf.Numbers == 1 then--系统消息提前返回
			clearIndex(iIndex)
			return json.encode(bags);
		end
	end

	clearmsg(inf.type, inf.id ,true)

	return json.encode(bags);
end

--获取指定位置行的消息类型
function takerowmsgtype(var)
	--row
	local inf = json.decode(var)
	inf.row = inf.row or 1

	if gAllMsg == nil then
		return ""
	end

	if checkmsgrows() > 0 then
		for i,v in ipairs(gAllMsg) do
			logger:debug("type ============i="..i..",row ="..inf.row)
			if i ==  inf.row then
				return gAllMsg[i].types
			end
		end
	end

	return 1
end


--计算指定类型指定编号的数据条数
function calcnumber(var)
	--type,id,uid
	local inf = json.decode(var)
	inf.type = tonumber(inf.type) or 0
	inf.id = tonumber(inf.id) or 0

	--logger:debug("calcnumber")
	if gAllMsg == nil then
		return 0
	end

	--logger:debug("calcnumber2")
	local nRows = 0
	for i,v in ipairs(gAllMsg) do--Index,column
		if v.types == 4 or v.types == 5 then
			if inf.type == v.types and inf.id == v.id  then
				nRows = nRows + 1
			end
		else
			if inf.type == tonumber(v.types) then
				nRows = nRows + 1
			end
		end
	end

	return nRows
end



--计算指定子类型指定编号的数据条
function calcnumbersub(var)
	--type,id,uid
	local inf = json.decode(var)
	inf.type = tonumber(inf.type) or 0
	inf.id = tonumber(inf.id) or 0
	inf.SubType = tonumber(inf.SubType) or 0

	--logger:debug("calcnumber")
	if gAllMsg == nil then
		return 0
	end

	--logger:debug("calcnumber2")
	local nRows = 0
	for i,v in ipairs(gAllMsg) do--Index,column
		if v.types == 4 or v.types == 5 then
			if inf.type == v.types and inf.id == v.id  then
				nRows = nRows + 1
			end
		else
			if inf.type == tonumber(v.types) and inf.SubType == tonumber(v.nSubType) then
				nRows = nRows + 1
			end
		end
	end

	return nRows
end

--chechk the table has rows or not,return the diffrent count of the msg,by userid or crowdid or discussid
function checkmsgrows()
	local rows = getlen(gAllMsg)
	return rows
end
--functions:get the length of the table
function getlen(t)
	if t == nil then return 0 end
	local n = table.getn(t)
	if n > 0 then return n end

	for x,y in pairs(t) do
		n = n + 1
	end
	return n
end

--清除缓存信息
function clearmsg(types, id , cid)
	local rows = getlen(gAllMsg)

	if rows == 0 then return end
	local i=0
	for i=rows,1,-1 do--remove the data by the desc
		if types == 4 or types == 5 then
			if types == gAllMsg[i].types and id == gAllMsg[i].id then
				table.remove(gAllMsg,i)
			end
		else
			if cid then
				if types == gAllMsg[i].types and id == gAllMsg[i].szAccount then
					table.remove(gAllMsg,i)
				end
			else
				if types == gAllMsg[i].types and id == gAllMsg[i].id then
					table.remove(gAllMsg,i)
				end
			end
		end
	end
end

--清除指定序号的缓存信息
function clearIndex(iIndex)
	local rows = getlen(gAllMsg)
	logger:debug("clearIndex:getN="..rows)
	if rows >= iIndex then
		table.remove(gAllMsg,iIndex)
	end
	if gAllMsg == nil then
		logger:debug("clearIndex: clear over")
	else
		rows = getlen(gAllMsg)
		logger:debug("clearIndex:getN="..rows)
	end

end

