﻿//文本
class 文本 {
	static 取文本长度(str) {
		if (str != null) {
			return str.length;
		} else {
			return 0;
		}
	}

	static 取文本行数(str) {
		var lines = 0;
		try {
			lines = ((str.match(/[^\n]*\n[^\n]*/gi).length));
		} catch (e) {
			lines = 0;
		}
		lines++;
		return lines;
	}

	static 寻找文本(str, sub, index) {
		if (str == null || sub == null) {
			return -1;
		}
		return str.indexOf(sub, index);
	}

	static 倒找文本(str, sub, index) {
		if (str == null || sub == null) {
			return -1;
		}
		return str.lastIndexOf(sub, index);
	}

	static 取文本中间(str, start, len) {
		if (str == null || start == null) {
			return "";
		}
		return str.substr(start, len);
	}

	static 取文本左边(str, len) {
		if (isNaN(len) || len == null) {
			len = str.length;
		} else {
			if (parseInt(len) < 0 || parseInt(len) > str.length) {
				len = str.length;
			}
		}
		return str.substr(0, len);
	}

	static 取文本右边(str, len) {
		if (isNaN(len) || len == null) {
			len = str.length;
		} else {
			if (parseInt(len) < 0 || parseInt(len) > str.length) {
				len = str.length;
			}
		}
		return str.substring(str.length - len, str.length);
	}

	static 取指定文本(待取文本, 左边文本, 右边文本) {
		var pattern = new RegExp(左边文本 + "(.*?)" + 右边文本, "g");
		var result = new Array(0);
		while (pattern.exec(待取文本) != null) {
			//console.log(RegExp.$1);
			result.push(RegExp.$1);
		}
		return result;
	}
	
	static 文本替换(欲被替换的文本, 起始替换位置 = 1, 替换长度 = 0, 用作替换的文本 = '') {
	    var tempStr = 欲被替换的文本.split('')
	    tempStr.splice(起始替换位置 - 1, 替换长度, 用作替换的文本)
	    return tempStr.join('')
	}

	static 子文本替换(str, a, b) {
		if (str == null || a == null || b == null) {
			return "";
		}
		var regExp = new RegExp(a, "g");
		return str.replace(regExp, b);
	}

	static 分割文本(str, separator) {
		if (str == null || separator == null) {
			return null;
		}
		return str.split(separator);
	}
	
	static 取空白文本(重复次数) {
	    var temp = '', i = 0
	    while (i < 重复次数) {
	        temp += ' '
	        i++
	    }
	    return temp
	}
	
	static 取重复文本(重复次数, 待重复文本) {
	    var temp = '', i = 0
	    while (i < 重复次数) {
	        temp += 待重复文本
	        i++
	    }
	    return temp
	}

	static 到大写(str) {
		if (str == null) {
			return "";
		}
		return str.toUpperCase();
	}

	static 到小写(str) {
		if (str == null) {
			return "";
		}
		return str.toLowerCase();
	}
	
	static 到半角(str) {
		if (str == null) {
			return "";
		}
		var tmp = ''
		    for (var i = 0; i < str.length; i++) {
		        if (str.charCodeAt(i) > 65248 && str.charCodeAt(i) < 65375) {
		            tmp += String.fromCharCode(str.charCodeAt(i) - 65248)
		        }
		        else {
		            tmp += String.fromCharCode(str.charCodeAt(i))
		        }
		    }
		return tmp
	}
	
	static 到全角(str) {
		if (str == null) {
			return "";
		}
		var tmp = ''
		    for (var i = 0; i < str.length; i++) {
		        if (str.charCodeAt(i) == 32) {
		            tmp = tmp + String.fromCharCode(12288)
		        }else if (str.charCodeAt(i) < 127) {
		            tmp = tmp + String.fromCharCode(str.charCodeAt(i) + 65248);
		        }
		    }
		return tmp
	}
	
	static 删首空(str) {
		if (str == null) {
			return "";
		}
		return str.replace(/^ +/g, '');
	}
	
	static 删尾空(str) {
		if (str == null) {
			return "";
		}
		return str.replace(/ +$/g, '');
	}
	
	static 删首尾空(str) {
		if (str == null) {
			return "";
		}
		return str.replace(/(^\s*)|(\s*$)/g, "");
	}

	static 删全部空(str) {
		if (str == null) {
			return "";
		}
		return str.replace(/\s+/g, "");
	}
}
//数组
class 数组 {
	static 取成员数(arr) {
		if (arr != null) {
			return arr.length;
		} else {
			return 0;
		}
	}

	static 合并数组(arr1, arr2) {
		if (arr1 == null) {
			return arr2;
		}
		if (arr2 == null) {
			return arr1;
		}
		return arr1.concat(arr2);
	}

	static 连接成员(arr, separator) {
		if (arr == null || separator == null) {
			return "";
		}
		return arr.join(separator);
	}

	static 加入首成员(arr, element) {
		if (arr == null) {
			return 0;
		}
		arr.unshift(element);
		return arr.length;
	}

	static 加入尾成员(arr, element) {
		if (arr == null) {
			return 0;
		}
		arr.push(element);
		return arr.length;
	}

	static 删除首成员(arr) {
		if (arr == null) {
			return 0;
		}
		arr.shift();
		return arr.length;
	}

	static 删除尾成员(arr) {
		if (arr == null) {
			return 0;
		}
		arr.pop();
		return arr.length;
	}

	static 删除成员(arr, index) {
		if (arr == null) {
			return 0;
		}
		arr.splice(index, 1);
		return arr.length;
	}

	static 清空数组(arr) {
		if (arr == null) {
			return 0;
		}
		arr.splice(0, arr.length);
		return arr.length;
	}

	static 翻转顺序(arr) {
		if (arr != null) {
			arr.reverse();
		}
	}

	static 排列顺序(arr, type) {
		if (arr != null) {
			if (type == 1) {
				arr.sort();
			} else {
				arr.sort(sortNumber);
			}
		}
	}
}

function sortNumber(a, b) {
	return a - b
}
//转换
class 转换 {
	static 到文本(value) {
		return "" + value;
	}

	static 到数值(str) {
		return Number(str);
	}

	static 到十六进制(value) {
		return value.toString(16);
	}

	static 到十进制(str) {
		return parseInt(str, 16);
	}

	static 代码转字符() {
		var result = "";
		for (var i = 0; i < arguments.length; i++) {
			result = result + String.fromCharCode(arguments[i]);
		}
		return result;
	}

	static 字符转代码(str) {
		return str.charCodeAt(0);
	}

	static 文本转json(str) {
		return JSON.parse(str);
	}

	static json转文本(json) {
		return JSON.stringify(json);
	}

	static 取数据类型(value) {
		var a = typeof(value);
		switch (a) {
			case "number":
				return 1;
				break;
			case "string":
				return 2;
				break;
			case "boolean":
				return 3;
				break;
			case "object":
				return 4;
				break;
			case "function":
				return 5;
				break;
			case "undefined":
				return 6;
				break;
			default:
				return 6;
		}
	}

	static 是否为非数字(value) {
		return isNaN(value);
	}

	static 转换为金额(n) {
		var fraction = ["角", "分"];
		var digit = ["零", "壹", "贰", "叁", "肆", "伍", "陆", "柒", "捌", "玖"];
		var unit = [
			["元", "万", "亿"],
			["", "拾", "佰", "仟"]
		];
		var head = n < 0 ? "欠" : "";
		n = Math.abs(n);
		var s = "";
		for (var i = 0; i < fraction.length; i++) {
			s += (digit[Math.floor(n * 10 * Math.pow(10, i)) % 10] + fraction[i]).replace(/零./, "");
		}
		s = s || "整";
		n = Math.floor(n);
		for (var i = 0; i < unit[0].length && n > 0; i++) {
			var p = "";
			for (var j = 0; j < unit[1].length && n > 0; j++) {
				p = digit[n % 10] + unit[1][j] + p;
				n = Math.floor(n / 10);
			}
			s = p.replace(/(零.)*零$/, "").replace(/^$/, "零") + unit[0][i] + s;
		}
		return head + s.replace(/(零.)*零元/, "元").replace(/(零.)+/g, "零").replace(/^整$/, "零元整");
	}
}
//数学
class 数学 {

	static 取随机数(min, max) {
		return parseInt(Math.random() * (max - min + 1) + min, 10);
	}

	static 取绝对值(value) {
		return Math.abs(value);
	}

	static 取余数(a, b) {
		return a % b;
	}

	static 取整数(value) {
		return parseInt(value);
	}

	static 取次方(a, b) {
		return Math.pow(a, b);
	}

	static 四舍五入(value, num) {
		//return value.toFixed(num);
		return Math.round(value * Math.pow(10, num)) / Math.pow(10, num);
	}

	static 表达式计算(value) {
		return eval(value);
	}
}
//时间日期
class 时间 {
	static 取当前日期时间() {
		return new Date();
	}

	static 取现行日期() {
		var date = new Date();
		var month = date.getMonth() + 1;
		var strDate = date.getDate();
		if (month >= 1 && month <= 9) {
			month = "0" + month;
		}
		if (strDate >= 0 && strDate <= 9) {
			strDate = "0" + strDate;
		}
		var currentdate = date.getFullYear() + "/" + month + "/" + strDate;
		return currentdate;
	}

	static 取现行时间() {
		var date = new Date();
		var getHours = date.getHours();
		var getMinutes = date.getMinutes();
		var getSeconds = date.getSeconds();
		if (getHours >= 0 && getHours <= 9) {
			getHours = "0" + getHours;
		}
		if (getMinutes >= 0 && getMinutes <= 9) {
			getMinutes = "0" + getMinutes;
		}
		if (getSeconds >= 0 && getSeconds <= 9) {
			getSeconds = "0" + getSeconds;
		}
		var currenttime = getHours + ":" + getMinutes + ":" + getSeconds;
		return currenttime;
	}

	static 到日期时间(年, 月, 日, 时, 分, 秒) {
		return new Date(年, 月 - 1, 日, 时, 分, 秒);
	}

	static 到日期时间2(value) {
		return new Date(value);
	}

	static 时间到文本(date) {
		var month = date.getMonth() + 1;
		var strDate = date.getDate();
		if (month >= 1 && month <= 9) {
			month = "0" + month;
		}
		if (strDate >= 0 && strDate <= 9) {
			strDate = "0" + strDate;
		}
		var currentdate = date.getFullYear() + "/" + month + "/" + strDate;

		var getHours = date.getHours();
		var getMinutes = date.getMinutes();
		var getSeconds = date.getSeconds();
		if (getHours >= 0 && getHours <= 9) {
			getHours = "0" + getHours;
		}
		if (getMinutes >= 0 && getMinutes <= 9) {
			getMinutes = "0" + getMinutes;
		}
		if (getSeconds >= 0 && getSeconds <= 9) {
			getSeconds = "0" + getSeconds;
		}
		var currenttime = getHours + ":" + getMinutes + ":" + getSeconds;

		return currentdate + " " + currenttime;
	}

	static 取时间间隔(a, b) {
		return a.getTime() - b.getTime();
	}

	static 取年(time) {
		return time.getFullYear();
	}

	static 取月(time) {
		return time.getMonth() + 1;
	}

	static 取日(time) {
		return time.getDate();
	}

	static 取时(time) {
		return time.getHours();
	}

	static 取分(time) {
		return time.getMinutes();
	}

	static 取秒(time) {
		return time.getSeconds();
	}

	static 取星期几(time) {
		return time.getDay();
	}

	static 取时间戳(time) {
		return Date.parse(time);
	}

	static 时间戳到时间(value) {
		return new Date(value);
	}
}
//正则
class 正则 {
	constructor() {
	    this.res;
	    this.sl = 0;
	    this.arr;
	    this.bd = "";
	    this.zz = "";
	  }
	static 创建正则(所有文本, 正则文本, 不区分大小写, 多行查找) {
		this.bd = "";
		this.zz = "";
		this.zz = 正则文本;
		var zz = "g";
		if (不区分大小写) {
			zz = zz + "i";
			this.bd = this.bd + "i";
		}
		if (多行查找) {
			zz = zz + "m";
			this.bd = this.bd + "m";
		}
		this.res = 所有文本.match(RegExp(正则文本, zz));
	}
	static 取匹配数量() {
		if (this.res == "" || this.res == null) {
			this.sl = 0;
		} else {
			this.sl = this.res.length;
		}

		return this.sl;
	}
	static 取匹配文本(匹配索引) {
		if (this.res == "" || this.res == null) {
			return "";
		}

		if (匹配索引 == null) {
			return this.res;
		}
		return this.res[匹配索引];
	}
	static 取子匹配文本(匹配索引, 子匹配索引) {
		if (this.res == "" || this.res == null) {
			return "";
		}
		this.arr = this.res[匹配索引].match(RegExp(this.zz, this.bd));
		return this.arr[子匹配索引];
	}
}
//定时器
class 定时器 {
	static 延时调用(callback, delay, ...rest) {
		return setTimeout(callback, delay, ...rest)
	}
	static 结束延时调用(timeoutID) {
		clearTimeout(timeoutID)
	}
	static 时钟(callback, delay, ...rest) {
		return setInterval(callback, delay, ...rest)
	}
	static 结束时钟(intervalID) {
		clearInterval(intervalID)
	}
}
module.exports = {文本,数组,转换,数学,时间,正则,定时器}