﻿export class 网络请求 {
	static 发起请求(地址, 请求参数, 请求头, 请求方法, 返回数据格式, 响应数据类型, 调用成功, 调用失败, 调用结束) {
		var bianliang = {
			url: 地址
		}
		if (请求参数 !== undefined) {
			bianliang.data = 请求参数
		}
		if (请求头 !== undefined) {
			bianliang.header = 请求头
		}
		if (请求方法 !== undefined) {
			bianliang.method = 请求方法
		}
		if (返回数据格式 !== undefined) {
			bianliang.dataType = 返回数据格式
		}
		if (响应数据类型 !== undefined) {
			bianliang.responseType = 响应数据类型
		}
		if (调用成功 !== undefined) {
			bianliang.success = function (e) {
				var b = {
					消息内容: e.data,
					状态码: e.statusCode,
					回复头: e.header
				}
				调用成功(b)
			}
		}
		if (调用失败 !== undefined) {
			bianliang.fail = 调用失败
		}
		if (调用结束 !== undefined) {
			bianliang.complete = 调用结束
		}
		return wx.request(bianliang)
	}
}

export class 网络请求任务对象 {
	static 中断请求任务(网络请求任务对象) {
		网络请求任务对象.abort()
	}
	static 监听回复头事件(网络请求任务对象, 回调函数) {
		网络请求任务对象.onHeadersReceived(function (e) {
			var b = {
				回复头: e.header
			}
			回调函数(b)
		})
	}
	static 取消监听回复头事件(网络请求任务对象, 回调函数) {
		网络请求任务对象.offHeadersReceived(回调函数)
	}
}

export class 网络下载 {
	static 下载文件(地址, 请求头, 存储路径, 调用成功, 调用失败, 调用结束) {
		var bianliang = {
			url: 地址
		}
		if (请求头 !== undefined) {
			bianliang.header = 请求头
		}
		if (存储路径 !== undefined) {
			bianliang.filePath = 存储路径
		}
		if (调用成功 !== undefined) {
			bianliang.success = function (e) {
				var b = {
					临时文件路径: e.tempFilePath,
					用户文件路径: e.filePath,
					状态码: e.statusCode
				}
				调用成功(b)
			}
		}
		if (调用失败 !== undefined) {
			bianliang.fail = 调用失败
		}
		if (调用结束 !== undefined) {
			bianliang.complete = 调用结束
		}
		return wx.downloadFile(bianliang)
	}
}

export class 下载任务对象 {
	static 中断请求任务(下载任务对象) {
		下载任务对象.abort()
	}
	static 监听回复头事件(网络请求任务对象, 回调函数) {
		下载任务对象.onHeadersReceived(function (e) {
			var b = {
				回复头: e.header
			}
			回调函数(b)
		})
	}
	static 取消监听回复头事件(下载任务对象, 回调函数) {
		下载任务对象.offHeadersReceived(回调函数)
	}
	static 监听进度变化事件(下载任务对象, 回调函数) {
		下载任务对象.onProgressUpdate(function (e) {
			var b = {
				下载进度百分比: e.progress,
				已下载长度: e.totalBytesWritten,
				数据总长度: e.totalBytesExpectedToWrite
			}
			回调函数(b)
		})
	}
	static 取消监听进度变化事件(下载任务对象, 回调函数) {
		下载任务对象.offProgressUpdate(回调函数)
	}
}

export class 网络上传 {
	static 上传文件(地址, 上传路径, 文件名, 请求头, 附加参数, 调用成功, 调用失败, 调用结束) {
		var bianliang = {
			url: 地址,
			filePath: 上传路径,
			name: 文件名
		}
		if (请求头 !== undefined) {
			bianliang.header = 请求头
		}
		if (附加参数 !== undefined) {
			bianliang.formData = 附加参数
		}
		if (调用成功 !== undefined) {
			bianliang.success = function (e) {
				var b = {
					消息内容: e.data,
					状态码: e.statusCode
				}
				调用成功(b)
			}
		}
		if (调用失败 !== undefined) {
			bianliang.fail = 调用失败
		}
		if (调用结束 !== undefined) {
			bianliang.complete = 调用结束
		}
		return wx.uploadFile(bianliang)
	}
}

export class 上传任务对象 {
	static 中断请求任务(上传任务对象) {
		上传任务对象.abort()
	}
	static 监听回复头事件(网络请求任务对象, 回调函数) {
		上传任务对象.onHeadersReceived(function (e) {
			var b = {
				回复头: e.header
			}
			回调函数(b)
		})
	}
	static 取消监听回复头事件(上传任务对象, 回调函数) {
		上传任务对象.offHeadersReceived(回调函数)
	}
	static 监听进度变化事件(上传任务对象, 回调函数) {
		上传任务对象.onProgressUpdate(function (e) {
			var b = {
				上传进度百分比: e.progress,
				已上传长度: e.totalBytesSent,
				数据总长度: e.totalBytesExpectedToSend
			}
			回调函数(b)
		})
	}
	static 取消监听进度变化事件(上传任务对象, 回调函数) {
		上传任务对象.offProgressUpdate(回调函数)
	}
}

export class WebSocket {
	static 创建连接(地址, 请求头, 子协议数组, 是否允许小包发送, 是否开启压缩扩展, 调用成功, 调用失败, 调用结束) {
		var bianliang = {
			url: 地址
		}
		if (请求头 !== undefined) {
			bianliang.header = 请求头
		}
		if (子协议数组 !== undefined) {
			bianliang.protocols = 子协议数组
		}
		if (是否允许小包发送 !== undefined) {
			bianliang.tcpNoDelay = 是否允许小包发送
		}
		if (是否开启压缩扩展 !== undefined) {
			bianliang.perMessageDeflate = 是否开启压缩扩展
		}
		if (调用成功 !== undefined) {
			bianliang.success = 调用成功
		}
		if (调用失败 !== undefined) {
			bianliang.fail = 调用失败
		}
		if (调用结束 !== undefined) {
			bianliang.complete = 调用结束
		}
		return wx.connectSocket(bianliang)
	}

	static 发送数据(发送内容, 调用成功, 调用失败, 调用结束) {
		var bianliang = {
			data: 发送内容
		}
		if (调用成功 !== undefined) {
			bianliang.success = 调用成功
		}
		if (调用失败 !== undefined) {
			bianliang.fail = 调用失败
		}
		if (调用结束 !== undefined) {
			bianliang.complete = 调用结束
		}
		wx.send(bianliang)
	}

	static 关闭连接(状态号, 关闭原因, 调用成功, 调用失败, 调用结束) {
		var bianliang = {}
		if (状态号 !== undefined) {
			bianliang.code = 状态号
		}
		if (关闭原因 !== undefined) {
			bianliang.reason = 关闭原因
		}
		if (调用成功 !== undefined) {
			bianliang.success = 调用成功
		}
		if (调用失败 !== undefined) {
			bianliang.fail = 调用失败
		}
		if (调用结束 !== undefined) {
			bianliang.complete = 调用结束
		}
		wx.closeSocket(bianliang)
	}

	static 监听连接打开事件(回调函数) {
		wx.onSocketOpen(function (e) {
			var b = {
				回复头: e.header
			}
			回调函数(b)
		})
	}

	static 监听连接关闭事件(回调函数) {
		wx.onSocketClose(function (e) {
			var b = {
				状态号: e.code,
				关闭原因: e.reason
			}
			回调函数(b)
		})
	}

	static 监听收到数据事件(回调函数) {
		wx.onSocketMessage(function (e) {
			var b = {
				消息内容: e.data
			}
			回调函数(b)
		})
	}

	static 监听错误事件(回调函数) {
		wx.onSocketError(function (e) {
			var b = {
				错误信息: e.errMsg
			}
			回调函数(b)
		})
	}
}

export class WebSocket任务对象 {
	static 发送数据(WebSocket任务对象, 发送内容, 调用成功, 调用失败, 调用结束) {
		var bianliang = {
			data: 发送内容
		}
		if (调用成功 !== undefined) {
			bianliang.success = 调用成功
		}
		if (调用失败 !== undefined) {
			bianliang.fail = 调用失败
		}
		if (调用结束 !== undefined) {
			bianliang.complete = 调用结束
		}
		WebSocket任务对象.send(bianliang)
	}
	static 关闭连接(WebSocket任务对象, 状态号, 关闭原因, 调用成功, 调用失败, 调用结束) {
		var bianliang = {}
		if (状态号 !== undefined) {
			bianliang.code = 状态号
		}
		if (关闭原因 !== undefined) {
			bianliang.reason = 关闭原因
		}
		if (调用成功 !== undefined) {
			bianliang.success = 调用成功
		}
		if (调用失败 !== undefined) {
			bianliang.fail = 调用失败
		}
		if (调用结束 !== undefined) {
			bianliang.complete = 调用结束
		}
		WebSocket任务对象.close(bianliang)
	}
	static 连接关闭事件(WebSocket任务对象, 回调函数) {
		WebSocket任务对象.onClose(function (e) {
			var b = {
				状态号: e.code,
				关闭原因: e.reason
			}
			回调函数(b)
		})
	}
	static 连接打开事件(WebSocket任务对象, 回调函数) {
		WebSocket任务对象.onOpen(function (e) {
			var b = {
				回复头: e.header
			}
			回调函数(b)
		})
	}
	static 数据到达事件(WebSocket任务对象, 回调函数) {
		WebSocket任务对象.onMessage(function (e) {
			var b = {
				消息内容: e.data
			}
			回调函数(b)
		})
	}
	static 错误事件(WebSocket任务对象, 回调函数) {
		WebSocket任务对象.onError(function (e) {
			var b = {
				错误信息: e.errMsg
			}
			回调函数(b)
		})
	}
}