$(function () {
  scaleScreen(1920, 1080);
});

//获取宽高缩放比例
function getScale(width, height) {
  var current_width = width,
    current_height = height,
    win_width = $(window).width(),
    win_height = $(window).height(),
    width_scale = win_width / current_width,
    height_scale = win_height / current_height,
    left_offset = (win_width - current_width) / 2,
    top_offset = (win_height - current_height) / 2;
  return {
    widthScale: width_scale,
    heightScale: height_scale,
    leftOffset: left_offset,
    topOffset: top_offset
  }
}
//初始化屏幕  缩放
function initScale(w, h) {
  var scaleObj = getScale(w, h);
  $('#app').css({
    'transform': 'scale(' + scaleObj.widthScale + ',' + scaleObj.heightScale + ')',
    'left': scaleObj.leftOffset,
    'top': scaleObj.topOffset
  })
}
function scaleScreen(w, h) {
  initScale(w, h);
  $(window).resize(function () {
    initScale(w, h);
  })
}

