<?php
//EditorTools全自动采集软件开源接口文件
//更多资源请访问软件官网：www.zzcity.net

if ( defined('ABSPATH') )
 require_once(ABSPATH . 'wp-load.php');
else
 require_once('../wp-load.php');
//nocache_headers();



function et_new_comment( $commentdata ) {
	global $wpdb;

	if ( isset( $commentdata['user_ID'] ) ) {
		$commentdata['user_id'] = $commentdata['user_ID'] = (int) $commentdata['user_ID'];
	}

	$prefiltered_user_id = ( isset( $commentdata['user_id'] ) ) ? (int) $commentdata['user_id'] : 0;

	/**
	 * Filter a comment's data before it is sanitized and inserted into the database.
	 *
	 * @since 1.5.0
	 *
	 * @param array $commentdata Comment data.
	 */
 	$commentdata = apply_filters('preprocess_comment', $commentdata);

	$commentdata['comment_post_ID'] = (int) $commentdata['comment_post_ID'];
	if ( isset( $commentdata['user_ID'] ) && $prefiltered_user_id !== (int) $commentdata['user_ID'] ) {
		$commentdata['user_id'] = $commentdata['user_ID'] = (int) $commentdata['user_ID'];
	} elseif ( isset( $commentdata['user_id'] ) ) {
		$commentdata['user_id'] = (int) $commentdata['user_id'];
	}

	$commentdata['comment_parent'] = isset($commentdata['comment_parent']) ? absint($commentdata['comment_parent']) : 0;
	$parent_status = ( 0 < $commentdata['comment_parent'] ) ? wp_get_comment_status($commentdata['comment_parent']) : '';
	$commentdata['comment_parent'] = ( 'approved' == $parent_status || 'unapproved' == $parent_status ) ? $commentdata['comment_parent'] : 0;

	if ( ! isset( $commentdata['comment_author_IP'] ) ) {
		$commentdata['comment_author_IP'] = $_SERVER['REMOTE_ADDR'];
	}
	$commentdata['comment_author_IP'] = preg_replace( '/[^0-9a-fA-F:., ]/', '', $commentdata['comment_author_IP'] );

	if ( ! isset( $commentdata['comment_agent'] ) ) {
		$commentdata['comment_agent'] = isset( $_SERVER['HTTP_USER_AGENT'] ) ? $_SERVER['HTTP_USER_AGENT']: '';
	}
	$commentdata['comment_agent'] = substr( $commentdata['comment_agent'], 0, 254 );

	if ( empty( $commentdata['comment_date'] ) ) {
		$commentdata['comment_date'] = current_time('mysql');
	}

	if ( empty( $commentdata['comment_date_gmt'] ) ) {
		$commentdata['comment_date_gmt'] = current_time( 'mysql', 1 );
	}


	$commentdata = wp_filter_comment($commentdata);

//	$commentdata['comment_approved'] = wp_allow_comment($commentdata);
	$commentdata['comment_approved']=1;
	$comment_ID = wp_insert_comment($commentdata);
	if ( ! $comment_ID ) {
		$fields = array( 'comment_author', 'comment_author_email', 'comment_author_url', 'comment_content' );

		foreach ( $fields as $field ) {
			if ( isset( $commentdata[ $field ] ) ) {
				$commentdata[ $field ] = $wpdb->strip_invalid_text_for_column( $wpdb->comments, $field, $commentdata[ $field ] );
			}
		}

		$commentdata = wp_filter_comment( $commentdata );

//		$commentdata['comment_approved'] = wp_allow_comment( $commentdata );
		$commentdata['comment_approved']=1;
		$comment_ID = wp_insert_comment( $commentdata );
		if ( ! $comment_ID ) {
			return false;
		}
	}
	print_r($commentdata);

	/**
	 * Fires immediately after a comment is inserted into the database.
	 *
	 * @since 1.2.0
	 * @since 4.5.0 The `$commentdata` parameter was added.
	 *
	 * @param int        $comment_ID       The comment ID.
	 * @param int|string $comment_approved 1 if the comment is approved, 0 if not, 'spam' if spam.
	 * @param array      $commentdata      Comment data.
	 */
	do_action( 'comment_post', $comment_ID, $commentdata['comment_approved'], $commentdata );

	return $comment_ID;
}



function et_handle_comment_submission( $comment_data ) {

	$comment_post_ID = $comment_parent = 0;
	$comment_author = $comment_author_email = $comment_author_url = $comment_content = $_wp_unfiltered_html_comment = null;

	if ( isset( $comment_data['comment_post_ID'] ) ) {
		$comment_post_ID = (int) $comment_data['comment_post_ID'];
	}
	if ( isset( $comment_data['author'] ) && is_string( $comment_data['author'] ) ) {
		$comment_author = trim( strip_tags( $comment_data['author'] ) );
	}
	if ( isset( $comment_data['email'] ) && is_string( $comment_data['email'] ) ) {
		$comment_author_email = trim( $comment_data['email'] );
	}
	if ( isset( $comment_data['url'] ) && is_string( $comment_data['url'] ) ) {
		$comment_author_url = trim( $comment_data['url'] );
	}
//	if ( isset( $comment_data['comment'] ) && is_string( $comment_data['comment'] ) ) {
//		$comment_content = trim( $comment_data['comment'] );
//	}
	if ( isset( $comment_data['content'] ) && is_string( $comment_data['content'] ) ) {
		$comment_content = trim( $comment_data['content'] );
	}
	if ( isset( $comment_data['comment_parent'] ) ) {
		$comment_parent = absint( $comment_data['comment_parent'] );
	}
	if ( isset( $comment_data['_wp_unfiltered_html_comment'] ) && is_string( $comment_data['_wp_unfiltered_html_comment'] ) ) {
		$_wp_unfiltered_html_comment = trim( $comment_data['_wp_unfiltered_html_comment'] );
	}

	$post = get_post( $comment_post_ID );

	if ( empty( $post->comment_status ) ) {

		/**
		 * Fires when a comment is attempted on a post that does not exist.
		 *
		 * @since 1.5.0
		 *
		 * @param int $comment_post_ID Post ID.
		 */
//		do_action( 'comment_id_not_found', $comment_post_ID );
//
//		return new WP_Error( 'comment_id_not_found' );
		echo('[err]comment_id_not_found[/err]');
		return false;
	}

	// get_post_status() will get the parent status for attachments.
	$status = get_post_status( $post );

	if ( ( 'private' == $status ) && ! current_user_can( 'read_post', $comment_post_ID ) ) {
//		return new WP_Error( 'comment_id_not_found' );
		echo('[err]comment_id_not_found[/err]');
		return false;
	}

	$status_obj = get_post_status_object( $status );

	if ( ! comments_open( $comment_post_ID ) ) {

		/**
		 * Fires when a comment is attempted on a post that has comments closed.
		 *
		 * @since 1.5.0
		 *
		 * @param int $comment_post_ID Post ID.
		 */
//		do_action( 'comment_closed', $comment_post_ID );
//
//		return new WP_Error( 'comment_closed', __( 'Sorry, comments are closed for this item.' ), 403 );
		echo('[err]comment_closed[/err]');
		return false;

	} elseif ( 'trash' == $status ) {

		/**
		 * Fires when a comment is attempted on a trashed post.
		 *
		 * @since 2.9.0
		 *
		 * @param int $comment_post_ID Post ID.
		 */
//		do_action( 'comment_on_trash', $comment_post_ID );
//
//		return new WP_Error( 'comment_on_trash' );
		echo('[err]comment_on_trash[/err]');
		return false;

	} elseif ( ! $status_obj->public && ! $status_obj->private ) {

		/**
		 * Fires when a comment is attempted on a post in draft mode.
		 *
		 * @since 1.5.1
		 *
		 * @param int $comment_post_ID Post ID.
		 */
//		do_action( 'comment_on_draft', $comment_post_ID );
//
//		return new WP_Error( 'comment_on_draft' );
		echo('[err]comment_on_draft[/err]');
		return false;

	} elseif ( post_password_required( $comment_post_ID ) ) {

		/**
		 * Fires when a comment is attempted on a password-protected post.
		 *
		 * @since 2.9.0
		 *
		 * @param int $comment_post_ID Post ID.
		 */
//		do_action( 'comment_on_password_protected', $comment_post_ID );
//
//		return new WP_Error( 'comment_on_password_protected' );
		echo('[err]comment_on_password_protected[/err]');
		return false;
	} else {

		/**
		 * Fires before a comment is posted.
		 *
		 * @since 2.8.0
		 *
		 * @param int $comment_post_ID Post ID.
		 */
		do_action( 'pre_comment_on_post', $comment_post_ID );

	}

	//zzcity add
	$ruser=$_POST['ruser'];
	if(!empty($ruser)){
		$rusers=explode(",",$ruser);
		$ri=rand(0,count($rusers)-1);
		$comment_author       = ( isset($rusers[$ri]) )  ? trim(strip_tags($rusers[$ri])) : null;
		$comment_author_email =( isset($rusers[$ri]) )  ? trim(strip_tags($rusers[$ri])) : null;
		$comment_author_email=$comment_author_email.'@'.$comment_author_email.'com';
	}else{
		require_once(ABSPATH . 'wp-admin/includes/admin.php');
		
		$etuser = wp_signon();
		if (!is_wp_error($etuser))
		{
			$user_ID=$etuser->ID;
			if ( empty( $etuser->display_name ) ) {
				$etuser->display_name=$etuser->user_login;
			}
			
			$comment_author       = wp_slash( $etuser->display_name );
			$comment_author_email = wp_slash( $etuser->user_email );
			$comment_author_url   = wp_slash( $etuser->user_url );	
		}
		
	}

				kses_remove_filters(); // start with a clean slate
	
	$comment_type = '';
	$max_lengths = wp_get_comment_fields_max_lengths();

//	if ( get_option( 'require_name_email' ) && ! $user->exists() ) {
//		if ( 6 > strlen( $comment_author_email ) || '' == $comment_author ) {
//			return new WP_Error( 'require_name_email', __( '<strong>ERROR</strong>: please fill the required fields (name, email).' ), 200 );
//		} elseif ( ! is_email( $comment_author_email ) ) {
//			return new WP_Error( 'require_valid_email', __( '<strong>ERROR</strong>: please enter a valid email address.' ), 200 );
//		}
//	}
//
//	if ( isset( $comment_author ) && $max_lengths['comment_author'] < mb_strlen( $comment_author, '8bit' ) ) {
//		return new WP_Error( 'comment_author_column_length', __( '<strong>ERROR</strong>: your name is too long.' ), 200 );
//	}
//
//	if ( isset( $comment_author_email ) && $max_lengths['comment_author_email'] < strlen( $comment_author_email ) ) {
//		return new WP_Error( 'comment_author_email_column_length', __( '<strong>ERROR</strong>: your email address is too long.' ), 200 );
//	}
//
//	if ( isset( $comment_author_url ) && $max_lengths['comment_author_url'] < strlen( $comment_author_url ) ) {
//		return new WP_Error( 'comment_author_url_column_length', __( '<strong>ERROR</strong>: your url is too long.' ), 200 );
//	}

	if ( '' == $comment_content ) {
//		return new WP_Error( 'require_valid_comment', __( '<strong>ERROR</strong>: please type a comment.' ), 200 );
		echo('[err]评论不能为空[/err]');
		exit;
	} elseif ( $max_lengths['comment_content'] < mb_strlen( $comment_content, '8bit' ) ) {
//		return new WP_Error( 'comment_content_column_length', __( '<strong>ERROR</strong>: your comment is too long.' ), 200 );
		echo('[err]评论超长[/err]');
		exit;
	}

	$commentdata = compact(
		'comment_post_ID',
		'comment_author',
		'comment_author_email',
		'comment_author_url',
		'comment_content',
		'comment_type',
		'comment_parent',
		'user_ID'
	);
	$commentdata=wp_unslash( $commentdata );

	$comment_id = et_new_comment( wp_slash( $commentdata ) );
	if (  $comment_id ) {
		echo('[ok]comment_id='.$comment_id);
	}


}

et_handle_comment_submission($_POST);



?>
