﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

public partial class _Default : System.Web.UI.Page
{
    protected void Page_Load(object sender, EventArgs e)
    {

    }

    /// <summary>
    /// drpTheme_SelectedIndexChanged() function to select Theme from DropDownList
    /// </summary> 
    protected void drpTheme_SelectedIndexChanged(object sender, EventArgs e)
    {
        String xaml = GetXAML();
        string s = "vChart.setDataXml(\'" + xaml + "\');"
                    + "vChart.render(\"VisifireChart1\");";
        ScriptManager scriptManager = ScriptManager.GetCurrent(Page);
        ScriptManager.RegisterClientScriptBlock(sender as DropDownList, this.GetType(), "onClick", "<script language='JavaScript'> " + s + " </script>", false);

    }

    /// <summary>
    /// RadioButton1_CheckedChanged() function to change chart type
    /// </summary>  
    protected void RadioButton1_CheckedChanged(object sender, EventArgs e)
    {
        String xaml = GetXAML();
        string s = "vChart.setDataXml(\'" + xaml + "\');"
                   + "vChart.render(\"VisifireChart1\");";
        ScriptManager scriptManager = ScriptManager.GetCurrent(Page);
        ScriptManager.RegisterClientScriptBlock(sender as RadioButton, this.GetType(), "onClick", "<script language='JavaScript'> " + s + " </script>", false);
    }

    /// <summary>
    /// RadioButton2_CheckedChanged() function to change chart type 
    /// </summary> 
    protected void RadioButton2_CheckedChanged(object sender, EventArgs e)
    {

        String xaml = GetXAML();
        string s = "vChart.setDataXml(\'" + xaml + "\');"
                   + "vChart.render(\"VisifireChart1\");";
        ScriptManager scriptManager = ScriptManager.GetCurrent(Page);
        ScriptManager.RegisterClientScriptBlock(sender as RadioButton, this.GetType(), "onClick", "<script language='JavaScript'> " + s + " </script>", false);
    }

    /// <summary>
    /// chkInappropriate_CheckedChanged() function to get Inappropriate Mails
    /// </summary>
    protected void chkInappropriate_CheckedChanged(object sender, EventArgs e)
    {
        String xaml = GetXAML();
        string s = "vChart.setDataXml(\'" + xaml + "\');"
                  + "vChart.render(\"VisifireChart1\");";
        ScriptManager scriptManager = ScriptManager.GetCurrent(Page);
        ScriptManager.RegisterClientScriptBlock(sender as CheckBox, this.GetType(), "onClick", "<script language='JavaScript'> " + s + " </script>", false);
    }

    /// <summary>
    /// Creating Chart XAML
    /// </summary>
    /// <returns>returns Data xaml</returns>
    public String GetXAML()
    {
        string chartTitle = "IceCom Statistical Analysis";   // Main title for chart
        string axisXtitle = "Month";                         // X axis title
        string axisYtitle = "Volume Of Emails";              // Y axis title
        string myXAML;                                       // String for Data xaml
        int numberOfDataPoints = 12;                         //Number of data point
        //in the DataSeries    
        Boolean inappropriateMails = chkInappropriate.Checked;
        String chartTheme = drpTheme.SelectedItem.Text;
        String renderAs = "Column";  // Default
        if (radioButColumn.Checked)
        {
            renderAs = "Column";
        }
        else if (radioButBar.Checked)
        {
            renderAs = "Bar";
        }

        // A DataSeries is a two dimensional array of DataPoints
        // Time/Year | Volume
        string[,] dataSeries1 = {{"2000", "52.6"},
                                {"2001", "40.3"},
                                {"2002", "20"},
                                {"2003", "28.7"},
                                {"2004", "46.1"},
                                {"2005", "15.1"},
                                {"2006", "15.1"},
                                {"2007", "50.5"},
                                {"2008", "52.1"},
                                {"2009", "64.8"},
                                {"2010", "38.6"},
                                {"2011", "40.23"}};

        //DATA SERIES 2 - axisx stays the same but yaxis values change.
        string[,] dataSeries2 = {{"2000", "10.2"},
                                {"2001", "11"},
                                {"2002", "10.5"},
                                {"2003", "8"},
                                {"2004", "8.5"},
                                {"2005", "7.3"},
                                {"2006", "7.6"},
                                {"2007", "7.5"},
                                {"2008", "8.9"},
                                {"2009", "10.2"},
                                {"2010", "10"},
                                {"2011", "8"}};

        // Constructing Data XAML
        myXAML = "<vc:Chart Theme=\"" + chartTheme + "\" Width=\"500\" Height=\"300\"  xmlns:vc=\"clr-namespace:Visifire.Charts;assembly=SLVisifire.Charts\" >";
        myXAML = myXAML + "<vc:Chart.Titles>";
        myXAML = myXAML + "<vc:Title Text=\"" + chartTitle + "\" />";
        myXAML = myXAML + "</vc:Chart.Titles>";
        myXAML = myXAML + "<vc:Chart.AxesX>";
        myXAML = myXAML + "<vc:Axis Title=\"" + axisXtitle + "\" />";
        myXAML = myXAML + "</vc:Chart.AxesX>";
        myXAML = myXAML + "<vc:Chart.AxesY>";
        myXAML = myXAML + "<vc:Axis Title=\"" + axisYtitle + "\" ValueFormatString=\"#0.##%\" />";
        myXAML = myXAML + "</vc:Chart.AxesY>";
        myXAML = myXAML + "<vc:Chart.Series>";

        // Create DataSeries XAML fragment
        if (inappropriateMails == false) // Display Single DataSeries
            myXAML += CreateDataSeriesXML(ref dataSeries1, numberOfDataPoints, renderAs);
        else // if (inappropriateMails == True)  // Display Double DataSeries with //Stacked Charts
        {
            myXAML += CreateDataSeriesXML(ref dataSeries1, numberOfDataPoints, "Stacked" + renderAs);
            myXAML += CreateDataSeriesXML(ref dataSeries2, numberOfDataPoints, "Stacked" + renderAs);
        }
        // End of Series and chart Tags
        myXAML = myXAML + "</vc:Chart.Series>";
        myXAML = myXAML + "</vc:Chart>";

        // Write data xaml as response text
        return myXAML;
    }

    /// <summary>
    /// Create DataSeries XAML
    /// </summary>   
    /// <returns>return myXAML</returns> 
    private String CreateDataSeriesXML(ref String[,] dataSeries, Int32 numberOfDataPoints, String renderAs)
    {
        String myXAML;

        myXAML = String.Format(@"<vc:DataSeries RenderAs=""{0}"" >", renderAs);
        myXAML = myXAML + "<vc:DataSeries.DataPoints>";
        // Constructing XAML fragment for DataSeries
        for (int dataPointIndex = 0; dataPointIndex <= numberOfDataPoints - 1; dataPointIndex++)
        {
            // Adding DataPoint XAML fragment
            myXAML = myXAML + "<vc:DataPoint AxisXLabel=\"" + dataSeries[dataPointIndex, 0] + "\" YValue=\"" + dataSeries[dataPointIndex, 1] + "\" />";
        }
        myXAML = myXAML + "</vc:DataSeries.DataPoints>";

        myXAML = myXAML + "</vc:DataSeries>";

        return myXAML;
    }
}
