﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using Visifire.Charts;
using System.Windows;

namespace SaveChartAsImageAtServerSide
{
    public partial class _Default : System.Web.UI.Page
    {
        protected void Page_Load(object sender, EventArgs e)
        {
            CreateChart();
        }

        private void CreateChart()
        {
            // Create a Chart
            Chart chart = new Chart();

            // Set Chart size
            chart.Width = 500;
            chart.Height = 300;

            // Set Image size
            Image1.Width = 500;
            Image1.Height = 300;

            // Set Chart property
            chart.AnimationEnabled = false;

            // Initialize Random class
            Random rand = new Random();

            // Create DataSeries
            DataSeries dataSeries = new DataSeries();

            for (Int32 i = 0; i < 5; i++)
            {
                // Create DataPoint
                DataPoint dataPoint = new DataPoint();

                // Set DataPoint property
                dataPoint.YValue = rand.Next(10, 100);

                // Add DataPoint to DataPoints collection of DataSeries
                dataSeries.DataPoints.Add(dataPoint);
            }

            // Add DataSeries to Series collection of Chart
            chart.Series.Add(dataSeries);

            // Starts initialization process for this element
            chart.BeginInit();

            // Indicates that the initialization process for this element is complete
            chart.EndInit();

            // Updates the desired size of UIElement (Chart)
            chart.Measure(new Size(500, 300));

            // Position child elements and determines the size for UIElement (Chart)
            chart.Arrange(new Rect(0, 0, 500, 300));

            // Update all visual child elements
            chart.UpdateLayout();
            String path = Server.MapPath("/visifire");
            chart.Export(path, ExportType.Jpg);
            Image1.ImageUrl = "visifire.jpg";
        }
    }
}