--
-- Specialization TracAnimSDM
--
-- @author  	Aluha74rus
-- @update 		_-OvErClOcKeR-_
-- @version 	v1.1
-- @date  		19/02/19

TracAnimSDM = {};
TracAnimSDM.ModDirectory = g_currentModDirectory

function TracAnimSDM.initSpecialization()
end;

function TracAnimSDM.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Wheels, specializations)
end;

function TracAnimSDM.registerEventListeners(vehicleType)
	for _,n in pairs( { "onLoad", "onUpdate" } ) do
		SpecializationUtil.registerEventListener(vehicleType, n, TracAnimSDM)
	end
end;

function TracAnimSDM:onLoad(savegame)
    local spec = self.spec_wheels

    self.charIdAnim = I3DUtil.indexToObject(self.components, getXMLString(self.xmlFile, "vehicle.wheels.CustomCrawlers.leftcrawler#node"));
    self.clipIndexAnim = Utils.getNoNil(getXMLString(self.xmlFile, "vehicle.wheels.CustomCrawlers.leftcrawler#animationClip"))

    self.charIdAnim1 = I3DUtil.indexToObject(self.components, getXMLString(self.xmlFile, "vehicle.wheels.CustomCrawlers.rightcrawler#node"));
    self.clipIndexAnim1 = getXMLString(self.xmlFile, "vehicle.wheels.CustomCrawlers.rightcrawler#animationClip");

    self.spedTracLeft = I3DUtil.indexToObject(self.components, getXMLString(self.xmlFile, "vehicle.wheels.CustomCrawlers.leftcrawler#spedLeftnode"));
    self.spedTracRight = I3DUtil.indexToObject(self.components, getXMLString(self.xmlFile, "vehicle.wheels.CustomCrawlers.rightcrawler#spedRightnode"));

    self.charId = getAnimCharacterSet(self.charIdAnim);
    local clipIndex = getAnimClipIndex(self.charId, self.clipIndexAnim);
    assignAnimTrackClip(self.charId , 0, clipIndex);
    setAnimTrackLoopState(self.charId, 0, true);

    self.charId1 = getAnimCharacterSet(self.charIdAnim1);
    local clipIndex1 = getAnimClipIndex(self.charId1, self.clipIndexAnim1);
    assignAnimTrackClip(self.charId1 , 0, clipIndex1);
    setAnimTrackLoopState(self.charId1, 0, true);

    self.lastTranslation1 = nil; -- = {0,0,0};
    self.lastSpeedReal1 = 0;
    self.lastMovedDistance1 = 0;
    self.speedDisplayDt1 = 0;
    self.movingDirection1 = 0;
    self.speedDisplayScale1 = 1;

    self.lastTranslation2 = nil; -- = {0,0,0};
    self.lastSpeedReal2 = 0;
    self.lastMovedDistance2 = 0;
    self.speedDisplayDt2 = 0;
    self.movingDirection2 = 0;
    self.speedDisplayScale2 = 1;
    self.lastRotR,_,_ = getRotation(spec.wheels[2].driveNode);
    self.lastRotL,_,_ = getRotation(spec.wheels[1].driveNode);
	
end;

function TracAnimSDM:onUpdate(dt, isActiveForInput, isSelected)
    local spec = self.spec_wheels
    self.speedDisplayDt1 = self.speedDisplayDt1 + dt;
    if self.speedDisplayDt1 > 100 then
        local newX1, newY1, newZ1 = getWorldTranslation(self.spedTracLeft);
        if self.lastTranslation1 == nil then
            self.lastTranslation1 = {newX1, newY1, newZ1};
        end;
        local dx1, dy1, dz1 = worldDirectionToLocal(self.spedTracLeft, newX1-self.lastTranslation1[1], newY1-self.lastTranslation1[2], newZ1-self.lastTranslation1[3]);
        self.lastMovedDistance1 = MathUtil.vector3Length(dx1, dy1, dz1);
        self.lastSpeedReal1 = (self.lastMovedDistance1/10);
        self.lastTranslation1 = {newX1, newY1, newZ1};
        self.speedDisplayDt1 = self.speedDisplayDt1 - 100;
    end;

    self.speedDisplayDt2 = self.speedDisplayDt2 + dt;
    if self.speedDisplayDt2 > 100 then
        local newX2, newY2, newZ2 = getWorldTranslation(self.spedTracRight);
        if self.lastTranslation2 == nil then
            self.lastTranslation2 = {newX2, newY2, newZ2};
        end;
        local dx2, dy2, dz2 = worldDirectionToLocal(self.spedTracRight, newX2-self.lastTranslation2[1], newY2-self.lastTranslation2[2], newZ2-self.lastTranslation2[3]);
        self.lastMovedDistance2 = MathUtil.vector3Length(dx2, dy2, dz2);
        self.lastSpeedReal2 = (self.lastMovedDistance2/10);
        self.lastTranslation2 = {newX2, newY2, newZ2};
        self.speedDisplayDt2 = self.speedDisplayDt2 - 100;
    end;

    local dx1, dy1,dz1 = getRotation(spec.wheels[3].driveNode);
    local dx2,dy2,dz2 = getRotation(spec.wheels[4].driveNode);
    if dx1 > self.lastRotL then 
	    self.movingDirection2 = 1; 
	end;
    if dx2 > self.lastRotR then 
	    self.movingDirection1 = 1; 
	end;
    if dx1 == self.lastRotL then 
	    self.movingDirection2 = 0; 
	end;
    if dx2 == self.lastRotR then 
	    self.movingDirection1 = 0; 
	end;
    if dx1 < self.lastRotL then
	    self.movingDirection2 = -1; 
	end;
    if dx2 < self.lastRotR then 
	    self.movingDirection1 = -1; 
	end;
    self.lastRotL = dx1;
    self.lastRotR = dx2;
    if dy2  > - 1 then
        setAnimTrackSpeedScale(self.charId, 0, 18 * self.lastSpeedReal1 * self.movingDirection1);
        enableAnimTrack(self.charId, 0);
    else
        disableAnimTrack(self.charId, 0);
    end;
    if dy1 < 1 then
        setAnimTrackSpeedScale(self.charId1, 0, 18 * self.lastSpeedReal2 * self.movingDirection2);
        enableAnimTrack(self.charId1, 0);
    else
        disableAnimTrack(self.charId1, 0);
    end;
end;