#
# Copyright 2011-2013 Blender Foundation, Modifications Copyright Mathieu Menuet.
#
# Licensed under the GPL License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
# You should have received a copy of the GNU General Public License along with this program; if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

# <pep8 compliant>

from bl_operators.presets import AddPresetBase
from bpy.types import Operator


class AddPresetIntegrator(AddPresetBase, Operator):
    '''Add an Integrator Preset'''
    bl_idname = "render.cycles_integrator_preset_add"
    bl_label = "Add Integrator Preset"
    preset_menu = "CYCLES_PT_integrator_presets"

    preset_defines = [
        "cycles = bpy.context.scene.cycles"
    ]

    preset_values = [
        "cycles.max_bounces",
        "cycles.diffuse_bounces",
        "cycles.glossy_bounces",
        "cycles.transmission_bounces",
        "cycles.volume_bounces",
        "cycles.transparent_max_bounces",
        "cycles.use_transparent_shadows",
        "cycles.caustics_reflective",
        "cycles.caustics_refractive",
        "cycles.blur_glossy"
    ]

    preset_subdir = "cycles/integrator"


class AddPresetSampling(AddPresetBase, Operator):
    '''Add a Sampling Preset'''
    bl_idname = "render.cycles_sampling_preset_add"
    bl_label = "Add Sampling Preset"
    preset_menu = "CYCLES_PT_sampling_presets"

    preset_defines = [
        "cycles = bpy.context.scene.cycles"
    ]

    preset_values = [
        "cycles.samples",
        "cycles.preview_samples",
        "cycles.aa_samples",
        "cycles.preview_aa_samples",
        "cycles.diffuse_samples",
        "cycles.glossy_samples",
        "cycles.transmission_samples",
        "cycles.ao_samples",
        "cycles.mesh_light_samples",
        "cycles.subsurface_samples",
        "cycles.volume_samples",
        "cycles.use_square_samples",
        "cycles.progressive",
        "cycles.seed",
        "cycles.sample_clamp_direct",
        "cycles.sample_clamp_indirect",
        "cycles.sample_all_lights_direct",
        "cycles.sample_all_lights_indirect",
    ]

    preset_subdir = "cycles/sampling"

class AddPresetQuick(AddPresetBase, Operator):
    '''Add a Sampling Preset'''
    bl_idname = "render.cycles_quick_preset_add"
    bl_label = "Add Quick Preset"
    preset_menu = "CYCLES_PT_quick_presets"

    preset_defines = [
        "cycles = bpy.context.scene.cycles",
        "light = bpy.context.scene.world.light_settings",
        "render = bpy.context.scene.render"
    ]

    preset_values = [
        # "cycles.samples",
        # "cycles.preview_samples",
        "cycles.sample_clamp_indirect",
        "cycles.sample_clamp_direct",
        "cycles.sampling_pattern",
        "cycles.light_sampling_threshold",
        "cycles.ao_bounces_render",
        "light.ao_factor",
        "light.distance",
        "cycles.caustics_reflective",
        "cycles.caustics_refractive",
        # "cycles.use_square_samples",
        # "cycles.use_auto_tiles",
        "cycles.noise",
        "cycles.max_bounces",
        "cycles.diffuse_bounces",
        "cycles.glossy_bounces",
        "cycles.transparent_max_bounces",
        "cycles.transmission_bounces",
        "cycles.volume_bounces",
        "cycles.blur_glossy",
        "cycles.pixel_filter_type",
        "cycles.filter_width",
    ]

    preset_subdir = "cycles/quick"

classes = (
    AddPresetIntegrator,
    AddPresetSampling,
    AddPresetQuick,
)


def register():
    from bpy.utils import register_class
    for cls in classes:
        register_class(cls)


def unregister():
    from bpy.utils import unregister_class
    for cls in classes:
        unregister_class(cls)


if __name__ == "__main__":
    register()
