/*
 * Copyright 2011-2017 Blender Foundation, Modifications Copyright Mathieu Menuet.
 *
 * Licensed under the GPL License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.

 *
 * You should have received a copy of the GNU General Public License along with this program; if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

CCL_NAMESPACE_BEGIN

ccl_device void kernel_enqueue_inactive(KernelGlobals *kg,
                                        ccl_local_param unsigned int *local_queue_atomics)
{
#ifdef __BRANCHED_PATH__
  /* Enqeueue RAY_INACTIVE rays into QUEUE_INACTIVE_RAYS queue. */
  if (ccl_local_id(0) == 0 && ccl_local_id(1) == 0) {
    *local_queue_atomics = 0;
  }
  ccl_barrier(CCL_LOCAL_MEM_FENCE);

  int ray_index = ccl_global_id(1) * ccl_global_size(0) + ccl_global_id(0);

  char enqueue_flag = 0;
  if (IS_STATE(kernel_split_state.ray_state, ray_index, RAY_INACTIVE)) {
    enqueue_flag = 1;
  }

  enqueue_ray_index_local(ray_index,
                          QUEUE_INACTIVE_RAYS,
                          enqueue_flag,
                          kernel_split_params.queue_size,
                          local_queue_atomics,
                          kernel_split_state.queue_data,
                          kernel_split_params.queue_index);
#endif /* __BRANCHED_PATH__ */
}

CCL_NAMESPACE_END
