/*
 * Copyright 2011-2013 Blender Foundation, Modifications Copyright Mathieu Menuet. 
 *
 * Licensed under the GPL License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.

 *
 * You should have received a copy of the GNU General Public License along with this program; if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

CCL_NAMESPACE_BEGIN

/* Conversion Nodes */

ccl_device void svm_node_convert(
    KernelGlobals *kg, ShaderData *sd, float *stack, uint type, uint from, uint to)
{
  switch (type) {
    case NODE_CONVERT_FI: {
      float f = stack_load_float(stack, from);
      stack_store_int(stack, to, float_to_int(f));
      break;
    }
    case NODE_CONVERT_FV: {
      float f = stack_load_float(stack, from);
      stack_store_float3(stack, to, make_float3(f, f, f));
      break;
    }
    case NODE_CONVERT_CF: {
      float3 f = stack_load_float3(stack, from);
      float g = linear_rgb_to_gray(kg, f);
      stack_store_float(stack, to, g);
      break;
    }
    case NODE_CONVERT_CI: {
      float3 f = stack_load_float3(stack, from);
      int i = (int)linear_rgb_to_gray(kg, f);
      stack_store_int(stack, to, i);
      break;
    }
    case NODE_CONVERT_VF: {
      float3 f = stack_load_float3(stack, from);
      float g = average(f);
      stack_store_float(stack, to, g);
      break;
    }
    case NODE_CONVERT_VI: {
      float3 f = stack_load_float3(stack, from);
      int i = (int)average(f);
      stack_store_int(stack, to, i);
      break;
    }
    case NODE_CONVERT_IF: {
      float f = (float)stack_load_int(stack, from);
      stack_store_float(stack, to, f);
      break;
    }
    case NODE_CONVERT_IV: {
      float f = (float)stack_load_int(stack, from);
      stack_store_float3(stack, to, make_float3(f, f, f));
      break;
    }
  }
}

CCL_NAMESPACE_END
