import bpy
cycles = bpy.context.scene.cycles
light = bpy.context.scene.world.light_settings
render = bpy.context.scene.render

cycles.preview_start_resolution = 256
if bpy.context.scene.cycles.feature_set in ('AO','CLAY'):
    bpy.context.scene.cycles.feature_set = bpy.context.scene.kernel 

if bpy.data.materials.get("__CLAY__"):
    for view_layer in bpy.context.scene.view_layers:
        if view_layer.material_override == bpy.data.materials["__CLAY__"]:
            view_layer.material_override = None
# cycles.samples = 100
# cycles.preview_samples = 32
cycles.sample_clamp_indirect = 1.0
cycles.sample_clamp_direct = 0.0
cycles.sampling_pattern = 'SOBOL'
cycles.light_sampling_threshold = 0.019999999552965164
cycles.ao_bounces_render = 1
if (not light.use_ambient_occlusion):
    light.ao_factor = 0.08
    light.distance = 1.0
# cycles.caustics_reflective = False
# cycles.caustics_refractive = False
# cycles.use_square_samples = False
# cycles.use_auto_tiles = True
cycles.noise = 0.019999999552965164
cycles.max_bounces = 16
cycles.min_light_bounces = 0
cycles.diffuse_bounces = 4
cycles.glossy_bounces = 4
cycles.transparent_max_bounces = 8
cycles.transmission_bounces = 16
cycles.volume_bounces = 1
cycles.blur_glossy = 0.0
cycles.pixel_filter_type = 'GAUSSIAN'
cycles.filter_width = 1.5

for obj in bpy.data.objects:
    try:
        if obj.visible_get() and obj.type == 'VOLUME':
            obj.data.render.clipping = 0.05
    except:
        continue
        
# step_size = 100
# for obj in bpy.data.objects:
    # try:
        # if obj.visible_get() and obj.modifiers[0].smoke_type == 'DOMAIN':
            # step_size = min(step_size, obj.dimensions.x/obj.modifiers[0].domain_settings.resolution_max*3)
    # except:
        # continue
# if step_size != 100:
    # bpy.context.scene.cycles.volume_step_size = step_size