import bpy
cycles = bpy.context.scene.cycles
light = bpy.context.scene.world.light_settings
render = bpy.context.scene.render

cycles.preview_start_resolution = 128
if bpy.context.scene.cycles.feature_set in ('AO','CLAY'):
    bpy.context.scene.cycles.feature_set = bpy.context.scene.kernel 

if bpy.data.materials.get("__CLAY__"):
    for view_layer in bpy.context.scene.view_layers:
        if view_layer.material_override == bpy.data.materials["__CLAY__"]:
            view_layer.material_override = None
# cycles.samples = 1024
# cycles.preview_samples = 32
if cycles.sample_clamp_indirect and cycles.sample_clamp_indirect < 80.0:
    cycles.sample_clamp_indirect = 80.0
cycles.sample_clamp_direct = 0.0
cycles.sampling_pattern = 'SOBOL'
cycles.light_sampling_threshold = 0.0
cycles.ao_bounces_render = 0
# if (not light.use_ambient_occlusion):
    # light.ao_factor = 0.10000000149011612
    # light.distance = 0.10000000149011612
cycles.caustics_reflective = True
cycles.caustics_refractive = True
# cycles.use_square_samples = False
# cycles.use_auto_tiles = True
cycles.noise = 0.0
if cycles.max_bounces < 64:
    cycles.max_bounces = 64
if cycles.min_light_bounces < 2:
    cycles.min_light_bounces = 2
if cycles.diffuse_bounces < 32:
    cycles.diffuse_bounces = 32
if cycles.glossy_bounces < 32:
    cycles.glossy_bounces = 32
if cycles.transparent_max_bounces < 32:
    cycles.transparent_max_bounces = 32
if cycles.transmission_bounces < 32:
    cycles.transmission_bounces = 32
if cycles.volume_bounces < 4:
    cycles.volume_bounces = 4
cycles.blur_glossy = 0.0
cycles.pixel_filter_type = 'GAUSSIAN'
cycles.filter_width = 1.5
