import bpy
cycles = bpy.context.scene.cycles
light = bpy.context.scene.world.light_settings
render = bpy.context.scene.render

cycles.preview_start_resolution = 512
bpy.types.Scene.kernel = bpy.props.StringProperty(name="kernel")
if not bpy.context.scene.kernel:
    bpy.context.scene.kernel = bpy.context.scene.cycles.feature_set
bpy.context.scene.cycles.feature_set = 'AO'

if bpy.data.materials.get("__CLAY__"):
    for view_layer in bpy.context.scene.view_layers:
        if view_layer.material_override == bpy.data.materials["__CLAY__"]:
            view_layer.material_override = None
    
    
# cycles.samples = cycles.samples * 0.5
# cycles.preview_samples = 32
cycles.sample_clamp_indirect = 0.0
cycles.sample_clamp_direct = 0.0
cycles.sampling_pattern = 'SOBOL'
cycles.light_sampling_threshold = 0.1
cycles.ao_bounces_render = 0
if (not light.use_ambient_occlusion):
    light.ao_factor = 1.0
    light.distance = 1.0
cycles.caustics_reflective = False
cycles.caustics_refractive = False
# cycles.use_square_samples = False
cycles.use_auto_tiles = True
cycles.noise = 0.07
# cycles.max_bounces = 4
# cycles.diffuse_bounces = 4
# cycles.glossy_bounces = 4
# cycles.transparent_max_bounces = 4
# cycles.transmission_bounces = 1
# cycles.volume_bounces = 1
# cycles.blur_glossy = 0.0
# cycles.pixel_filter_type = 'GAUSSIAN'
# cycles.filter_width = 2.0