
/*
Copyright (c) 2013-2017 EasyDarwin.ORG.  All rights reserved.
Github: https://github.com/EasyDarwin
WEChat: EasyDarwin
Website: http://www.easydarwin.org
*/
#ifndef __EasyPlayerProAPI_H__
#define __EasyPlayerProAPI_H__


//++ typedefine start
#ifndef EASY_HANDLE
#define EASY_HANDLE void*
#endif//EASY_HANDLE

#ifndef Easy_PlayerPro_Handle
#define Easy_PlayerPro_Handle void*
#endif//Easy_PlayerPro_Handle

#ifndef EASY_VERYLONG
#define EASY_VERYLONG __int64
#endif//EASY_VERYLONG
//-- typedefine end


// adev render type
typedef enum tagEASY_AUDIO_RENDER_TYPE
{
	//waveout
	EASY_AUDIO_RENDER_TYPE_WAVEOUT = 0,
}EASY_AUDIO_RENDER_TYPE;

// vdev render type
typedef enum tagEASY_VIDEO_RENDER_TYPE
{
	EASY_VIDEO_RENDER_TYPE_GDI = 0,
	EASY_VIDEO_RENDER_TYPE_D3D,
	//	EASY_VIDEO_RENDER_TYPE_OPENGL,
	EASY_VIDEO_RENDER_TYPE_MAX_NUM,
}EASY_VIDEO_RENDER_TYPE;

// render mode
typedef enum tagEASY_VIDEO_SCALE_MODE
{
	//ʾ
	EASY_VIDEO_MODE_STRETCHED,
	//ŵʾ
	EASY_VIDEO_MODE_LETTERBOX,
	EASY_VIDEO_MODE_MAX_NUM,
}EASY_VIDEO_SCALE_MODE;

// link mode
typedef enum tagEASY_STREAM_LINK_MODE
{
	//ŵʾ
	EASY_STREAM_LINK_UDP = 0,
	//ʾ
	EASY_STREAM_LINK_TCP,
	EASY_STREAM_LINK_MODE_NUM,
}EASY_STREAM_LINK_MODE;

// audio visual effect
typedef enum tagEASY_AUDIO_VISUAL_EFFECT_MODE
{
	EASY_AUDIO_VISUAL_EFFECT_DISABLE,
	EASY_AUDIO_VISUAL_EFFECT_WAVEFORM,
	EASY_AUDIO_VISUAL_EFFECT_SPECTRUM,
	EASY_AUDIO_VISUAL_EFFECT_MAX_NUM,
}EASY_AUDIO_VISUAL_EFFECT_MODE;

// hwaccel type ƵȾӲ
typedef enum tagEASY_VIDEO_HARDWARE_ACCEL_TYPE
{
	EASY_VIDEO_HWACCEL_TYPE_NONE,
	EASY_VIDEO_HWACCEL_TYPE_DXVA2,
	EASY_VIDEO_HWACCEL_TYPE_MAX_NUM,
}EASY_VIDEO_HARDWARE_ACCEL_TYPE;

// param
typedef enum tagEASY_PARAM_ID
{
	//++ public
	// duration & position
	EASY_PARAM_MEDIA_DURATION = 0x1000,
	EASY_PARAM_MEDIA_POSITION,

	// media detail info
	EASY_PARAM_MEDIA_INFO,
	EASY_PARAM_VIDEO_WIDTH,
	EASY_PARAM_VIDEO_HEIGHT,

	// video display mode
	EASY_PARAM_VIDEO_MODE,

	// audio volume control
	EASY_PARAM_AUDIO_VOLUME,

	// playback speed control
	EASY_PARAM_PLAY_SPEED,
	EASY_PARAM_PLAY_SPEED_TYPE,

	// video decode thread count
	EASY_PARAM_DECODE_THREAD_COUNT,

	// visual effect mode
	EASY_PARAM_VISUAL_EFFECT,

	// audio/video sync diff
	EASY_PARAM_AVSYNC_TIME_DIFF,

	// player event/audio/video callback
	EASY_PARAM_PLAYER_CALLBACK,
	// player event/audio/video callback userdata
	EASY_PARAM_PLAYER_USERDATA,

	// audio/video stream
	EASY_PARAM_AUDIO_STREAM_TOTAL,
	EASY_PARAM_VIDEO_STREAM_TOTAL,
	EASY_PARAM_SUBTITLE_STREAM_TOTAL,
	EASY_PARAM_AUDIO_STREAM_CUR,
	EASY_PARAM_VIDEO_STREAM_CUR,
	EASY_PARAM_SUBTITLE_STREAM_CUR,

	//++ for media record 
	EASY_PARAM_RECORD_TIME,
	EASY_PARAM_RECORD_PIECE_ID,
	//-- for media record
	//-- public

	//++ for audio render type
	EASY_PARAM_ADEV_RENDER_TYPE = 0x2000,
	EASY_PARAM_ADEV_GET_CONTEXT,
	EASY_PARAM_ADEV_MUTE,
	//-- for audio render type

	//++ for vdev
	EASY_PARAM_VDEV_RENDER_TYPE = 0x3000,
	EASY_PARAM_VDEV_FRAME_RATE,
	EASY_PARAM_VDEV_GET_CONTEXT,
	EASY_PARAM_VDEV_POST_SURFACE,
	EASY_PARAM_VDEV_GET_D3DDEV,
	EASY_PARAM_VDEV_D3D_ROTATE,
	//-- for vdev

	//++ for render
	EASY_PARAM_RENDER_UPDATE = 0x4000,
	EASY_PARAM_RENDER_START_PTS,
	//-- for render

}EASY_PARAM_ID;

typedef enum __EASY_CALLBACK_TYPE_ENUM
{
	EASY_TYPE_CONNECTING = 100,						//ǰͨ
	EASY_TYPE_CONNECTED,							//ǰͨ
	EASY_TYPE_RECONNECT,							//ǰͨѶϿ,
	EASY_TYPE_DISCONNECT,							//ǰֹͨ(ڲ߳˳),ָӴ»صֵ

	EASY_TYPE_CODEC_DATA,							//
	EASY_TYPE_DECODE_DATA,							//
	EASY_TYPE_SNAPSHOT,								//ץ
	EASY_TYPE_RECORDING,							//¼
													//	EASY_TYPE_INSTANT_REPLAY_RECORDING,				//ʱط¼

													EASY_TYPE_START_PLAY_AUDIO,						//ʼ
													EASY_TYPE_STOP_PLAY_AUDIO,						//ֹͣ
													EASY_TYPE_CAPTURE_VIDEO_DATA,					//زɼƵ
													EASY_TYPE_CAPTURE_AUDIO_DATA,					//زɼƵ

													EASY_TYPE_FILE_DURATION							//ļʱ
}EASY_CALLBACK_TYPE_ENUM;

//ý
typedef enum __EASY_MEDIA_TYPE_ENUM
{
	MEDIA_TYPE_VIDEO = 0x00000001,
	MEDIA_TYPE_AUDIO = 0x00000002,
	MEDIA_TYPE_EVENT = 0x00000003,
	MEDIA_TYPE_CODEC_INFO = 0x00000004
}EASY_MEDIA_TYPE_ENUM;


//֡Ϣ
typedef struct __EASY_FRAME_INFO
{
	unsigned int	acodec;			//Ƶʽ
	unsigned int	vcodec;			//Ƶʽ
	char			acodecString[32];
	char			vcodecString[32];

	unsigned int	type;			//֡
	unsigned int	fps;			//֡
	unsigned int	reserved1;
	unsigned int	reserved2;

	unsigned int	width;			//
	unsigned int  height;			//
	unsigned int	sample_rate;	//
	unsigned int	channels;		//
	unsigned int	bitsPerSample;	//
	unsigned int	length;			//֡С
	unsigned int    timestamp_sec;	//timestamp	sec
	unsigned int    timestamp_usec;	//timestamp	usec
	unsigned int	timeduration_sec;	//ļ/طʱ䳤ȣλ

	float			bitrate;		//Kbps
	float			fStatisticsBitsrate;
	float			nStatisticsFPS;
}EASY_FRAME_INFO;

//define EASY_FRAME_INFO

typedef int(_stdcall *EasyPlayerProCallBack)(EASY_CALLBACK_TYPE_ENUM callbackType, void *userPtr, int mediaType, char *pbuf, EASY_FRAME_INFO *frameInfo);

#ifdef __cplusplus
extern "C"
{
#endif

	// EasyPlayerProӿں
	int EasyPlayerPro_Authorize(char *license);

	Easy_PlayerPro_Handle EasyPlayerPro_Create();
	void EasyPlayerPro_Release(Easy_PlayerPro_Handle player);

	// 	EasyPlayerPro_Open     һýýļвţͬʱһ player ָ
	// 		fileUrl				- ļ·ý URL
	// 		hWnd				- Win32 Ĵھ/ƽ̨Ⱦʾ豸
	//		render_mode			- ƵȾģʽEASY_VIDEO_RENDER_TYPE
	//		video_mode			- ƵʾģʽEASY_VIDEO_SCALE_MODE
	//		link_mode			- ģʽĿǰֻRTSPЧrtp over tcp/udp,	EASY_STREAM_LINK_MODE
	//		speed				- ٶȣ0-100ţ100Ͽ
	//		valume				- -255 - +255
	// 		ֵ				- Easy_PlayerPro_Handle ָָͣ easyplayerpro 
	Easy_PlayerPro_Handle EasyPlayerPro_Open(Easy_PlayerPro_Handle player,
		char *fileUrl, EASY_HANDLE hWnd,
		EASY_VIDEO_RENDER_TYPE render_type,
		EASY_VIDEO_SCALE_MODE  video_mode,
		EASY_STREAM_LINK_MODE  link_mode,
		int					   speed,
		int					   valume
		,int probesize, int max_analyze_duration);

	// 	EasyPlayerPro_Close    رղ
	// 		player				- ָ EasyPlayerPro_Open ص player 
	void  EasyPlayerPro_Close(Easy_PlayerPro_Handle player);

	// 	EasyPlayerPro_Play     ʼţע⣺ýļ򿪺Ҫô˺ʼţ
	// 							˺ͣŵʱã߼
	// 		player				- ָ EasyPlayerPro_Open ص player 
	void  EasyPlayerPro_Play(Easy_PlayerPro_Handle player);

	// 	EasyPlayerPro_StepPlay ţһβһ֡EasyPlayerPro_Play
	// 		player				- ָ EasyPlayerPro_Open ص player 
	//		type				- ͣ1-ǰ 2-
	void  EasyPlayerPro_StepPlay(Easy_PlayerPro_Handle player, int type);


	// 	EasyPlayerPro_Pause		ͣţEasyPlayerPro_Play
	// 		player				- ָ EasyPlayerPro_Open ص player 
	void  EasyPlayerPro_Pause(Easy_PlayerPro_Handle player);


	// 	EasyPlayerPro_Seek     תָλ
	// 		player				- ָ EasyPlayerPro_Open ص player 
	// 		seek				- ָλãԺΪλ
	void  EasyPlayerPro_Seek(Easy_PlayerPro_Handle player, EASY_VERYLONG seek);


	// 	EasyPlayerPro_Resize   ʾʾƵʾӾЧʾ
	// 		player				- ָ EasyPlayerPro_Open ص player 
	// 		type				- ָ  0 - video rect, 1 - audio visual effect rect
	// 		x,y,width,height	- ָʾ
	void  EasyPlayerPro_Resize(Easy_PlayerPro_Handle player, int type, int x, int y, int width, int height);


	// 	EasyPlayerPro_Snapshot ƵŽͼ
	// 		player				- ָ EasyPlayerPro_Open ص player 
	// 		filePath			- ͼƬ·.xxxxxx Ŀǰֻ֧ jpeg ʽ
	// 		width, height       - ָͼƬߣ <= 0 ĬʹƵ
	// 		waittime			- Ƿȴͼ 0 - ȴ>0 ȴʱ ms Ϊλ
	int   EasyPlayerPro_Snapshot(Easy_PlayerPro_Handle player, char *filePath, int width, int height, int waitTime);


	// 	EasyPlayerPro_Record   Ƶ¼
	// 		player				- ָ EasyPlayerPro_Open ص player 
	// 		filePath			- ͼƬ·.xxxxxx Ŀǰֻ֧ mp4 ʽ
	// 		duration			- ָ¼Ƭʱ = 0 ĬϲƬλ
	int   EasyPlayerPro_Record(Easy_PlayerPro_Handle player, char *filePath, int duration);


	// 	EasyPlayerPro_Record   Ƶֹͣ¼
	// 		player				- ָ EasyPlayerPro_Open ص player 
	int   EasyPlayerPro_Stoprecord(Easy_PlayerPro_Handle player);

	// 	EasyPlayerPro_RealCache   ʵʱ棨Ԥ¼
	// 		player				- ָ EasyPlayerPro_Open ص player 
	// 		cachename			- ָƣΪnull()򲥷ָ
	// 		duration			- ָ¼ʱ = 0 ĬϲƬλ
	// 		bRecord				- Ƿ񻺴¼ =true ʵʱֹͣʱɾ¼
	// 		bDelSegment			- Ƿɾָ棬 =true ڻʱָʱ3ʱʼɾڵĻ
	int   EasyPlayerPro_RealCache(Easy_PlayerPro_Handle player, char *cachename, int duration, bool bRecord, bool bDelSegment);

	// 	EasyPlayerPro_RealCache   ֹͣʵʱ棨Ԥ¼
	// 		player				- ָ EasyPlayerPro_Open ص player 	
	// ע⣺EasyPlayerPro_RealCachebRecordΪfalseúú¼
	int   EasyPlayerPro_StopRealCache(Easy_PlayerPro_Handle player);

	// 	EasyPlayerPro_RealPlayback   طʵʱ棨Ԥ¼طţ
	// 		player				- ָ EasyPlayerPro_Open ص player 	
	// 		hWnd				- طָȾĿ괰/豸磺Win32 Ĵھ/ƽ̨Ⱦʾ豸
	//		bPreview			- طԤģʽ =true һֱʵʱ棬=false طʱεʵʱ
	Easy_PlayerPro_Handle EasyPlayerPro_RealPlayback(Easy_PlayerPro_Handle player, EASY_HANDLE hWnd, bool bPreview, bool bCover);

	// 	EasyPlayerPro_RealCache   ֹͣطʵʱ棨Ԥ¼
	// 		player				- ָ EasyPlayerPro_Open ص player 	
	// 		realplaybacker		- ָ EasyPlayerPro_RealPlayback ص playback 	
	int   EasyPlayerPro_StopRealPlayback(Easy_PlayerPro_Handle player, Easy_PlayerPro_Handle realplaybacker);

	// 	EasyPlayerPro_SetLogo  ̨/LOGO
	// 		player				- ָ EasyPlayerPro_Open ص player 
	// 		bIsUse				- Ƿʹˮӡ 1= 0=
	// 		ePos				- ̨λã1==leftttop 2==righttop 3==leftbottom 4==rightbottom
	// 		eStyle				-  ˮӡķ񣬼WATERMARK_ENTRY_TYPE
	// 		x					- ˮӡϽλx
	// 		y					- ˮӡϽλy
	// 		width				- 
	// 		height				- 
	// 		logopath			- ˮӡͼƬ·
	int   EasyPlayerPro_SetLogo(void* hplayer, int bIsUse, int ePos, int eStyle,
		int x, int y, int width, int height, char* logopath);

	// 	EasyPlayerPro_SetOSD  õĻ
	// 		player				- ָ EasyPlayerPro_Open ص player 
	// 		bIsUse				- Ƿʹˮӡ 1= 0= -1=ɾ
	// 		nMoveType			- ƶͣ0--̶λã1--ң2--
	//		R,G,B				- ɫӦ0-255
	// 		x					- ĻʾϽλx
	// 		y					- ĻʾϽλy
	// 		weight				- Ȩأ
	// /* Font Weights */
	// #define FW_DONTCARE         0
	// #define FW_THIN             100
	// #define FW_EXTRALIGHT       200
	// #define FW_LIGHT            300
	// #define FW_NORMAL           400
	// #define FW_MEDIUM           500
	// #define FW_SEMIBOLD         600
	// #define FW_BOLD             700
	// #define FW_EXTRABOLD        800
	// #define FW_HEAVY            900
	// #define FW_ULTRALIGHT       FW_EXTRALIGHT
	// #define FW_REGULAR          FW_NORMAL
	// #define FW_DEMIBOLD         FW_SEMIBOLD
	// #define FW_ULTRABOLD        FW_EXTRABOLD
	// #define FW_BLACK            FW_HEA
	// 		width				- 
	// 		height				- 
	// 		fontname			- ƣ硰塱塱顱п......
	//		tittleContent		- OSDʾ
	int   EasyPlayerPro_SetOSD(void *hplayer, int bIsUse, int nMoveType, int R, int G, int B,
		int weight, int x, int y, int width, int height, char* fontname, char* tittleContent);

	// 	EasyPlayerPro_Setparam ò
	// 		player				- ָ EasyPlayerPro_Open ص player 
	// 		param_id			- IDEASY_PARAM_ID
	// 		param				- ָ
	void  EasyPlayerPro_Setparam(Easy_PlayerPro_Handle player, EASY_PARAM_ID param_id, EASY_HANDLE param);

	// 	EasyPlayerPro_Setparam ȡ
	// 		player				- ָ EasyPlayerPro_Open ص player 
	// 		param_id			- IDEASY_PARAM_ID
	// 		param				- ָ
	void  EasyPlayerPro_Getparam(Easy_PlayerPro_Handle player, EASY_PARAM_ID param_id, EASY_HANDLE param);


#ifdef __cplusplus
}
#endif

#endif


// ˵
/*
EASY_PARAM_MEDIA_DURATION  EASY_PARAM_MEDIA_POSITION
ڻȡýļܳȺ͵ǰλãΪλ
LONGLONG total = 1, pos = 0;
EasyPlayerPro_Getparam(g_hplayer, EASY_PARAM_MEDIA_DURATION, &total);
EasyPlayerPro_Getparam(g_hplayer, EASY_PARAM_MEDIA_POSITION, &pos  );

EASY_PARAM_VIDEO_WIDTH  EASY_PARAM_VIDEO_HEIGHT
ڻȡýļƵȺ͸߶ȣΪλ
int vw = 0, vh = 0;
EasyPlayerPro_Getparam(g_hplayer, PARAM_VIDEO_WIDTH , &vw);
EasyPlayerPro_Getparam(g_hplayer, PARAM_VIDEO_HEIGHT, &vh);

EASY_PARAM_VIDEO_MODE
ڻȡƵʾʽַʽѡ
1. EASY_VIDEO_MODE_LETTERBOX - ŵʾ
2. EASY_VIDEO_MODE_STRETCHED - 쵽ʾ
עƵʾ EasyPlayerPro_Resize 趨
int mode = 0;
EasyPlayerPro_Getparam(g_hplayer, EASY_PARAM_VIDEO_MODE, &mode);
mode = VIDEO_MODE_STRETCHED;
EasyPlayerPro_Setparam(g_hplayer, EASY_PARAM_VIDEO_MODE, &mode);

EASY_PARAM_AUDIO_VOLUME
òͬϵͳplayer ڲһ -30dB  +12dB ƵԪ
Χ[-182, 73]-182 Ӧ -30dB73 Ӧ +12dB
ֵ  0 Ӧ 0dB 棬-255 Ӧ+255 Ӧ
int volume = -0;
EasyPlayerPro_Setparam(g_hplayer, EASY_PARAM_AUDIO_VOLUME, &volume);

EASY_PARAM_PLAY_SPEED
òٶȣplayer ֱ֧ٲ
int speed = 150;
EasyPlayerPro_Setparam(g_hplayer, EASY_PARAM_PLAY_SPEED, &speed);
 speed Ϊٷֱٶȣ150 ʾ 150% в
ٶû޺ޣΪ 0 û壬ڲᴦΪ 1%
ٶȵʵޣɴĴŻֿ

EASY_PARAM_DECODE_THREAD_COUNT
Ƶ߳ե cpu Դ
int count = 6;
EasyPlayerPro_Setparam(g_hplayer, EASY_PARAM_DECODE_THREAD_COUNT, &count);
Ϊ 0 ΪԶȡ豸 CPU ĸý̸߳
Ϊ 1 Ϊ߽룬Ϊ >= 2 ֵΪ߳̽
úһ϶߳̽룬ҪӦ decoder Ƿֶ֧߳̽
һΪ 4 - 10 ҵֵܳեȡ cpu Դ֤ŵ

EASY_PARAM_VISUAL_EFFECT
ָӾЧͣplayer ֧ӾЧҪǶƵӾЧĳ
int mode = 0;
EasyPlayerPro_Getparam(g_hplayer, EASY_PARAM_VISUAL_EFFECT, &mode);
mode = EASY_AUDIO_VISUAL_EFFECT_WAVEFORM;
EasyPlayerPro_Setparam(g_hplayer, EASY_PARAM_VISUAL_EFFECT, &mode);
ĿǰܹӾЧ
1. VISUAL_EFFECT_DISABLE  - ر
2. VISUAL_EFFECT_WAVEFORM - 
3. VISUAL_EFFECT_SPECTRUM - Ƶ
עӾЧ EasyPlayerPro_Resize 趨

EASY_PARAM_AVSYNC_TIME_DIFF
 audio  video ʱֵͬΪλ
int diff = 100;
EasyPlayerPro_Setparam(g_hplayer, EASY_PARAM_AVSYNC_TIME_DIFF, &diff);
Eg: Ϊ 100 ƵƵ 100msΪ -100  100ms

EASY_PARAM_PLAYER_CALLBACK
ò¼صصԭͶ£
typedef void (*EASY_PLAYERPRO_CALLBACK)(__int32 msg, __int64 param);
صʱĲ£
msg   - PLAY_PROGRESS ŽУPLAY_COMPLETED 
param - ǰŽȣԺΪλ

EASY_PARAM_VDEV_RENDER_TYPE
ƵȾʽĿǰ EASY_VIDEO_RENDER_TYPE_GDI  EASY_VIDEO_RENDER_TYPE_D3D ֿѡ
int mode = 0;
EasyPlayerPro_Getparam(g_hplayer, PARAM_VDEV_RENDER_TYPE, &mode);
mode = EASY_VIDEO_RENDER_TYPE_D3D;
EasyPlayerPro_Setparam(g_hplayer, PARAM_VDEV_RENDER_TYPE, &mode);

EASY_PARAM_AUDIO_STREAM_TOTAL
EASY_PARAM_VIDEO_STREAM_TOTAL
EASY_PARAM_SUBTITLE_STREAM_TOTAL
ֻ(Get)ֱڻȡ audio, video, subtitle 
int streamCount = 0;
EasyPlayerPro_Getparam(g_hplayer, EASY_PARAM_AUDIO_STREAM_TOTAL, &streamCount);

EASY_PARAM_AUDIO_STREAM_CUR
EASY_PARAM_VIDEO_STREAM_CUR
EASY_PARAM_SUBTITLE_STREAM_CUR
ֱڻȡGetãSetǰŵ audio, video, subtitle 

EASY_PARAM_RECORD_TIME
EASY_PARAM_RECORD_PIECE_ID
ֻ(Get)ֱڻȡ¼ʱ͵ǰƬID
float recordTime = 0;
EasyPlayerPro_Getparam(g_hplayer, EASY_PARAM_RECORD_TIME, &recordTime);
int recordPieceId = 0;
EasyPlayerPro_Getparam(g_hplayer, EASY_PARAM_RECORD_PIECE_ID, &recordPieceId);


еĲǿ get ģеĲ setΪЩֻġ

*/