local modif = settings.startup["sw-damage-multiplier"].value


data:extend({
  
   {
    type = "explosion",
    name = "sw-electric-shock-1",
    flags = {"not-on-map"},
      animations = {
        {
          scale = 2,
          axially_symmetrical = false,
          direction_count = 1,
          filename = "__Electric-Weapons__/graphics/entity/electroshock-pulse-explosion.png",
          animation_speed = 1,
          frame_count = 7*5,
          line_length = 5,
          width = 1675/5,
          height = 2044/7,
          priority = "extra-high",
          hr_version = {
            scale = 1,
            axially_symmetrical = false,
            direction_count = 1,
            filename = "__Electric-Weapons__/graphics/entity/hr-electroshock-pulse-explosion.png",
            animation_speed = 1,
            frame_count = 7*5,
            line_length = 5,
            width = 3350/5,
            height = 4088/7,
            priority = "extra-high",
          }
        }
      },
      flags = {
        "not-on-map"
      },
      light = {
        intensity = 1,
        size = 25,
        color = {a = 1,b = 1,g = 0.3,r = 0.1},
      },
      sound = {
        aggregation = {
          max_count = 1,
          remove = true
        },
        variations = {
          {
            filename = "__Electric-Weapons__/sound/electroshock-pulse-explosion.ogg",
            volume = 1
          }
        }
      },
	  
	created_effect =
    {
              type = "area",
              radius = 9,
              action_delivery =
              {
                type = "instant",
                target_effects = {
                  {
                    type = "create-sticker",
                    sticker = "electroshock-pulse-sticker",
                  },
                  {
                    type = "damage",
                    damage = { amount = 50*modif, type = "electric"}
                  }
                }
              }
    }
  },


   {
    type = "explosion",
    name = "sw-electric-shock-2",
    flags = {"not-on-map"},
    
      animations = {
        {
          scale = 1.5,
          axially_symmetrical = false,
          direction_count = 1,
          filename = "__Electric-Weapons__/graphics/entity/electroshock-pulse-explosion.png",
          animation_speed = 1,
          frame_count = 7*5,
          line_length = 5,
          width = 1675/5,
          height = 2044/7,
          priority = "extra-high",
          hr_version = {
            scale = 0.75,
            axially_symmetrical = false,
            direction_count = 1,
            filename = "__Electric-Weapons__/graphics/entity/hr-electroshock-pulse-explosion.png",
            animation_speed = 1,
            frame_count = 7*5,
            line_length = 5,
            width = 3350/5,
            height = 4088/7,
            priority = "extra-high",
          }
        }
      },
      flags = {
        "not-on-map"
      },
      light = {
        intensity = 1,
        size = 25,
        color = {a = 1,b = 1,g = 0.3,r = 0.1},
      },
      sound = {
        aggregation = {
          max_count = 1,
          remove = true
        },
        variations = {
          {
            filename = "__Electric-Weapons__/sound/electroshock-pulse-explosion.ogg",
            volume = 1
          }
        }
      },
	  
	created_effect =
    {
              type = "area",
              radius = 12,
              action_delivery =
              {
                type = "instant",
                target_effects = {
                  {
                    type = "create-sticker",
                    sticker = "electroshock-pulse-sticker-2",
                  },
                  {
                    type = "damage",
                    damage = { amount = 100*modif, type = "electric"}
                  }
                }
              }
    }
  },

  
  
  
   {
    type = "explosion",
    name = "sw-electric-shock-3",
    flags = {"not-on-map"},
    
      animations = {
        {
          scale = 3,
          axially_symmetrical = false,
          direction_count = 1,
          filename = "__Electric-Weapons__/graphics/entity/electroshock-pulse-explosion.png",
          animation_speed = 1,
          frame_count = 7*5,
          line_length = 5,
          width = 1675/5,
          height = 2044/7,
          priority = "extra-high",
          hr_version = {
            scale = 1.5,
            axially_symmetrical = false,
            direction_count = 1,
            filename = "__Electric-Weapons__/graphics/entity/hr-electroshock-pulse-explosion.png",
            animation_speed = 1,
            frame_count = 7*5,
            line_length = 5,
            width = 3350/5,
            height = 4088/7,
            priority = "extra-high",
          }
        }
      },
      flags = {
        "not-on-map"
      },
      light = {
        intensity = 1,
        size = 25,
        color = {a = 1,b = 1,g = 0.3,r = 0.1},
      },
      sound = {
        aggregation = {
          max_count = 1,
          remove = true
        },
        variations = {
          {
            filename = "__Electric-Weapons__/sound/electroshock-pulse-explosion.ogg",
            volume = 1
          }
        }
      },
	  
	created_effect =
    {
              type = "area",
              radius = 15,
              action_delivery =
              {
                type = "instant",
                target_effects = {
                  {
                    type = "create-sticker",
                    sticker = "electroshock-pulse-sticker-2",
                  },
                  {
                    type = "damage",
                    damage = { amount = 180*modif, type = "electric"}
                  }
                }
              }
    }
  },

  
  {
    type = "sticker",
    name = "electroshock-pulse-sticker",
      animation = {
        scale = 1,
        filename = "__Electric-Weapons__/graphics/entity/electroshock-pulse-sticker.png",
        animation_speed = 0.15,
        frame_count = 16*6,
        line_length = 16,
        width = 800/16,
        height = 240/6,
        hr_version = {
          scale = 0.5,
          filename = "__Electric-Weapons__/graphics/entity/hr-electroshock-pulse-sticker.png",
          animation_speed = 0.15,
          frame_count = 16*6,
          line_length = 16,
          width = 1600/16,
          height = 480/6,
        }
      },
      duration_in_ticks = 60*8, --75
	  damage_per_tick = {amount = 1*modif, type = "electric"},
      --flags ={"not-on-map"},
      target_movement_modifier = 0.35,
  },
 
  {
    type = "sticker",
    name = "electroshock-pulse-sticker-2",
      animation = {
        scale = 1,
        filename = "__Electric-Weapons__/graphics/entity/electroshock-pulse-sticker.png",
        animation_speed = 0.15,
        frame_count = 16*6,
        line_length = 16,
        width = 800/16,
        height = 240/6,
        hr_version = {
          scale = 0.5,
          filename = "__Electric-Weapons__/graphics/entity/hr-electroshock-pulse-sticker.png",
          animation_speed = 0.15,
          frame_count = 16*6,
          line_length = 16,
          width = 1600/16,
          height = 480/6,
        }
      },
      duration_in_ticks = 60*8, --75
	  damage_per_tick = {amount = 3*modif, type = "electric"},
      --flags ={"not-on-map"},
      target_movement_modifier = 0.40,
  },
  
})

