
local modif = settings.startup["sw-damage-multiplier"].value

data:extend(
{
  {
    type = "gun",
    name = "sw-electric-gun",
    icon = "__Electric-Weapons__/graphics/icon/electric_gun.png",
    icon_size = 64, icon_mipmaps = 4,
    subgroup = "gun",
    order = "-a[military]",
    attack_parameters =
    {
      type = "beam",
      ammo_category = "electric-gun-ammo",
      cooldown = 25,
      movement_slow_down_factor = 0.4,
      damage_modifier = modif,
	  projectile_creation_distance = 5,
      range =25,
    },
    stack_size = 10
  },

  
  {
    type = "gun",
    name = "sw-electric-rifle",
    icon = "__Electric-Weapons__/graphics/icon/electric_rifle.png",
    icon_size = 64, icon_mipmaps = 4,
    subgroup = "gun",
    order = "-a[military]",
    attack_parameters =
    {
      type = "beam",
      ammo_category = "electric-gun-ammo",
      cooldown = 7,
      movement_slow_down_factor = 0.3,
      damage_modifier = modif + 0.2,
	  projectile_creation_distance = 5,
      range = 30,
    },
    stack_size = 10
  },


  {
    type = "gun",
    name = "sw-electric-bomber",
    icon = "__Electric-Weapons__/graphics/icon/electric_bomber.png",
    icon_size = 64, icon_mipmaps = 4,
    subgroup = "gun",
    order = "-a[military]",
    attack_parameters =
    {
      type = "projectile",
      ammo_category = "shockwave-ammo",
      explosion = "explosion-gunshot",
      cooldown = 100,
      movement_slow_down_factor = 0.1,
      damage_modifier = modif,
	  projectile_creation_distance = 1.225,
      range = 40,
	  sound = make_laser_sounds(),
    },
    stack_size = 1
  },
  

  
  
  
  {
    type = "ammo",
    name = "sw-electric-gun-cell",
    icon = "__Electric-Weapons__/graphics/icon/electric_ammo.png",
    icon_size = 64, icon_mipmaps = 4,
    ammo_type =
    {
      category = "electric-gun-ammo",
      action =
      {
          type = "direct",
          repeat_count = 3,
          action_delivery =
          {
            type = "beam",
            beam = "sw-electric-beam",
            max_length = 30,
            duration = 16,
		    source_offset = {0, -1}
          }
        }
    },
    magazine_size = 20,
    subgroup = "ammo",
    order = "b[shotgun]-b[piercing]",
    stack_size = 100
  }, 


  {
    type = "ammo",
    name = "sw-electric-gun-cell-wsticker",
    icon = "__Electric-Weapons__/graphics/icon/electric_ammo_sticker.png",
    icon_size = 64, icon_mipmaps = 4,
    ammo_type =
    {
      category = "electric-gun-ammo",
      action =
      {
          type = "direct",
          repeat_count = 1,
          action_delivery =
          {
            type = "projectile",
            projectile = "sw-shock-ray-wsticker",
            starting_speed = 1.5,
            direction_deviation = 0,
            range_deviation = 0,
            max_range = 30
          }
        }
    },
    magazine_size = 20,
    subgroup = "ammo",
    order = "b[shotgun]-b[piercing]",
    stack_size = 100
  }, 

  
  
  {
    type = "ammo",
    name = "sw-shock-bomb-ammo-1",
    icon = "__Electric-Weapons__/graphics/icon/shock_bomb_ammo1.png",
    icon_size = 64, icon_mipmaps = 4,
    ammo_type =
    {
      category = "shockwave-ammo",
	  target_type  = "position",
	  clamp_position = true,
      action =
      {
          type = "direct",
          repeat_count = 1,
          action_delivery =
          {
            type = "projectile",
            projectile = "sw-shock-ray-bomb-1",
            starting_speed = 0.9,
            direction_deviation = 0,
            range_deviation = 0,
            max_range = 50
          }
        }
    },
    magazine_size = 5,
    subgroup = "ammo",
    order = "b[shotgun]-b[piercing]",
    stack_size = 50
  }, 
  
  
    {
    type = "ammo",
    name = "sw-shock-bomb-ammo-2",
    icon = "__Electric-Weapons__/graphics/icon/shock_bomb_ammo2.png",
    icon_size = 64, icon_mipmaps = 4,
    ammo_type =
    {
      category = "shockwave-ammo",
	  target_type  = "position",
	  clamp_position = true,
      action =
      {
          type = "direct",
          repeat_count = 1,
          action_delivery =
          {
            type = "projectile",
            projectile = "sw-shock-ray-bomb-2",
            starting_speed = 1,
            direction_deviation = 0,
            range_deviation = 0,
            max_range = 60
          }
        }
    },
    magazine_size = 5,
    subgroup = "ammo",
    order = "b[shotgun]-b[piercing]",
    stack_size = 50
  }, 
  
  
    {
    type = "ammo",
    name = "sw-shock-bomb-ammo-3",
    icon = "__Electric-Weapons__/graphics/icon/shock_bomb_ammo3.png",
    icon_size = 64, icon_mipmaps = 4,
    ammo_type =
    {
      category = "shockwave-ammo",
	  target_type  = "position",
	  clamp_position = true,
      action =
      {
          type = "direct",
          repeat_count = 1,
          action_delivery =
          {
            type = "projectile",
            projectile = "sw-shock-ray-bomb-3",
            starting_speed = 1,
            direction_deviation = 0,
            range_deviation = 0,
            max_range = 80
          }
        }
    },
    magazine_size = 5,
    subgroup = "ammo",
    order = "b[shotgun]-b[piercing]",
    stack_size = 50
  }, 
  
  




  {
    type = "item",
    name = "sw-electric-turret-1",
    icons= ew_ico_turret_1,
    subgroup = "defensive-structure",
    order = "b[turret]-b[electric-turret-1]",
    place_result = "sw-electric-turret-1",
    stack_size = 50
  },

  {
    type = "item",
    name = "sw-electric-turret-2",
    icons= ew_ico_turret_2,
    subgroup = "defensive-structure",
    order = "b[turret]-b[electric-turret-2]",
    place_result = "sw-electric-turret-2",
    stack_size = 50
  },

  {
    type = "item",
    name = "sw-electric-turret-3",
    icons= ew_ico_turret_3,
    subgroup = "defensive-structure",
    order = "b[turret]-b[electric-turret-3]",
    place_result = "sw-electric-turret-3",
    stack_size = 50
  },


  {
    type = "item",
    name = "sw-electric-stick-turret-1",
    icons= ew_ico_turret_1a,
    subgroup = "defensive-structure",
    order = "b[turret]-b[electric-stick-turret-1]",
    place_result = "sw-electric-stick-turret-1",
    stack_size = 50
  },

  {
    type = "item",
    name = "sw-electric-stick-turret-2",
    icons= ew_ico_turret_2a,
    subgroup = "defensive-structure",
    order = "b[turret]-b[electric-stick-turret-2]",
    place_result = "sw-electric-stick-turret-2",
    stack_size = 50
  },

  {
    type = "item",
    name = "sw-electric-stick-turret-3",
    icons= ew_ico_turret_3a,
    subgroup = "defensive-structure",
    order = "b[turret]-b[electric-stick-turret-3]",
    place_result = "sw-electric-stick-turret-3",
    stack_size = 50
  },



  {
    type = "ammo",
    name = "sw-electric-rounds-magazine",
    icon = "__Electric-Weapons__/graphics/icon/electric-magazine.png",
    icon_size = 64, icon_mipmaps = 4,
    ammo_type =
    {
      category = "bullet",
      action =
      {
        type = "direct",
        action_delivery =
        {
          type = "instant",
          source_effects =
          {
            type = "create-explosion",
            entity_name = "explosion-gunshot"
          },
          target_effects =
          {
            {
              type = "create-entity",
              entity_name = "explosion-hit"
            },
            {
              type = "damage",
              damage = { amount = 6, type = "physical"}
            },
            {
              type = "damage",
              damage = { amount = 10, type = "electric"}
            }
          }
        }
      }
    },
    magazine_size = 10,
    subgroup = "ammo",
    order = "a[basic-clips]-b[electric-rounds-magazine]",
    stack_size = 200
  },



  
})