require ('colors')

function make_ew_electric_sounds()
    return
    {
      {
        filename = "__Electric-Weapons__/sound/sparks1.ogg",
        volume = 0.5
      },
      {
        filename = "__Electric-Weapons__/sound/sparks2.ogg",
        volume = 0.5
      }
    }
end


local modif = settings.startup["sw-damage-multiplier"].value

local ray = table.deepcopy(data.raw.beam['electric-beam'])
ray.name='sw-electric-beam'
ray.working_sound = make_ew_electric_sounds()


data:extend({
ray,

 {
    type = "projectile",
    name = "sw-shock-ray",
    flags = {"not-on-map"},
    collision_box = {{-0.05, -0.25}, {0.05, 0.25}},
    acceleration = 0,
    direction_only = true, -- tire nao persegue -- tiro reto
    action =
    {
      type = "direct",
      action_delivery =
      {
        type = "instant",
        target_effects =
        {
          {
            type = "damage",
            damage = {amount = 100*modif , type = "electric"}
          }
        }
      }
    },
	animation =
      {
        filename = "__Electric-Weapons__/graphics/entity/beam-body.png",
        line_length = 1,
        width = 39,
        height = 45,
        frame_count = 16,
        blend_mode = beam_blend_mode,
      },
	light = {intensity = 0.6, size = 10,color=blue},
  },

 {
    type = "projectile",
    name = "sw-shock-ray-wsticker",
    flags = {"not-on-map"},
    collision_box = {{-0.05, -0.25}, {0.05, 0.25}},
    acceleration = 0,
    direction_only = true,
    action =
    {
      type = "direct",
      action_delivery =
      {
        type = "instant",
        target_effects =
        {
          {
            type = "damage",
            damage = {amount = 50*modif , type = "electric"}
          },
          {
            type = "create-sticker",
            sticker = "electroshock-pulse-sticker",
          },
        }
      }
    },
	animation =
      {
        filename = "__Electric-Weapons__/graphics/entity/beam-body.png",
        line_length = 1,
        width = 39,
        height = 45,
        frame_count = 16,
        blend_mode = beam_blend_mode,
      },
	light = {intensity = 0.6, size = 10,color=blue},
  },


  
  
 {
    type = "projectile",
    name = "sw-shock-ray-turret",
    flags = {"not-on-map"},
    acceleration = 0.0005,
    direction_only = false, -- tire nao persegue -- tiro reto
    action =
    {
      type = "direct",
      action_delivery =
      {
        type = "instant",
        target_effects =
        {
          {
            type = "damage",
            damage = {amount = 100*modif , type = "electric"}
          }
        }
      }
    },
	animation =
      {
        filename = "__Electric-Weapons__/graphics/entity/beam-body.png",
        line_length = 1,
        width = 39,
        height = 45,
        frame_count = 16,
        blend_mode = beam_blend_mode,
      },
	light = {intensity = 0.6, size = 10,color=blue},
  },

 {
    type = "projectile",
    name = "sw-shock-ray-wsticker-turret",
    flags = {"not-on-map"},
    acceleration = 0.0005,
    direction_only = false,
    action =
    {
	 {
      type = "direct",
      action_delivery =
      {
        type = "instant",
        target_effects =
        {
          {
            type = "damage",
            damage = {amount = 50*modif , type = "electric"}
          },
        }
      }
	 }, 
  			{
			type = "area",
			radius = 3,
			action_delivery =
			{
				type = "instant",
				target_effects =
				{
				{
					type = "create-sticker",
					sticker = "electroshock-pulse-sticker",
				}
				}
			}
	 }			

    },
	
	animation =
      {
        filename = "__Electric-Weapons__/graphics/entity/beam-body.png",
        line_length = 1,
        width = 39,
        height = 45,
        frame_count = 16,
        blend_mode = beam_blend_mode,
      },
	light = {intensity = 0.6, size = 10,color=blue},
  },
  
 {
    type = "projectile",
    name = "sw-shock-ray-bomb-1",
    flags = {"not-on-map"},
    acceleration = 0,
    direction_only = false,
    action =
    {
      type = "direct",
      action_delivery =
      {
        type = "instant",
        target_effects =
        {
          {
            type = "damage",
            damage = {amount = 100*modif , type = "electric"}
          },
			{
			type = "create-entity",
			entity_name = "sw-electric-shock-1"
			},
        }
      }
    },
	animation =
      {
		scale=2,
        filename = "__Electric-Weapons__/graphics/entity/beam-body.png",
        line_length = 1,
        width = 39,
        height = 45,
        frame_count = 16,
        blend_mode = beam_blend_mode,
      },
	  light = {intensity = 0.6, size = 10,color=blue},
  },
  
 {
    type = "projectile",
    name = "sw-shock-ray-bomb-2",
    flags = {"not-on-map"},
--    collision_box = {{-0.15, -0.25}, {0.15, 0.25}},
    acceleration = 0,
    direction_only = false,
    action =
    {
      type = "direct",
      action_delivery =
      {
        type = "instant",
        target_effects =
        {
          {
            type = "damage",
            damage = {amount = 150*modif , type = "electric"}
          },
			{
			type = "create-entity",
			entity_name = "sw-electric-shock-2"
			},
        }
      }
    },
	animation =
      {
		scale=2,
        filename = "__Electric-Weapons__/graphics/entity/beam-body.png",
        line_length = 1,
        width = 39,
        height = 45,
        frame_count = 16,
        blend_mode = beam_blend_mode,
      },
	  light = {intensity = 0.6, size = 10,color=blue},
  },
 

 {
    type = "projectile",
    name = "sw-shock-ray-bomb-3",
    flags = {"not-on-map"},
    --collision_box = {{-0.15, -0.25}, {0.15, 0.25}},
    acceleration = 0,
    direction_only = false,
    action =
    {
      type = "direct",
      action_delivery =
      {
        type = "instant",
        target_effects =
        {
          {
            type = "damage",
            damage = {amount = 200*modif , type = "electric"}
          },
			{
			type = "create-entity",
			entity_name = "sw-electric-shock-3"
			},
        }
      }
    },
	animation =
      {
		scale=2,
        filename = "__Electric-Weapons__/graphics/entity/beam-body.png",
        line_length = 1,
        width = 39,
        height = 45,
        frame_count = 16,
        blend_mode = beam_blend_mode,
      },
  },
 
 
  
  
 })