require ('colors')
local modif = settings.startup["sw-damage-multiplier"].value


function sw_gun_turret_extension(inputs)
return
{
  layers =
  {
    gun_turret_extension(inputs),
    {
      filename = "__base__/graphics/entity/gun-turret/gun-turret-raising-mask.png",
      flags = { "mask" },
      width = 24,
      height = 32,
      direction_count = 4,
      frame_count = inputs.frame_count or 5,
      line_length = inputs.line_length or 0,
      run_mode = inputs.run_mode or "forward",
      shift = util.by_pixel(0, -28),
      axially_symmetrical = false,
      tint = inputs.tint or white,
      hr_version = {
        filename = "__base__/graphics/entity/gun-turret/hr-gun-turret-raising-mask.png",
        flags = { "mask" },
        width = 48,
        height = 62,
        direction_count = 4,
        frame_count = inputs.frame_count or 5,
        line_length = inputs.line_length or 0,
        run_mode = inputs.run_mode or "forward",
        shift = util.by_pixel(0, -28),
        axially_symmetrical = false,
        tint = inputs.tint or white,
        scale = 0.5
      }
    },
    gun_turret_extension_shadow(inputs),
  }
}
end

function sw_gun_turret_attack(inputs)
return
{
  layers =
  {
    {
      width = 66,
      height = 66,
      frame_count = inputs.frame_count or 2,
      axially_symmetrical = false,
      direction_count = 64,
      shift = util.by_pixel(0, -27),
      stripes =
      {
        {
          filename = "__base__/graphics/entity/gun-turret/gun-turret-shooting-1.png",
          width_in_frames = inputs.frame_count or 2,
          height_in_frames = 16
        },
        {
          filename = "__base__/graphics/entity/gun-turret/gun-turret-shooting-2.png",
          width_in_frames = inputs.frame_count or 2,
          height_in_frames = 16
        },
        {
          filename = "__base__/graphics/entity/gun-turret/gun-turret-shooting-3.png",
          width_in_frames = inputs.frame_count or 2,
          height_in_frames = 16
        },
        {
          filename = "__base__/graphics/entity/gun-turret/gun-turret-shooting-4.png",
          width_in_frames = inputs.frame_count or 2,
          height_in_frames = 16
        }
      },
      hr_version = {
        width = 132,
        height = 130,
        frame_count = inputs.frame_count and inputs.frame_count or 2,
        axially_symmetrical = false,
        direction_count = 64,
        shift = util.by_pixel(0, -27.5),
        stripes =
        {
          {
            filename = "__base__/graphics/entity/gun-turret/hr-gun-turret-shooting-1.png",
            width_in_frames = inputs.frame_count or 2,
            height_in_frames = 16,
          },
          {
            filename = "__base__/graphics/entity/gun-turret/hr-gun-turret-shooting-2.png",
            width_in_frames = inputs.frame_count or 2,
            height_in_frames = 16,
          },
          {
            filename = "__base__/graphics/entity/gun-turret/hr-gun-turret-shooting-3.png",
            width_in_frames = inputs.frame_count or 2,
            height_in_frames = 16,
          },
          {
            filename = "__base__/graphics/entity/gun-turret/hr-gun-turret-shooting-4.png",
            width_in_frames = inputs.frame_count or 2,
            height_in_frames = 16,
          }
        },
        scale = 0.5
      }
    },
    {
      flags = { "mask" },
      line_length = inputs.frame_count or 2,
      width = 30,
      height = 28,
      frame_count = inputs.frame_count or 2,
      axially_symmetrical = false,
      direction_count = 64,
      shift = util.by_pixel(0, -32),
      tint = inputs.tint or white,
      stripes =
      {
        {
          filename = "__base__/graphics/entity/gun-turret/gun-turret-shooting-mask-1.png",
          width_in_frames = inputs.frame_count or 2,
          height_in_frames = 16
        },
        {
          filename = "__base__/graphics/entity/gun-turret/gun-turret-shooting-mask-2.png",
          width_in_frames = inputs.frame_count or 2,
          height_in_frames = 16
        },
        {
          filename = "__base__/graphics/entity/gun-turret/gun-turret-shooting-mask-3.png",
          width_in_frames = inputs.frame_count or 2,
          height_in_frames = 16
        },
        {
          filename = "__base__/graphics/entity/gun-turret/gun-turret-shooting-mask-4.png",
          width_in_frames = inputs.frame_count or 2,
          height_in_frames = 16
        },        
      },
      hr_version = {
        flags = { "mask" },
        line_length = inputs.frame_count or 2,
        width = 58,
        height = 54,
        frame_count = inputs.frame_count or 2,
        axially_symmetrical = false,
        direction_count = 64,
        shift = util.by_pixel(0, -32.5),
        tint = inputs.tint or white,
        stripes =
        {
          {
            filename = "__base__/graphics/entity/gun-turret/hr-gun-turret-shooting-mask-1.png",
            width_in_frames = inputs.frame_count and inputs.frame_count or 2,
            height_in_frames = 16,
          },
          {
            filename = "__base__/graphics/entity/gun-turret/hr-gun-turret-shooting-mask-2.png",
            width_in_frames = inputs.frame_count and inputs.frame_count or 2,
            height_in_frames = 16,
          },
          {
            filename = "__base__/graphics/entity/gun-turret/hr-gun-turret-shooting-mask-3.png",
            width_in_frames = inputs.frame_count and inputs.frame_count or 2,
            height_in_frames = 16,
          },
          {
            filename = "__base__/graphics/entity/gun-turret/hr-gun-turret-shooting-mask-4.png",
            width_in_frames = inputs.frame_count and inputs.frame_count or 2,
            height_in_frames = 16,
          },        
        },
        scale = 0.5
      }
    },
    {
      width = 126,
      height = 62,
      frame_count = inputs.frame_count and inputs.frame_count or 2,
      axially_symmetrical = false,
      direction_count = 64,
      shift = util.by_pixel(23, 2),
      draw_as_shadow = true,
      stripes =
      {
        {
          filename = "__base__/graphics/entity/gun-turret/gun-turret-shooting-shadow-1.png",
          width_in_frames = inputs.frame_count or 2,
          height_in_frames = 16
        },
        {
          filename = "__base__/graphics/entity/gun-turret/gun-turret-shooting-shadow-2.png",
          width_in_frames = inputs.frame_count or 2,
          height_in_frames = 16
        },
        {
          filename = "__base__/graphics/entity/gun-turret/gun-turret-shooting-shadow-3.png",
          width_in_frames = inputs.frame_count or 2,
          height_in_frames = 16
        },
        {
          filename = "__base__/graphics/entity/gun-turret/gun-turret-shooting-shadow-4.png",
          width_in_frames = inputs.frame_count or 2,
          height_in_frames = 16
        }
      },
      hr_version = {
        width = 250,
        height = 124,
        frame_count = inputs.frame_count and inputs.frame_count or 2,
        axially_symmetrical = false,
        direction_count = 64,
        shift = util.by_pixel(22, 2.5),
        draw_as_shadow = true,
        stripes =
        {
          {
            filename = "__base__/graphics/entity/gun-turret/hr-gun-turret-shooting-shadow-1.png",
            width_in_frames = inputs.frame_count and inputs.frame_count or 2,
            height_in_frames = 16,
          },
          {
            filename = "__base__/graphics/entity/gun-turret/hr-gun-turret-shooting-shadow-2.png",
            width_in_frames = inputs.frame_count and inputs.frame_count or 2,
            height_in_frames = 16,
          },
          {
            filename = "__base__/graphics/entity/gun-turret/hr-gun-turret-shooting-shadow-3.png",
            width_in_frames = inputs.frame_count and inputs.frame_count or 2,
            height_in_frames = 16,
          },
          {
            filename = "__base__/graphics/entity/gun-turret/hr-gun-turret-shooting-shadow-4.png",
            width_in_frames = inputs.frame_count and inputs.frame_count or 2,
            height_in_frames = 16,
          }
        },
        scale = 0.5
      }
    }
  }
}
end

function sw_gun_turret_base(inputs)
return
{
  layers =
  {
    {
      filename = "__base__/graphics/entity/gun-turret/gun-turret-base.png",
      priority = "high",
      width = 76,
      height = 60,
      axially_symmetrical = false,
      direction_count = 1,
      frame_count = 1,
      shift = util.by_pixel(1, -1),
      hr_version = {
        filename = "__base__/graphics/entity/gun-turret/hr-gun-turret-base.png",
        priority = "high",
        width = 150,
        height = 118,
        axially_symmetrical = false,
        direction_count = 1,
        frame_count = 1,
        shift = util.by_pixel(0.5, -1),
        scale = 0.5
      }
    },
    {
      filename = "__base__/graphics/entity/gun-turret/gun-turret-base-mask.png",
      flags = { "mask" },
      line_length = 1,
      width = 62,
      height = 52,
      axially_symmetrical = false,
      direction_count = 1,
      frame_count = 1,
      shift = util.by_pixel(0, -4),
      tint = inputs.tint or white,
      hr_version = {
        filename = "__base__/graphics/entity/gun-turret/hr-gun-turret-base-mask.png",
        flags = { "mask" },
        line_length = 1,
        width = 122,
        height = 102,
        axially_symmetrical = false,
        direction_count = 1,
        frame_count = 1,
        shift = util.by_pixel(0, -4.5),
        tint = inputs.tint or white,
        scale = 0.5
      }
    }
  }
}
end

function sw_raising_laser_turret_extension(inputs)
return
{
  filename = "__Electric-Weapons__/graphics/entity/laser-turret-raising.png",
  priority = "medium",
  width = 65,
  height = 63,
  frame_count = inputs.frame_count and inputs.frame_count or 15,
  line_length = inputs.line_length and inputs.line_length or 0,
  run_mode = inputs.run_mode and inputs.run_mode or "forward",
  axially_symmetrical = false,
  direction_count = 4,
  shift = util.by_pixel(0, -32),
  hr_version =
  {
    filename = "__Electric-Weapons__/graphics/entity/hr-laser-turret-raising.png",
    priority = "medium",
    width = 130,
    height = 126,
    frame_count = inputs.frame_count and inputs.frame_count or 15,
    line_length = inputs.line_length and inputs.line_length or 0,
    run_mode = inputs.run_mode and inputs.run_mode or "forward",
    axially_symmetrical = false,
    direction_count = 4,
    shift = util.by_pixel(0, -32.5),
    scale = 0.5
  }
}
end

function sw_laser_turret_extension(inputs)
return
{
  layers =
  {
    sw_raising_laser_turret_extension(inputs),
    {
      filename = "__base__/graphics/entity/laser-turret/laser-turret-raising-mask.png",
      flags = { "mask" },
      width = 44,
      height = 40,
      frame_count = inputs.frame_count and inputs.frame_count or 15,
      line_length = inputs.line_length and inputs.line_length or 0,
      run_mode = inputs.run_mode and inputs.run_mode or "forward",
      axially_symmetrical = false,
      tint = inputs.tint or white,
      direction_count = 4,
      shift = util.by_pixel(0, -43),
      hr_version = {
        filename = "__base__/graphics/entity/laser-turret/hr-laser-turret-raising-mask.png",
        flags = { "mask" },
        width = 86,
        height = 80,
        frame_count = inputs.frame_count and inputs.frame_count or 15,
        line_length = inputs.line_length and inputs.line_length or 0,
        run_mode = inputs.run_mode and inputs.run_mode or "forward",
        axially_symmetrical = false,
        tint = inputs.tint or white,
        direction_count = 4,
        shift = util.by_pixel(0, -43),
        scale = 0.5
      }
    },
    laser_turret_extension_shadow(inputs)
  }
}
end




function sw_laser_turret_shooting()
  return
  {
    filename = "__Electric-Weapons__/graphics/entity/laser-turret-shooting.png",
    line_length = 8,
    width = 63,
    height = 60,
    frame_count = 1,
    direction_count = 64,
    shift = util.by_pixel(0, -35),
    hr_version =
    {
      filename = "__Electric-Weapons__/graphics/entity/hr-laser-turret-shooting.png",
      line_length = 8,
      width = 126,
      height = 120,
      frame_count = 1,
      direction_count = 64,
      shift = util.by_pixel(0, -35),
      scale = 0.5
    }
  }
end


function sw_laser_turret_attack(inputs)
return
{
  layers =
  {
    sw_laser_turret_shooting(),
    {
      filename = "__base__/graphics/entity/laser-turret/laser-turret-shooting-mask.png",
      flags = { "mask" },
      line_length = 8,
      width = 46,
      height = 42,
      frame_count = 1,
      tint = inputs.tint or white,
      direction_count = 64,
      shift = util.by_pixel(0, -43),
      hr_version = {
        filename = "__base__/graphics/entity/laser-turret/hr-laser-turret-shooting-mask.png",
        flags = { "mask" },
        line_length = 8,
        width = 92,
        height = 80,
        frame_count = 1,
        tint = inputs.tint or white,
        direction_count = 64,
        shift = util.by_pixel(0, -43.5),
        scale = 0.5
      }
    },
    laser_turret_shooting_shadow(),
  }
}
end




function sw_laser_turret_base(inputs)
return
{
  layers =
  {
    {
      filename = "__Electric-Weapons__/graphics/entity/laser-turret-base.png",
      priority = "high",
      width = 69,
      height = 52,
      axially_symmetrical = false,
      direction_count = 1,
      frame_count = 1,
      shift = util.by_pixel(0, 2),
      hr_version =
      {
        filename = "__Electric-Weapons__/graphics/entity/hr-laser-turret-base.png",
        priority = "high",
        width = 138,
        height = 104,
        axially_symmetrical = false,
        direction_count = 1,
        frame_count = 1,
        shift = util.by_pixel(-0.5, 2),
        scale = 0.5
      }
    },
    {
      filename = "__base__/graphics/entity/laser-turret/laser-turret-base-shadow.png",
      flags = { "mask" },
      line_length = 1,
      width = 66,
      height = 42,
      axially_symmetrical = false,
      draw_as_shadow = true,
      direction_count = 1,
      frame_count = 1,
      shift = util.by_pixel(6, 3),
      hr_version =
      {
        filename = "__base__/graphics/entity/laser-turret/hr-laser-turret-base-shadow.png",
        flags = { "mask" },
        line_length = 1,
        width = 132,
        height = 82,
        axially_symmetrical = false,
        draw_as_shadow = true,
        direction_count = 1,
        frame_count = 1,
        shift = util.by_pixel(6, 3),
        scale = 0.5
      }
    }
  }
}
end



function sw_turret_base(inputs)
  local anim
  if inputs.type == "gun" then
    anim = sw_gun_turret_base{tint = inputs.tint}
  else
    anim = sw_laser_turret_base{tint = inputs.tint}
  end
  return anim
end

function sw_turret_attack(inputs)
  local anim
  if inputs.type == "gun" then
    anim = sw_gun_turret_attack(inputs)
  else
    anim = sw_laser_turret_attack(inputs)
  end
  return anim
end

function sw_turret_extension(inputs)
  local anim
  if inputs.type == "gun" then
    anim = sw_gun_turret_extension(inputs)
  else
    anim = sw_laser_turret_extension(inputs)
  end
  return anim
end


function sw_gun_turret(inputs)
return
  {
    type = "ammo-turret",
    name = inputs.name,
    icon = inputs.icons,
    flags = {"placeable-player", "player-creation"},
    minable = {mining_time = 0.5, result = inputs.name},
    max_health = inputs.health,
    corpse = "medium-remnants",
    collision_box = {{-0.7, -0.7 }, {0.7, 0.7}},
    selection_box = {{-1, -1 }, {1, 1}},
    rotation_speed = 0.015,
    preparing_speed = 0.08,
    folding_speed = 0.08,
    dying_explosion = "medium-explosion",
    inventory_size = inputs.inventory_size and inputs.inventory_size or 1,
    automated_ammo_count = inputs.automated_ammo_count and inputs.automated_ammo_count or 10,
    fast_replaceable_group = "turret",
    attacking_speed = 0.5,
    folded_animation = sw_turret_extension{frame_count=1, line_length = 1, type = inputs.gun_type, tint = inputs.tint},
    preparing_animation = sw_turret_extension{type = inputs.gun_type, tint = inputs.tint},
    folding_animation = sw_turret_extension{run_mode = "backward", type = inputs.gun_type, tint = inputs.tint},
    prepared_animation = sw_turret_attack{frame_count=1, type = inputs.gun_type, tint = inputs.tint},
    attacking_animation = sw_turret_attack{type = inputs.gun_type, tint = inputs.tint},
    base_picture = inputs.base,
    vehicle_impact_sound =  { filename = "__base__/sound/car-metal-impact.ogg", volume = 0.65 },
    attack_parameters =
    {
      type = "projectile",
      ammo_category = inputs.ammo_category and inputs.ammo_category or "bullet",
      cooldown = inputs.cooldown or 6,
      projectile_creation_distance = 1.39375,
      projectile_center = {0.0625, -0.0875}, -- same as gun_turret_attack shift
      damage_modifier = inputs.damage_modifier or 2,
      range = inputs.range or 17,
      shell_particle =
      {
        name = "shell-particle",
        direction_deviation = 0.1,
        speed = 0.1,
        speed_deviation = 0.03,
        center = {0, 0},
        creation_distance = -1.925,
        starting_frame_speed = 0.2,
        starting_frame_speed_deviation = 0.1
      },
      sound = make_heavy_gunshot_sounds(),
    },
    call_for_help_radius = 40
  }
end


function make_eturret_attack_parameters(inputs)
local attack_parameters 

if inputs.type =="beam" then attack_parameters=
    {
      type = "beam",
      cooldown = inputs.cooldown or 20,
      damage_modifier = inputs.damage_modifier or 4,
      projectile_center = {0, -0.2},
      projectile_creation_distance = 1.4,
      range = inputs.range or 25,
      ammo_type =
      {
        category = "laser",
        energy_consumption = inputs.energy_consumption and inputs.energy_consumption or "800kJ",
        action =
        {
          type = "direct",
		  repeat_count = inputs.repeat_count or 2,
          action_delivery =
          {
            type = "beam",
            beam = inputs.beam or "electric-beam",
            max_length = inputs.range or 25,
            duration = inputs.cooldown or 20,
            source_offset = {0, -1.31439 }
          }
        }
      }, 
    }
	else  attack_parameters=
    {
      type = "projectile",
      ammo_category =  "laser",
      cooldown = inputs.cooldown and inputs.cooldown or 20,
      damage_modifier = inputs.damage_modifier or 4,
      projectile_center = {0, -0.2},
      projectile_creation_distance = 1.4,
      range = inputs.range and inputs.range or 25,
      ammo_type =
      {
        type = "projectile",
        category = "laser",
        energy_consumption = inputs.energy_consumption and inputs.energy_consumption or "800kJ",
        action =
        {
          {
            type = "direct",
            action_delivery =
            {
              {
                type = "projectile",
                projectile = inputs.projectile and inputs.projectile or "laser",
                starting_speed = 0.28
              }
            }
          }
        }
      },
      sound = make_laser_sounds(),
    }
	end
	
	
return attack_parameters
end


function sw_laser_turret(inputs)
return
  {
    type = "electric-turret",
    name = inputs.name,
    icons = inputs.icons,
    flags = { "placeable-player", "placeable-enemy", "player-creation"},
    minable = { mining_time = 0.5, result = inputs.name },
    max_health = inputs.health,
    corpse = "laser-turret-remnants",
    collision_box = {{ -0.7, -0.7}, {0.7, 0.7}},
    selection_box = {{ -1, -1}, {1, 1}},
    dying_explosion = "medium-explosion",
    rotation_speed = 0.01,
    preparing_speed = 0.05,
    folding_speed = 0.05,
    fast_replaceable_group = "turret",
    energy_source =
    {
      type = "electric",
      buffer_capacity = inputs.buffer_capacity and inputs.buffer_capacity or "801kJ",
      input_flow_limit = inputs.input_flow_limit and inputs.input_flow_limit or "4800kW",
      drain = inputs.drain and inputs.drain or "24kW",
      usage_priority = "primary-input"
    },
    folded_animation = sw_laser_turret_extension{frame_count=1, line_length = 1, tint = inputs.tint},
    preparing_animation = sw_laser_turret_extension{tint = inputs.tint},
    folding_animation = sw_laser_turret_extension{run_mode = "backward", tint = inputs.tint},
    prepared_animation = sw_laser_turret_attack{tint = inputs.tint},
    base_picture = inputs.base,
    vehicle_impact_sound =  { filename = "__base__/sound/car-metal-impact.ogg", volume = 0.65 },
    attack_parameters = make_eturret_attack_parameters(inputs),
    call_for_help_radius = 40
  }
end



data:extend(
{
--  sw_laser_turret{name = "laser-turret", health = 1000, buffer_capacity = "801kJ", input_flow_limit = "4800kW", drain = "24kW", energy_consumption = "800kJ", projectile = "laser", damage_modifier = 4, cooldown = 20, range = 26, tint = white, base_tint = white},
  sw_laser_turret{name = "sw-electric-turret-1", icons=ew_ico_turret_1, health = 1200, buffer_capacity = "2001kJ", input_flow_limit = "8000kW", drain = "35kW", energy_consumption = "1200kJ", type = "beam", beam="sw-electric-beam", repeat_count=1, damage_modifier = 3*modif, cooldown = 20, range = 27, tint = blue, base = sw_turret_base{type = "laser", tint = cyan}},
  sw_laser_turret{name = "sw-electric-turret-2", icons=ew_ico_turret_2, health = 1400, buffer_capacity = "3601kJ", input_flow_limit = "12000kW", drain = "40kW", energy_consumption = "1400kJ", type = "beam",beam="sw-electric-beam", repeat_count=2, damage_modifier = 2*modif, cooldown = 20, range = 28, tint = purple, base = sw_turret_base{type = "laser", tint = cyan}},
  sw_laser_turret{name = "sw-electric-turret-3", icons=ew_ico_turret_3, health = 1600, buffer_capacity = "5601kJ", input_flow_limit = "16800kW", drain = "45kW", energy_consumption = "1600kJ", type = "beam",beam="sw-electric-beam", repeat_count=3, damage_modifier = 2*modif, cooldown = 20, range = 29, tint = yellow, base = sw_turret_base{type = "laser", tint = cyan}},

  sw_laser_turret{name = "sw-electric-stick-turret-1", icons=ew_ico_turret_1a, health = 1200, buffer_capacity = "2001kJ", input_flow_limit = "8000kW" , drain = "35kW", energy_consumption = "1300kJ", type = "projectile", projectile = "sw-shock-ray-wsticker-turret", damage_modifier =-0.6+modif, cooldown = 20, range = 27, tint = blue, base = sw_turret_base{type = "laser", tint = white}},
  sw_laser_turret{name = "sw-electric-stick-turret-2", icons=ew_ico_turret_2a, health = 1400, buffer_capacity = "3601kJ", input_flow_limit = "12000kW", drain = "40kW", energy_consumption = "1500kJ", type = "projectile", projectile = "sw-shock-ray-wsticker-turret", damage_modifier =-0.3+modif, cooldown = 20, range = 28, tint = purple, base = sw_turret_base{type = "laser", tint = white}},
  sw_laser_turret{name = "sw-electric-stick-turret-3", icons=ew_ico_turret_3a, health = 1600, buffer_capacity = "5601kJ", input_flow_limit = "16800kW", drain = "45kW", energy_consumption = "1700kJ", type = "projectile",projectile = "sw-shock-ray-wsticker-turret", damage_modifier  = modif, cooldown = 20, range = 29, tint = yellow, base = sw_turret_base{type = "laser", tint = white}},
  
}
)

