/*
 * Decompiled with CFR 0.152.
 */
package mods.eln;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.network.FMLNetworkEvent;
import cpw.mods.fml.common.network.internal.FMLProxyPacket;
import io.netty.channel.ChannelHandler;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import mods.eln.Eln;
import mods.eln.client.ClientProxy;
import mods.eln.misc.Coordonate;
import mods.eln.misc.IConfigSharing;
import mods.eln.misc.Utils;
import mods.eln.node.INodeEntity;
import mods.eln.node.NodeBase;
import mods.eln.node.NodeManager;
import mods.eln.server.PlayerManager;
import mods.eln.sound.SoundClient;
import mods.eln.sound.SoundCommand;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.network.NetworkManager;
import net.minecraft.tileentity.TileEntity;

@ChannelHandler.Sharable
public class PacketHandler {
    public PacketHandler() {
        Eln.eventChannel.register((Object)this);
    }

    @SubscribeEvent
    public void onServerPacket(FMLNetworkEvent.ServerCustomPacketEvent event) {
        FMLProxyPacket packet = event.packet;
        DataInputStream stream = new DataInputStream(new ByteArrayInputStream(packet.payload().array()));
        NetworkManager manager = event.manager;
        EntityPlayerMP player = ((NetHandlerPlayServer)event.handler).field_147369_b;
        this.packetRx(stream, manager, (EntityPlayer)player);
    }

    public void packetRx(DataInputStream stream, NetworkManager manager, EntityPlayer player) {
        try {
            switch (stream.readByte()) {
                case 14: {
                    this.packetPlayerKey(stream, manager, player);
                    break;
                }
                case 15: {
                    this.packetNodeSingleSerialized(stream, manager, player);
                    break;
                }
                case 16: {
                    this.packetForNode(stream, manager, player);
                    break;
                }
                case 18: {
                    this.packetForClientNode(stream, manager, player);
                    break;
                }
                case 17: {
                    this.packetOpenLocalGui(stream, manager, player);
                    break;
                }
                case 19: {
                    this.packetPlaySound(stream, manager, player);
                    break;
                }
                case 20: {
                    this.packetDestroyUuid(stream, manager, player);
                    break;
                }
                case 21: {
                    this.packetNewClient(manager, player);
                    break;
                }
                case 22: {
                    this.packetServerInfo(stream, manager, player);
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void packetNewClient(NetworkManager manager, EntityPlayer player) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream(64);
        DataOutputStream stream = new DataOutputStream(bos);
        try {
            stream.writeByte(22);
            for (IConfigSharing c : Eln.instance.configShared) {
                c.serializeConfig(stream);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Utils.sendPacketToClient(bos, (EntityPlayerMP)player);
    }

    private void packetServerInfo(DataInputStream stream, NetworkManager manager, EntityPlayer player) {
        for (IConfigSharing c : Eln.instance.configShared) {
            try {
                c.deserialize(stream);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void packetDestroyUuid(DataInputStream stream, NetworkManager manager, EntityPlayer player) {
        try {
            ClientProxy.uuidManager.kill(stream.readInt());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    void packetPlaySound(DataInputStream stream, NetworkManager manager, EntityPlayer player) {
        try {
            if (stream.readByte() != player.field_71093_bK) {
                return;
            }
            SoundClient.play(SoundCommand.fromStream(stream, player.field_70170_p));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    void packetOpenLocalGui(DataInputStream stream, NetworkManager manager, EntityPlayer player) {
        EntityPlayer clientPlayer = player;
        try {
            clientPlayer.openGui((Object)Eln.instance, stream.readInt(), clientPlayer.field_70170_p, stream.readInt(), stream.readInt(), stream.readInt());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    void packetForNode(DataInputStream stream, NetworkManager manager, EntityPlayer player) {
        try {
            Coordonate coordonate = new Coordonate(stream.readInt(), stream.readInt(), stream.readInt(), stream.readByte());
            NodeBase node = NodeManager.instance.getNodeFromCoordonate(coordonate);
            if (node != null && node.getNodeUuid().equals(stream.readUTF())) {
                node.networkUnserialize(stream, (EntityPlayerMP)player);
            } else {
                Utils.println("packetForNode node found");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    void packetForClientNode(DataInputStream stream, NetworkManager manager, EntityPlayer player) {
        EntityPlayer clientPlayer = player;
        try {
            int x = stream.readInt();
            int y = stream.readInt();
            int z = stream.readInt();
            byte dimention = stream.readByte();
            if (clientPlayer.field_71093_bK == dimention) {
                TileEntity entity = clientPlayer.field_70170_p.func_147438_o(x, y, z);
                if (entity != null && entity instanceof INodeEntity) {
                    INodeEntity node = (INodeEntity)entity;
                    if (node.getNodeUuid().equals(stream.readUTF())) {
                        node.serverPacketUnserialize(stream);
                        if (0 != stream.available()) {
                            Utils.println("0 != stream.available()");
                        }
                    } else {
                        Utils.println("Wrong node UUID warning");
                        int dataSkipLength = stream.readByte();
                        for (int idx = 0; idx < dataSkipLength; ++idx) {
                            stream.readByte();
                        }
                    }
                }
            } else {
                Utils.println("No node found for " + x + " " + y + " " + z);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    void packetNodeSingleSerialized(DataInputStream stream, NetworkManager manager, EntityPlayer player) {
        try {
            EntityPlayer clientPlayer = player;
            int x = stream.readInt();
            int y = stream.readInt();
            int z = stream.readInt();
            byte dimention = stream.readByte();
            if (clientPlayer.field_71093_bK == dimention) {
                TileEntity entity = clientPlayer.field_70170_p.func_147438_o(x, y, z);
                if (entity != null && entity instanceof INodeEntity) {
                    INodeEntity node = (INodeEntity)entity;
                    if (node.getNodeUuid().equals(stream.readUTF())) {
                        node.serverPublishUnserialize(stream);
                        if (0 != stream.available()) {
                            Utils.println("0 != stream.available()");
                        }
                    } else {
                        Utils.println("Wrong node UUID warning");
                        int dataSkipLength = stream.readByte();
                        for (int idx = 0; idx < dataSkipLength; ++idx) {
                            stream.readByte();
                        }
                    }
                } else {
                    Utils.println("No node found for " + x + " " + y + " " + z);
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    void packetPlayerKey(DataInputStream stream, NetworkManager manager, EntityPlayer player) {
        EntityPlayerMP playerMP = (EntityPlayerMP)player;
        try {
            byte id = stream.readByte();
            boolean state = stream.readBoolean();
            if (id == 1) {
                PlayerManager.PlayerMetadata metadata = Eln.playerManager.get(playerMP);
                metadata.setInteractEnable(state);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

