/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.cable;

import mods.eln.cable.CableRenderDescriptor;
import mods.eln.cable.CableRenderType;
import mods.eln.misc.Direction;
import mods.eln.misc.LRDU;
import mods.eln.misc.LRDUMask;
import mods.eln.node.NodeBase;
import mods.eln.node.NodeBlockEntity;
import mods.eln.node.six.SixNodeElementRender;
import mods.eln.node.six.SixNodeEntity;
import net.minecraft.tileentity.TileEntity;
import org.lwjgl.opengl.GL11;

public class CableRender {
    private CableRender() {
    }

    public static CableRenderType connectionType(NodeBlockEntity entity, LRDUMask connectedSide, Direction side) {
        CableRenderType connectionTypeBuild = new CableRenderType();
        for (LRDU lrdu : LRDU.values()) {
            if (!connectedSide.get(lrdu)) continue;
            Direction sideLrdu = side.applyLRDU(lrdu);
            int x2 = entity.field_145851_c;
            int y2 = entity.field_145848_d;
            int z2 = entity.field_145849_e;
            switch (sideLrdu) {
                case XN: {
                    --x2;
                    break;
                }
                case XP: {
                    ++x2;
                    break;
                }
                case YN: {
                    --y2;
                    break;
                }
                case YP: {
                    ++y2;
                    break;
                }
                case ZN: {
                    --z2;
                    break;
                }
                case ZP: {
                    ++z2;
                    break;
                }
            }
            TileEntity otherTileEntity = entity.func_145831_w().func_147438_o(x2, y2, z2);
            if (otherTileEntity instanceof SixNodeEntity) {
                SixNodeEntity sixNodeEntity = (SixNodeEntity)otherTileEntity;
                if (sixNodeEntity.elementRenderList[side.getInt()] != null) {
                    Direction otherSide = side.applyLRDU(lrdu);
                    connectionTypeBuild.otherdry[lrdu.dir] = sixNodeEntity.getCableDry(otherSide, otherSide.getLRDUGoingTo(side));
                    connectionTypeBuild.otherRender[lrdu.dir] = sixNodeEntity.getCableRender(otherSide, otherSide.getLRDUGoingTo(side));
                    continue;
                }
            }
            if (!NodeBase.isBlockWrappable(entity.func_145831_w().func_147439_a(x2, y2, z2), entity.func_145831_w(), x2, y2, z2)) continue;
            switch (side) {
                case XN: {
                    --x2;
                    break;
                }
                case XP: {
                    ++x2;
                    break;
                }
                case YN: {
                    --y2;
                    break;
                }
                case YP: {
                    ++y2;
                    break;
                }
                case ZN: {
                    --z2;
                    break;
                }
                case ZP: {
                    ++z2;
                    break;
                }
            }
            otherTileEntity = entity.func_145831_w().func_147438_o(x2, y2, z2);
            if (!(otherTileEntity instanceof NodeBlockEntity)) continue;
            Direction otherDirection = side.getInverse();
            LRDU otherLRDU = otherDirection.getLRDUGoingTo(sideLrdu).inverse();
            CableRenderDescriptor render = entity.getCableRender(sideLrdu, sideLrdu.getLRDUGoingTo(side));
            NodeBlockEntity otherNode = (NodeBlockEntity)otherTileEntity;
            CableRenderDescriptor otherRender = otherNode.getCableRender(otherDirection, otherLRDU);
            if (render == null) continue;
            if (otherRender == null) {
                connectionTypeBuild.method[lrdu.dir] = CableRenderType.CableRenderTypeMethodType.Etend;
                connectionTypeBuild.endAt[lrdu.dir] = render.heightPixel;
                connectionTypeBuild.otherdry[lrdu.dir] = otherNode.getCableDry(otherDirection, otherLRDU);
                connectionTypeBuild.otherRender[lrdu.dir] = otherNode.getCableRender(otherDirection, otherLRDU);
                continue;
            }
            if (render.width == otherRender.width) {
                if (sideLrdu.getInt() > otherDirection.getInt()) {
                    connectionTypeBuild.method[lrdu.dir] = CableRenderType.CableRenderTypeMethodType.Etend;
                    connectionTypeBuild.endAt[lrdu.dir] = otherRender.heightPixel;
                }
                connectionTypeBuild.otherdry[lrdu.dir] = otherNode.getCableDry(otherDirection, otherLRDU);
                connectionTypeBuild.otherRender[lrdu.dir] = otherNode.getCableRender(otherDirection, otherLRDU);
                continue;
            }
            if (!(render.width < otherRender.width)) continue;
            connectionTypeBuild.method[lrdu.dir] = CableRenderType.CableRenderTypeMethodType.Etend;
            connectionTypeBuild.endAt[lrdu.dir] = otherRender.heightPixel;
            connectionTypeBuild.otherdry[lrdu.dir] = otherNode.getCableDry(otherDirection, otherLRDU);
            connectionTypeBuild.otherRender[lrdu.dir] = otherNode.getCableRender(otherDirection, otherLRDU);
        }
        return connectionTypeBuild;
    }

    public static CableRenderType connectionType(SixNodeElementRender element, Direction side) {
        CableRenderType connectionTypeBuild = new CableRenderType();
        for (LRDU lrdu : LRDU.values()) {
            if (!element.connectedSide.get(lrdu)) continue;
            Direction sideLrdu = side.applyLRDU(lrdu);
            if (element.tileEntity.elementRenderList[sideLrdu.getInt()] != null) {
                LRDU otherLRDU = sideLrdu.getLRDUGoingTo(side);
                CableRenderDescriptor render = element.getCableRender(lrdu);
                SixNodeElementRender otherElement = element.tileEntity.elementRenderList[sideLrdu.getInt()];
                CableRenderDescriptor otherRender = otherElement.getCableRender(otherLRDU);
                if (otherRender == null || render == null) continue;
                if (render.width == otherRender.width) {
                    if (side.getInt() > sideLrdu.getInt()) {
                        connectionTypeBuild.method[lrdu.dir] = CableRenderType.CableRenderTypeMethodType.Internal;
                        connectionTypeBuild.endAt[lrdu.dir] = otherRender.heightPixel;
                    }
                    connectionTypeBuild.otherdry[lrdu.dir] = otherElement.getCableDry(otherLRDU);
                    connectionTypeBuild.otherRender[lrdu.dir] = otherElement.getCableRender(otherLRDU);
                    continue;
                }
                if (render.width < otherRender.width) {
                    connectionTypeBuild.method[lrdu.dir] = CableRenderType.CableRenderTypeMethodType.Internal;
                    connectionTypeBuild.endAt[lrdu.dir] = otherRender.heightPixel;
                    connectionTypeBuild.otherdry[lrdu.dir] = otherElement.getCableDry(otherLRDU);
                    connectionTypeBuild.otherRender[lrdu.dir] = otherElement.getCableRender(otherLRDU);
                    continue;
                }
                connectionTypeBuild.otherdry[lrdu.dir] = otherElement.getCableDry(otherLRDU);
                connectionTypeBuild.otherRender[lrdu.dir] = otherElement.getCableRender(otherLRDU);
                continue;
            }
            int x2 = element.tileEntity.field_145851_c;
            int y2 = element.tileEntity.field_145848_d;
            int z2 = element.tileEntity.field_145849_e;
            switch (sideLrdu) {
                case XN: {
                    --x2;
                    break;
                }
                case XP: {
                    ++x2;
                    break;
                }
                case YN: {
                    --y2;
                    break;
                }
                case YP: {
                    ++y2;
                    break;
                }
                case ZN: {
                    --z2;
                    break;
                }
                case ZP: {
                    ++z2;
                    break;
                }
            }
            TileEntity otherTileEntity = element.tileEntity.func_145831_w().func_147438_o(x2, y2, z2);
            if (otherTileEntity instanceof SixNodeEntity) {
                SixNodeEntity sixNodeEntity = (SixNodeEntity)otherTileEntity;
                if (sixNodeEntity.elementRenderList[side.getInt()] != null) {
                    connectionTypeBuild.otherdry[lrdu.dir] = sixNodeEntity.elementRenderList[side.getInt()].getCableDry(lrdu.inverse());
                    connectionTypeBuild.otherRender[lrdu.dir] = sixNodeEntity.elementRenderList[side.getInt()].getCableRender(lrdu.inverse());
                    continue;
                }
            }
            if (!NodeBase.isBlockWrappable(element.tileEntity.func_145831_w().func_147439_a(x2, y2, z2), element.tileEntity.func_145831_w(), x2, y2, z2)) continue;
            switch (side) {
                case XN: {
                    --x2;
                    break;
                }
                case XP: {
                    ++x2;
                    break;
                }
                case YN: {
                    --y2;
                    break;
                }
                case YP: {
                    ++y2;
                    break;
                }
                case ZN: {
                    --z2;
                    break;
                }
                case ZP: {
                    ++z2;
                    break;
                }
            }
            otherTileEntity = element.tileEntity.func_145831_w().func_147438_o(x2, y2, z2);
            if (!(otherTileEntity instanceof NodeBlockEntity)) continue;
            Direction otherDirection = side.getInverse();
            LRDU otherLRDU = otherDirection.getLRDUGoingTo(sideLrdu).inverse();
            CableRenderDescriptor render = element.getCableRender(lrdu);
            if (render == null) continue;
            NodeBlockEntity otherNode = (NodeBlockEntity)otherTileEntity;
            CableRenderDescriptor otherRender = otherNode.getCableRender(otherDirection, otherLRDU);
            if (otherRender == null) {
                connectionTypeBuild.method[lrdu.dir] = CableRenderType.CableRenderTypeMethodType.Etend;
                connectionTypeBuild.endAt[lrdu.dir] = render.heightPixel;
                connectionTypeBuild.otherdry[lrdu.dir] = otherNode.getCableDry(otherDirection, otherLRDU);
                connectionTypeBuild.otherRender[lrdu.dir] = otherNode.getCableRender(otherDirection, otherLRDU);
                continue;
            }
            if (render.width == otherRender.width) {
                if (sideLrdu.getInt() > otherDirection.getInt()) {
                    connectionTypeBuild.method[lrdu.dir] = CableRenderType.CableRenderTypeMethodType.Etend;
                    connectionTypeBuild.endAt[lrdu.dir] = otherRender.heightPixel;
                }
                connectionTypeBuild.otherdry[lrdu.dir] = otherNode.getCableDry(otherDirection, otherLRDU);
                connectionTypeBuild.otherRender[lrdu.dir] = otherNode.getCableRender(otherDirection, otherLRDU);
                continue;
            }
            if (render.width < otherRender.width) {
                connectionTypeBuild.method[lrdu.dir] = CableRenderType.CableRenderTypeMethodType.Etend;
                connectionTypeBuild.endAt[lrdu.dir] = otherRender.heightPixel;
                connectionTypeBuild.otherdry[lrdu.dir] = otherNode.getCableDry(otherDirection, otherLRDU);
                connectionTypeBuild.otherRender[lrdu.dir] = otherNode.getCableRender(otherDirection, otherLRDU);
                continue;
            }
            connectionTypeBuild.otherdry[lrdu.dir] = otherNode.getCableDry(otherDirection, otherLRDU);
            connectionTypeBuild.otherRender[lrdu.dir] = otherNode.getCableRender(otherDirection, otherLRDU);
        }
        return connectionTypeBuild;
    }

    public static void drawCable(CableRenderDescriptor cable, LRDUMask connection, CableRenderType connectionType) {
        CableRender.drawCable(cable, connection, connectionType, cable.widthDiv2 / 2.0f);
    }

    public static void drawCable(CableRenderDescriptor cable, LRDUMask connection, CableRenderType connectionType, float deltaStart) {
        if (cable == null) {
            return;
        }
        float endLeft = -deltaStart;
        float endRight = deltaStart;
        float endUp = deltaStart;
        float endDown = -deltaStart;
        float startdLeft = -connectionType.startAt[0];
        float startRight = connectionType.startAt[1];
        float startUp = connectionType.startAt[2];
        float startDown = -connectionType.startAt[3];
        if (connection.mask == 0 & deltaStart >= 0.0f) {
            endLeft = -cable.widthDiv2 - 0.1875f;
            endRight = cable.widthDiv2 + 0.1875f;
            endDown = -cable.widthDiv2 - 0.1875f;
            endUp = cable.widthDiv2 + 0.1875f;
        } else {
            if (connection.get(LRDU.Left)) {
                endLeft = -0.5f;
            }
            if (connection.get(LRDU.Right)) {
                endRight = 0.5f;
            }
            if (connection.get(LRDU.Down)) {
                endDown = -0.5f;
            }
            if (connection.get(LRDU.Up)) {
                endUp = 0.5f;
            }
        }
        switch (connectionType.method[0]) {
            case Internal: {
                endLeft = (float)((double)endLeft + (double)connectionType.endAt[0] / 16.0);
                break;
            }
            case Etend: {
                endLeft = (float)((double)endLeft - (double)connectionType.endAt[0] / 16.0);
                break;
            }
        }
        switch (connectionType.method[1]) {
            case Internal: {
                endRight = (float)((double)endRight - (double)connectionType.endAt[1] / 16.0);
                break;
            }
            case Etend: {
                endRight = (float)((double)endRight + (double)connectionType.endAt[1] / 16.0);
                break;
            }
        }
        switch (connectionType.method[2]) {
            case Internal: {
                endDown = (float)((double)endDown + (double)connectionType.endAt[2] / 16.0);
                break;
            }
            case Etend: {
                endDown = (float)((double)endDown - (double)connectionType.endAt[2] / 16.0);
                break;
            }
        }
        switch (connectionType.method[3]) {
            case Internal: {
                endUp = (float)((double)endUp - (double)connectionType.endAt[3] / 16.0);
                break;
            }
            case Etend: {
                endUp = (float)((double)endUp + (double)connectionType.endAt[3] / 16.0);
                break;
            }
        }
        float height = cable.height;
        float tx = 0.25f;
        float ty = 0.5f;
        if (endLeft < startdLeft) {
            GL11.glBegin((int)8);
            GL11.glNormal3f((float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glTexCoord2f((float)(tx + (cable.widthDiv2 + height) * 0.5f), (float)(ty + endLeft));
            GL11.glVertex3f((float)0.0f, (float)cable.widthDiv2, (float)endLeft);
            GL11.glTexCoord2f((float)(tx + (cable.widthDiv2 + height) * 0.5f), (float)(ty + startdLeft));
            GL11.glVertex3f((float)0.0f, (float)cable.widthDiv2, (float)startdLeft);
            GL11.glTexCoord2f((float)(tx + cable.widthDiv2 * 0.5f), (float)(ty + endLeft));
            GL11.glVertex3f((float)height, (float)cable.widthDiv2, (float)endLeft);
            GL11.glTexCoord2f((float)(tx + cable.widthDiv2 * 0.5f), (float)(ty + startdLeft));
            GL11.glVertex3f((float)height, (float)cable.widthDiv2, (float)startdLeft);
            GL11.glNormal3f((float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glTexCoord2f((float)(tx - cable.widthDiv2 * 0.5f), (float)(ty + endLeft));
            GL11.glVertex3f((float)height, (float)(-cable.widthDiv2), (float)endLeft);
            GL11.glTexCoord2f((float)(tx - cable.widthDiv2 * 0.5f), (float)(ty + startdLeft));
            GL11.glVertex3f((float)height, (float)(-cable.widthDiv2), (float)startdLeft);
            GL11.glNormal3f((float)0.0f, (float)-1.0f, (float)0.0f);
            GL11.glTexCoord2f((float)(tx - cable.widthDiv2 * 0.5f - height), (float)(ty + endLeft));
            GL11.glVertex3f((float)0.0f, (float)(-cable.widthDiv2), (float)endLeft);
            GL11.glTexCoord2f((float)(tx - cable.widthDiv2 * 0.5f - height), (float)(ty + startdLeft));
            GL11.glVertex3f((float)0.0f, (float)(-cable.widthDiv2), (float)startdLeft);
            GL11.glEnd();
            GL11.glBegin((int)7);
            GL11.glNormal3f((float)0.0f, (float)0.0f, (float)-1.0f);
            GL11.glTexCoord2f((float)(tx - cable.widthDiv2 * 0.5f), (float)(ty + endLeft - height));
            GL11.glVertex3f((float)0.0f, (float)(-cable.widthDiv2), (float)endLeft);
            GL11.glTexCoord2f((float)(tx + cable.widthDiv2 * 0.5f), (float)(ty + endLeft - height));
            GL11.glVertex3f((float)0.0f, (float)cable.widthDiv2, (float)endLeft);
            GL11.glTexCoord2f((float)(tx + cable.widthDiv2 * 0.5f), (float)(ty + endLeft));
            GL11.glVertex3f((float)height, (float)cable.widthDiv2, (float)endLeft);
            GL11.glTexCoord2f((float)(tx - cable.widthDiv2 * 0.5f), (float)(ty + endLeft));
            GL11.glVertex3f((float)height, (float)(-cable.widthDiv2), (float)endLeft);
            GL11.glEnd();
        }
        if (endRight > startRight) {
            GL11.glBegin((int)8);
            GL11.glNormal3f((float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glTexCoord2f((float)(tx + (cable.widthDiv2 + height) * 0.5f), (float)(ty + startRight));
            GL11.glVertex3f((float)0.0f, (float)cable.widthDiv2, (float)startRight);
            GL11.glTexCoord2f((float)(tx + (cable.widthDiv2 + height) * 0.5f), (float)(ty + endRight));
            GL11.glVertex3f((float)0.0f, (float)cable.widthDiv2, (float)endRight);
            GL11.glTexCoord2f((float)(tx + cable.widthDiv2 * 0.5f), (float)(ty + startRight));
            GL11.glVertex3f((float)height, (float)cable.widthDiv2, (float)startRight);
            GL11.glTexCoord2f((float)(tx + cable.widthDiv2 * 0.5f), (float)(ty + endRight));
            GL11.glVertex3f((float)height, (float)cable.widthDiv2, (float)endRight);
            GL11.glNormal3f((float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glTexCoord2f((float)(tx - cable.widthDiv2 * 0.5f), (float)(ty + startRight));
            GL11.glVertex3f((float)height, (float)(-cable.widthDiv2), (float)startRight);
            GL11.glTexCoord2f((float)(tx - cable.widthDiv2 * 0.5f), (float)(ty + endRight));
            GL11.glVertex3f((float)height, (float)(-cable.widthDiv2), (float)endRight);
            GL11.glNormal3f((float)0.0f, (float)-1.0f, (float)0.0f);
            GL11.glTexCoord2f((float)(tx - cable.widthDiv2 * 0.5f - height), (float)(ty + startRight));
            GL11.glVertex3f((float)0.0f, (float)(-cable.widthDiv2), (float)startRight);
            GL11.glTexCoord2f((float)(tx - cable.widthDiv2 * 0.5f - height), (float)(ty + endRight));
            GL11.glVertex3f((float)0.0f, (float)(-cable.widthDiv2), (float)endRight);
            GL11.glEnd();
            GL11.glBegin((int)7);
            GL11.glNormal3f((float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glTexCoord2f((float)(tx - cable.widthDiv2 * 0.5f), (float)(ty + endRight));
            GL11.glVertex3f((float)height, (float)(-cable.widthDiv2), (float)endRight);
            GL11.glTexCoord2f((float)(tx + cable.widthDiv2 * 0.5f), (float)(ty + endRight));
            GL11.glVertex3f((float)height, (float)cable.widthDiv2, (float)endRight);
            GL11.glTexCoord2f((float)(tx + cable.widthDiv2 * 0.5f), (float)(ty + endRight + height));
            GL11.glVertex3f((float)0.0f, (float)cable.widthDiv2, (float)endRight);
            GL11.glTexCoord2f((float)(tx - cable.widthDiv2 * 0.5f), (float)(ty + endRight + height));
            GL11.glVertex3f((float)0.0f, (float)(-cable.widthDiv2), (float)endRight);
            GL11.glEnd();
        }
        if (endDown < startDown) {
            GL11.glBegin((int)8);
            GL11.glNormal3f((float)0.0f, (float)0.0f, (float)-1.0f);
            GL11.glTexCoord2f((float)(tx - (cable.widthDiv2 - height) * 0.5f), (float)(ty + endDown));
            GL11.glVertex3f((float)0.0f, (float)endDown, (float)(-cable.widthDiv2));
            GL11.glTexCoord2f((float)(tx - (cable.widthDiv2 - height) * 0.5f), (float)(ty + startDown));
            GL11.glVertex3f((float)0.0f, (float)startDown, (float)(-cable.widthDiv2));
            GL11.glTexCoord2f((float)(tx - cable.widthDiv2 * 0.5f), (float)(ty + endDown));
            GL11.glVertex3f((float)height, (float)endDown, (float)(-cable.widthDiv2));
            GL11.glTexCoord2f((float)(tx - cable.widthDiv2 * 0.5f), (float)(ty + startDown));
            GL11.glVertex3f((float)height, (float)startDown, (float)(-cable.widthDiv2));
            GL11.glNormal3f((float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glTexCoord2f((float)(tx + cable.widthDiv2 * 0.5f), (float)(ty + endDown));
            GL11.glVertex3f((float)height, (float)endDown, (float)cable.widthDiv2);
            GL11.glTexCoord2f((float)(tx + cable.widthDiv2 * 0.5f), (float)(ty + startDown));
            GL11.glVertex3f((float)height, (float)startDown, (float)cable.widthDiv2);
            GL11.glNormal3f((float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glTexCoord2f((float)(tx + (cable.widthDiv2 + height) * 0.5f), (float)(ty + endDown));
            GL11.glVertex3f((float)0.0f, (float)endDown, (float)cable.widthDiv2);
            GL11.glTexCoord2f((float)(tx + (cable.widthDiv2 + height) * 0.5f), (float)(ty + startDown));
            GL11.glVertex3f((float)0.0f, (float)startDown, (float)cable.widthDiv2);
            GL11.glEnd();
            GL11.glBegin((int)7);
            GL11.glNormal3f((float)0.0f, (float)-1.0f, (float)0.0f);
            GL11.glTexCoord2f((float)(tx - cable.widthDiv2 * 0.5f), (float)(ty + endDown));
            GL11.glVertex3f((float)height, (float)endDown, (float)(-cable.widthDiv2));
            GL11.glTexCoord2f((float)(tx + cable.widthDiv2 * 0.5f), (float)(ty + endDown));
            GL11.glVertex3f((float)height, (float)endDown, (float)cable.widthDiv2);
            GL11.glTexCoord2f((float)(tx + cable.widthDiv2 * 0.5f), (float)(ty + endDown - height));
            GL11.glVertex3f((float)0.0f, (float)endDown, (float)cable.widthDiv2);
            GL11.glTexCoord2f((float)(tx - cable.widthDiv2 * 0.5f), (float)(ty + endDown - height));
            GL11.glVertex3f((float)0.0f, (float)endDown, (float)(-cable.widthDiv2));
            GL11.glEnd();
        }
        if (endUp > startUp) {
            GL11.glBegin((int)8);
            GL11.glNormal3f((float)0.0f, (float)0.0f, (float)-1.0f);
            GL11.glTexCoord2f((float)(tx - (cable.widthDiv2 - height) * 0.5f), (float)(ty + startUp));
            GL11.glVertex3f((float)0.0f, (float)startUp, (float)(-cable.widthDiv2));
            GL11.glTexCoord2f((float)(tx - (cable.widthDiv2 - height) * 0.5f), (float)(ty + endUp));
            GL11.glVertex3f((float)0.0f, (float)endUp, (float)(-cable.widthDiv2));
            GL11.glTexCoord2f((float)(tx - cable.widthDiv2 * 0.5f), (float)(ty + startUp));
            GL11.glVertex3f((float)height, (float)startUp, (float)(-cable.widthDiv2));
            GL11.glTexCoord2f((float)(tx - cable.widthDiv2 * 0.5f), (float)(ty + endUp));
            GL11.glVertex3f((float)height, (float)endUp, (float)(-cable.widthDiv2));
            GL11.glNormal3f((float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glTexCoord2f((float)(tx + cable.widthDiv2 * 0.5f), (float)(ty + startUp));
            GL11.glVertex3f((float)height, (float)startUp, (float)cable.widthDiv2);
            GL11.glTexCoord2f((float)(tx + cable.widthDiv2 * 0.5f), (float)(ty + endUp));
            GL11.glVertex3f((float)height, (float)endUp, (float)cable.widthDiv2);
            GL11.glNormal3f((float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glTexCoord2f((float)(tx + (cable.widthDiv2 + height) * 0.5f), (float)(ty + startUp));
            GL11.glVertex3f((float)0.0f, (float)startUp, (float)cable.widthDiv2);
            GL11.glTexCoord2f((float)(tx + (cable.widthDiv2 + height) * 0.5f), (float)(ty + endUp));
            GL11.glVertex3f((float)0.0f, (float)endUp, (float)cable.widthDiv2);
            GL11.glEnd();
            GL11.glBegin((int)7);
            GL11.glNormal3f((float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glTexCoord2f((float)(tx - cable.widthDiv2 * 0.5f), (float)(ty + endUp + height));
            GL11.glVertex3f((float)0.0f, (float)endUp, (float)(-cable.widthDiv2));
            GL11.glTexCoord2f((float)(tx + cable.widthDiv2 * 0.5f), (float)(ty + endUp + height));
            GL11.glVertex3f((float)0.0f, (float)endUp, (float)cable.widthDiv2);
            GL11.glTexCoord2f((float)(tx + cable.widthDiv2 * 0.5f), (float)(ty + endUp));
            GL11.glVertex3f((float)height, (float)endUp, (float)cable.widthDiv2);
            GL11.glTexCoord2f((float)(tx - cable.widthDiv2 * 0.5f), (float)(ty + endUp));
            GL11.glVertex3f((float)height, (float)endUp, (float)(-cable.widthDiv2));
            GL11.glEnd();
        }
    }

    public static void drawNode(CableRenderDescriptor cable, LRDUMask connection, CableRenderType connectionType) {
        if (connection.mask == 0 || (connection.get(LRDU.Left) || connection.get(LRDU.Right)) && (connection.get(LRDU.Down) || connection.get(LRDU.Up)) || connection.mask == 1 || connection.mask == 2 || connection.mask == 4 || connection.mask == 8) {
            float widthDiv2 = cable.widthDiv2 + 0.0625f;
            float height = cable.height + 0.0625f;
            float tx = 0.75f;
            float ty = 0.5f;
            GL11.glColor4d((double)1.0, (double)1.0, (double)1.0, (double)1.0);
            GL11.glBegin((int)8);
            GL11.glNormal3f((float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glTexCoord2f((float)(tx + (widthDiv2 + cable.height + 0.0625f) * 0.5f), (float)(ty - widthDiv2));
            GL11.glVertex3f((float)0.0f, (float)widthDiv2, (float)(-widthDiv2));
            GL11.glTexCoord2f((float)(tx + (widthDiv2 + cable.height + 0.0625f) * 0.5f), (float)(ty + widthDiv2));
            GL11.glVertex3f((float)0.0f, (float)widthDiv2, (float)widthDiv2);
            GL11.glTexCoord2f((float)(tx + widthDiv2 * 0.5f), (float)(ty - widthDiv2));
            GL11.glVertex3f((float)height, (float)widthDiv2, (float)(-widthDiv2));
            GL11.glTexCoord2f((float)(tx + widthDiv2 * 0.5f), (float)(ty + widthDiv2));
            GL11.glVertex3f((float)height, (float)widthDiv2, (float)widthDiv2);
            GL11.glNormal3f((float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glTexCoord2f((float)(tx - widthDiv2 * 0.5f), (float)(ty - widthDiv2));
            GL11.glVertex3f((float)height, (float)(-widthDiv2), (float)(-widthDiv2));
            GL11.glTexCoord2f((float)(tx - widthDiv2 * 0.5f), (float)(ty + widthDiv2));
            GL11.glVertex3f((float)height, (float)(-widthDiv2), (float)widthDiv2);
            GL11.glNormal3f((float)0.0f, (float)-1.0f, (float)0.0f);
            GL11.glTexCoord2f((float)(tx - (widthDiv2 + cable.height + 0.0625f) * 0.5f), (float)(ty - widthDiv2));
            GL11.glVertex3f((float)0.0f, (float)(-widthDiv2), (float)(-widthDiv2));
            GL11.glTexCoord2f((float)(tx - (widthDiv2 + cable.height + 0.0625f) * 0.5f), (float)(ty + widthDiv2));
            GL11.glVertex3f((float)0.0f, (float)(-widthDiv2), (float)widthDiv2);
            GL11.glEnd();
            GL11.glBegin((int)7);
            GL11.glNormal3f((float)0.0f, (float)0.0f, (float)-1.0f);
            GL11.glTexCoord2f((float)(tx - widthDiv2 * 0.5f), (float)(ty - widthDiv2 - cable.height - 0.0625f));
            GL11.glVertex3f((float)0.0f, (float)(-widthDiv2), (float)(-widthDiv2));
            GL11.glTexCoord2f((float)(tx + widthDiv2 * 0.5f), (float)(ty - widthDiv2 - cable.height - 0.0625f));
            GL11.glVertex3f((float)0.0f, (float)widthDiv2, (float)(-widthDiv2));
            GL11.glTexCoord2f((float)(tx + widthDiv2 * 0.5f), (float)(ty - widthDiv2));
            GL11.glVertex3f((float)height, (float)widthDiv2, (float)(-widthDiv2));
            GL11.glTexCoord2f((float)(tx - widthDiv2 * 0.5f), (float)(ty - widthDiv2));
            GL11.glVertex3f((float)height, (float)(-widthDiv2), (float)(-widthDiv2));
            GL11.glNormal3f((float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glTexCoord2f((float)(tx - widthDiv2 * 0.5f), (float)(ty + widthDiv2));
            GL11.glVertex3f((float)height, (float)(-widthDiv2), (float)widthDiv2);
            GL11.glTexCoord2f((float)(tx + widthDiv2 * 0.5f), (float)(ty + widthDiv2));
            GL11.glVertex3f((float)height, (float)widthDiv2, (float)widthDiv2);
            GL11.glTexCoord2f((float)(tx + widthDiv2 * 0.5f), (float)(ty + widthDiv2 + cable.height + 0.0625f));
            GL11.glVertex3f((float)0.0f, (float)widthDiv2, (float)widthDiv2);
            GL11.glTexCoord2f((float)(tx - widthDiv2 * 0.5f), (float)(ty + widthDiv2 + cable.height + 0.0625f));
            GL11.glVertex3f((float)0.0f, (float)(-widthDiv2), (float)widthDiv2);
            GL11.glEnd();
        }
    }
}

