/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.client;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import java.io.IOException;
import mods.eln.Eln;
import mods.eln.i18n.I18N;
import mods.eln.misc.Version;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;

public class AnalyticsHandler {
    private static final String URL = "http://mc.electrical-age.net/version.php?id=%s&v=%s&l=%s";
    private static AnalyticsHandler instance;
    private boolean ready = false;

    public static AnalyticsHandler getInstance() {
        if (instance == null) {
            instance = new AnalyticsHandler();
        }
        return instance;
    }

    private AnalyticsHandler() {
        Thread analyticsThread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    String version = Version.getVersionName().replaceAll("\\s+", "");
                    String lang = I18N.getCurrentLanguage();
                    String url = String.format(AnalyticsHandler.URL, Eln.playerUUID, version, lang);
                    CloseableHttpClient client = HttpClientBuilder.create().build();
                    CloseableHttpResponse response = client.execute((HttpUriRequest)new HttpGet(url));
                    int repCode = response.getStatusLine().getStatusCode();
                    if (repCode != 200) {
                        throw new IOException("HTTP error " + repCode);
                    }
                    response.close();
                    client.close();
                }
                catch (Exception e) {
                    String error = "Unable to send analytics data: " + e.getMessage() + ".";
                    System.err.println(error);
                }
                AnalyticsHandler.getInstance().ready = true;
            }
        });
        analyticsThread.start();
    }

    @SubscribeEvent
    public void tick(TickEvent.ClientTickEvent event) {
        if (!this.ready || event.phase == TickEvent.Phase.START) {
            return;
        }
        Minecraft m = FMLClientHandler.instance().getClient();
        WorldClient world = m.field_71441_e;
        if (m == null || world == null) {
            return;
        }
        if (!this.ready) {
            return;
        }
        FMLCommonHandler.instance().bus().unregister((Object)this);
        this.ready = false;
    }
}

