/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.entity;

import java.util.ArrayList;
import java.util.Random;
import mods.eln.Eln;
import mods.eln.entity.ReplicatorEntity;
import mods.eln.misc.Coordonate;
import mods.eln.node.NodeBase;
import mods.eln.node.NodeManager;
import mods.eln.node.six.SixNode;
import mods.eln.node.six.SixNodeElement;
import mods.eln.sim.ElectricalConnection;
import mods.eln.sim.ElectricalLoad;
import mods.eln.sim.IProcess;
import mods.eln.sim.ITimeRemoverObserver;
import mods.eln.sim.TimeRemover;
import mods.eln.sim.mna.component.Resistor;
import mods.eln.sixnode.electricalcable.ElectricalCableElement;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.pathfinding.PathEntity;
import net.minecraft.util.DamageSource;

public class ReplicatoCableAI
extends EntityAIBase
implements ITimeRemoverObserver {
    ReplicatorEntity entity;
    public Coordonate cableCoordonate = null;
    Random rand = new Random();
    int lookingPerUpdate = 20;
    ElectricalLoad load = new ElectricalLoad();
    ElectricalLoad cableLoad;
    Resistor resistorLoad = new Resistor(this.load, null);
    ElectricalConnection connection;
    TimeRemover timeRemover = new TimeRemover(this);
    double moveTimeOut;
    double moveTimeOutReset = 20.0;
    double resetTimeout;
    double resetTimeoutReset = 120.0;
    PreSimCheck preSimCheck;

    public ReplicatoCableAI(ReplicatorEntity entity) {
        this.load.setAsPrivate();
        this.entity = entity;
        Eln.instance.highVoltageCableDescriptor.applyTo(this.load);
        this.load.setRs(this.load.getRs() * 10.0);
        this.func_75248_a(1);
    }

    public boolean func_75250_a() {
        ArrayList<NodeBase> nodes = NodeManager.instance.getNodes();
        if (nodes.isEmpty()) {
            return false;
        }
        for (int idx = 0; idx < this.lookingPerUpdate; ++idx) {
            NodeBase node = (NodeBase)nodes.get(this.rand.nextInt(nodes.size()));
            double distance = node.coordonate.distanceTo((Entity)this.entity);
            if (distance > 15.0 || !(node instanceof SixNode)) continue;
            SixNode sixNode = (SixNode)node;
            for (SixNodeElement e : sixNode.sideElementList) {
                PathEntity path;
                ElectricalCableElement cable;
                if (e == null || !(e instanceof ElectricalCableElement) || !this.isElectricalCableInterresting(cable = (ElectricalCableElement)e) || (path = this.entity.func_70661_as().func_75488_a((double)node.coordonate.x, (double)node.coordonate.y, (double)node.coordonate.z)) == null) continue;
                this.entity.func_70661_as().func_75484_a(path, 1.0);
                this.cableCoordonate = node.coordonate;
                this.moveTimeOut = this.moveTimeOutReset;
                this.resistorLoad.highImpedance();
                this.resetTimeout = this.resetTimeoutReset * (0.8 + Math.random() * 0.4);
                return true;
            }
        }
        return false;
    }

    public boolean func_75253_b() {
        return this.cableCoordonate != null;
    }

    public void func_75246_d() {
        this.moveTimeOut -= 0.05;
        this.resetTimeout -= 0.05;
        ElectricalCableElement cable = this.getCable();
        if (cable == null) {
            this.cableCoordonate = null;
            return;
        }
        this.cableLoad = cable.electricalLoad;
        double distance = this.cableCoordonate.distanceTo((Entity)this.entity);
        if (distance > 2.0 && (this.entity.func_70661_as().func_75505_d() == null || this.entity.func_70661_as().func_75505_d().func_75879_b())) {
            this.entity.func_70661_as().func_75492_a((double)this.cableCoordonate.x, (double)this.cableCoordonate.y, (double)this.cableCoordonate.z, 1.0);
        }
        if (distance < 2.0) {
            double u = cable.electricalLoad.getU();
            double nextRp = Math.pow(u / 50.0, -0.3) * u * u / 50.0;
            if (this.resistorLoad.getR() < 0.8 * nextRp) {
                this.entity.func_70097_a(DamageSource.field_76376_m, 5.0f);
            } else {
                this.entity.eatElectricity(this.resistorLoad.getP() * 0.05);
            }
            this.resistorLoad.setR(nextRp);
            this.timeRemover.setTimeout(0.16);
            this.moveTimeOut = this.moveTimeOutReset;
        } else {
            this.resistorLoad.highImpedance();
        }
        if (this.moveTimeOut < 0.0 || this.resetTimeout < 0.0) {
            this.cableCoordonate = null;
        }
    }

    boolean isElectricalCableInterresting(ElectricalCableElement c) {
        return !c.descriptor.signalWire && !(c.electricalLoad.getU() < 30.0);
    }

    ElectricalCableElement getCable() {
        if (this.cableCoordonate == null) {
            return null;
        }
        NodeBase node = NodeManager.instance.getNodeFromCoordonate(this.cableCoordonate);
        if (node == null) {
            return null;
        }
        if (node instanceof SixNode) {
            SixNode sixNode = (SixNode)node;
            for (SixNodeElement e : sixNode.sideElementList) {
                ElectricalCableElement cable;
                if (e == null || !(e instanceof ElectricalCableElement) || !this.isElectricalCableInterresting(cable = (ElectricalCableElement)e)) continue;
                return cable;
            }
        }
        return null;
    }

    public void func_75249_e() {
    }

    @Override
    public void timeRemoverRemove() {
        Eln.simulator.removeElectricalLoad(this.load);
        Eln.simulator.removeElectricalComponent(this.connection);
        Eln.simulator.removeElectricalComponent(this.resistorLoad);
        Eln.simulator.removeSlowPreProcess(this.preSimCheck);
        this.connection = null;
    }

    @Override
    public void timeRemoverAdd() {
        Eln.simulator.addElectricalLoad(this.load);
        this.connection = new ElectricalConnection(this.load, this.cableLoad);
        Eln.simulator.addElectricalComponent(this.connection);
        Eln.simulator.addElectricalComponent(this.resistorLoad);
        this.preSimCheck = new PreSimCheck();
        Eln.simulator.addSlowPreProcess(this.preSimCheck);
    }

    class PreSimCheck
    implements IProcess {
        PreSimCheck() {
        }

        @Override
        public void process(double time) {
            if (!ReplicatoCableAI.this.timeRemover.isArmed()) {
                return;
            }
            if (!Eln.simulator.isRegistred(ReplicatoCableAI.this.cableLoad)) {
                ReplicatoCableAI.this.timeRemover.shot();
            }
        }
    }
}

