/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.fsm;

import mods.eln.fsm.State;
import mods.eln.sim.IProcess;

public class StateMachine
implements IProcess {
    private State initialState = null;
    private State state = null;
    private boolean debug = false;

    public void setInitialState(State initialState) {
        this.initialState = initialState;
    }

    public void reset() {
        this.state = this.initialState;
        if (this.state != null) {
            this.state.enter();
        }
    }

    protected void stop() {
        this.state = null;
    }

    public void setDebug(boolean enabled) {
        this.debug = enabled;
    }

    @Override
    public void process(double time) {
        if (this.state == null) {
            if (this.debug) {
                System.out.println("INVALID STATE!!");
            }
            return;
        }
        State nextState = this.state.state(time);
        if (nextState != null && nextState != this.state) {
            if (this.debug) {
                System.out.print(this.getClass().toString() + ": " + this.state.getClass().toString() + " -> " + nextState.getClass().toString());
            }
            this.state.leave();
            this.state = nextState;
            this.state.enter();
        }
    }
}

