/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.generic;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import mods.eln.generic.GenericItemUsingDamage;
import mods.eln.misc.UtilsClient;
import mods.eln.misc.VoltageLevelColor;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.IItemRenderer;

public class GenericItemUsingDamageDescriptor {
    public String IconName;
    private IIcon iconIndex;
    public String name;
    public VoltageLevelColor voltageLevelColor = VoltageLevelColor.None;
    public Item parentItem;
    public int parentItemDamage;

    public GenericItemUsingDamageDescriptor(String name) {
        this(name, name);
    }

    public GenericItemUsingDamageDescriptor(String name, String iconName) {
        this.IconName = "eln:" + iconName.replaceAll(" ", "").toLowerCase();
        this.name = name;
    }

    public void changeDefaultIcon(String name) {
        this.IconName = "eln:" + name.replaceAll(" ", "").toLowerCase();
    }

    public NBTTagCompound getDefaultNBT() {
        return null;
    }

    public void addInformation(ItemStack itemStack, EntityPlayer entityPlayer, List list, boolean par4) {
    }

    public ItemStack onItemRightClick(ItemStack s, World w, EntityPlayer p) {
        return s;
    }

    public void getSubItems(List list) {
        ItemStack stack = this.newItemStack(1);
        list.add(stack);
    }

    public boolean use2DIcon() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void updateIcons(IIconRegister iconRegister) {
        if (this.use2DIcon()) {
            this.iconIndex = iconRegister.func_94245_a(this.IconName);
        }
    }

    public IIcon getIcon() {
        return this.iconIndex;
    }

    public String getName(ItemStack stack) {
        return this.name;
    }

    public static GenericItemUsingDamageDescriptor getDescriptor(ItemStack stack) {
        if (stack == null) {
            return null;
        }
        if (!(stack.func_77973_b() instanceof GenericItemUsingDamage)) {
            return null;
        }
        return ((GenericItemUsingDamage)stack.func_77973_b()).getDescriptor(stack);
    }

    public static GenericItemUsingDamageDescriptor getDescriptor(ItemStack stack, Class extendClass) {
        GenericItemUsingDamageDescriptor desc = GenericItemUsingDamageDescriptor.getDescriptor(stack);
        if (desc == null) {
            return null;
        }
        if (!extendClass.isAssignableFrom(desc.getClass())) {
            return null;
        }
        return desc;
    }

    public void setParent(Item item, int damage) {
        this.parentItem = item;
        this.parentItemDamage = damage;
    }

    public ItemStack newItemStack(int size) {
        ItemStack stack = new ItemStack(this.parentItem, size, this.parentItemDamage);
        stack.func_77982_d(this.getDefaultNBT());
        return stack;
    }

    public ItemStack newItemStack() {
        return this.newItemStack(1);
    }

    public boolean checkSameItemStack(ItemStack stack) {
        if (stack == null) {
            return false;
        }
        return stack.func_77973_b() == this.parentItem && stack.func_77960_j() == this.parentItemDamage;
    }

    public boolean onItemUse(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float vx, float vy, float vz) {
        return false;
    }

    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        return this.voltageLevelColor != VoltageLevelColor.None || !this.use2DIcon();
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return !this.use2DIcon();
    }

    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        if (this.getIcon() == null) {
            return;
        }
        this.voltageLevelColor.drawIconBackground(type);
        String icon = this.getIcon().func_94215_i().substring(4);
        UtilsClient.drawIcon(type, new ResourceLocation("eln", "textures/items/" + icon + ".png"));
    }

    public void onUpdate(ItemStack stack, World world, Entity entity, int par4, boolean par5) {
    }

    protected NBTTagCompound getNbt(ItemStack stack) {
        NBTTagCompound nbt = stack.func_77978_p();
        if (nbt == null) {
            nbt = this.getDefaultNBT();
            stack.func_77982_d(nbt);
        }
        return nbt;
    }

    public float getStrVsBlock(ItemStack stack, Block block) {
        return 0.2f;
    }

    public boolean onBlockDestroyed(ItemStack stack, World w, Block block, int x, int y, int z, EntityLivingBase entity) {
        return false;
    }

    public boolean onDroppedByPlayer(ItemStack item, EntityPlayer player) {
        return true;
    }

    public boolean onEntitySwing(EntityLivingBase entityLiving, ItemStack stack) {
        return false;
    }

    public boolean onBlockStartBreak(ItemStack itemstack, int x, int y, int z, EntityPlayer player) {
        return false;
    }
}

