/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.ghost;

import java.util.ArrayList;
import java.util.Iterator;
import mods.eln.Eln;
import mods.eln.misc.Coordonate;
import mods.eln.misc.Direction;
import mods.eln.misc.LRDU;
import net.minecraft.block.Block;
import net.minecraft.world.World;

public class GhostGroup {
    ArrayList<GhostGroupElement> elementList = new ArrayList();

    public void addElement(int x, int y, int z) {
        this.elementList.add(new GhostGroupElement(x, y, z, Eln.ghostBlock, 0));
    }

    public void addElement(int x, int y, int z, Block block, int meta) {
        this.elementList.add(new GhostGroupElement(x, y, z, block, meta));
    }

    public void removeElement(int x, int y, int z) {
        Iterator<GhostGroupElement> i = this.elementList.iterator();
        while (i.hasNext()) {
            GhostGroupElement g = i.next();
            if (g.x != x || g.y != y || g.z != z) continue;
            i.remove();
        }
    }

    public void addRectangle(int x1, int x2, int y1, int y2, int z1, int z2) {
        for (int x = x1; x <= x2; ++x) {
            for (int y = y1; y <= y2; ++y) {
                for (int z = z1; z <= z2; ++z) {
                    this.addElement(x, y, z);
                }
            }
        }
    }

    public boolean canBePloted(Coordonate c) {
        return this.canBePloted(c.world(), c.x, c.y, c.z);
    }

    public boolean canBePloted(World world, int x, int y, int z) {
        for (GhostGroupElement element : this.elementList) {
            if (Eln.ghostManager.canCreateGhostAt(world, x + element.x, y + element.y, z + element.z)) continue;
            return false;
        }
        return true;
    }

    public boolean plot(Coordonate coordonate, Coordonate observerCoordonate, int UUID2) {
        if (!this.canBePloted(coordonate.world(), coordonate.x, coordonate.y, coordonate.z)) {
            return false;
        }
        for (GhostGroupElement element : this.elementList) {
            Eln.ghostManager.createGhost(coordonate.newWithOffset(element.x, element.y, element.z), observerCoordonate, UUID2, element.block, element.meta);
        }
        return true;
    }

    public void erase(Coordonate observerCoordonate) {
        Eln.ghostManager.removeGhostAndBlockWithObserver(observerCoordonate);
    }

    public void erase(Coordonate observerCoordonate, int uuid) {
        Eln.ghostManager.removeGhostAndBlockWithObserver(observerCoordonate, uuid);
    }

    public void eraseGeo(Coordonate coordonate) {
        for (GhostGroupElement element : this.elementList) {
            Eln.ghostManager.removeGhostAndBlock(coordonate.newWithOffset(element.x, element.y, element.z));
        }
    }

    public GhostGroup newRotate(Direction dir) {
        GhostGroup other = new GhostGroup();
        for (GhostGroupElement element : this.elementList) {
            int z;
            int y;
            int x;
            switch (dir) {
                case XN: {
                    x = element.x;
                    y = element.y;
                    z = element.z;
                    break;
                }
                case XP: {
                    x = -element.x;
                    y = element.y;
                    z = -element.z;
                    break;
                }
                case ZN: {
                    x = -element.z;
                    y = element.y;
                    z = element.x;
                    break;
                }
                case ZP: {
                    x = element.z;
                    y = element.y;
                    z = -element.x;
                    break;
                }
                default: {
                    x = -element.y;
                    y = element.x;
                    z = element.z;
                    break;
                }
                case YP: {
                    x = element.y;
                    y = -element.x;
                    z = element.z;
                }
            }
            other.addElement(x, y, z, element.block, element.meta);
        }
        return other;
    }

    public GhostGroup newRotate(Direction dir, LRDU front) {
        GhostGroup g = this.newRotate(dir);
        return g;
    }

    public int size() {
        return this.elementList.size();
    }

    class GhostGroupElement {
        int x;
        int y;
        int z;
        Block block;
        int meta;

        public GhostGroupElement(int x, int y, int z, Block block, int meta) {
            this.x = x;
            this.y = y;
            this.z = z;
            this.block = block;
            this.meta = meta;
        }
    }
}

