/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.ghost;

import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import mods.eln.Eln;
import mods.eln.ghost.GhostElement;
import mods.eln.ghost.GhostObserver;
import mods.eln.misc.Coordonate;
import mods.eln.misc.Utils;
import mods.eln.node.NodeBase;
import mods.eln.node.NodeManager;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldSavedData;

public class GhostManager
extends WorldSavedData {
    Map<Coordonate, GhostElement> ghostTable = new Hashtable<Coordonate, GhostElement>();
    Map<Coordonate, GhostObserver> observerTable = new Hashtable<Coordonate, GhostObserver>();

    public GhostManager(String par1Str) {
        super(par1Str);
    }

    public void clear() {
        this.ghostTable.clear();
        this.observerTable.clear();
    }

    public void init() {
    }

    public boolean func_76188_b() {
        return true;
    }

    public GhostElement getGhost(Coordonate coordonate) {
        return this.ghostTable.get(coordonate);
    }

    public void removeGhost(Coordonate coordonate) {
        this.removeGhostNode(coordonate);
        this.ghostTable.remove(coordonate);
    }

    public void addObserver(GhostObserver observer) {
        this.observerTable.put(observer.getGhostObserverCoordonate(), observer);
    }

    public GhostObserver getObserver(Coordonate coordonate) {
        return this.observerTable.get(coordonate);
    }

    public void removeObserver(Coordonate coordonate) {
        this.observerTable.remove(coordonate);
    }

    public void removeGhostAndBlockWithObserver(Coordonate observerCoordonate) {
        Iterator<Map.Entry<Coordonate, GhostElement>> iterator2 = this.ghostTable.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry<Coordonate, GhostElement> entry = iterator2.next();
            GhostElement element = entry.getValue();
            if (!element.observatorCoordonate.equals(observerCoordonate)) continue;
            iterator2.remove();
            this.removeGhostNode(element.elementCoordonate);
            element.elementCoordonate.world().func_147468_f(element.elementCoordonate.x, element.elementCoordonate.y, element.elementCoordonate.z);
        }
    }

    public void removeGhostAndBlockWithObserver(Coordonate observerCoordonate, int uuid) {
        Iterator<Map.Entry<Coordonate, GhostElement>> iterator2 = this.ghostTable.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry<Coordonate, GhostElement> entry = iterator2.next();
            GhostElement element = entry.getValue();
            if (!element.observatorCoordonate.equals(observerCoordonate) || element.getUUID() != uuid) continue;
            iterator2.remove();
            this.removeGhostNode(element.elementCoordonate);
            element.elementCoordonate.world().func_147468_f(element.elementCoordonate.x, element.elementCoordonate.y, element.elementCoordonate.z);
        }
    }

    public void removeGhostAndBlockWithObserverAndNotUuid(Coordonate observerCoordonate, int uuid) {
        Iterator<Map.Entry<Coordonate, GhostElement>> iterator2 = this.ghostTable.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry<Coordonate, GhostElement> entry = iterator2.next();
            GhostElement element = entry.getValue();
            if (!element.observatorCoordonate.equals(observerCoordonate) || element.getUUID() == uuid) continue;
            iterator2.remove();
            this.removeGhostNode(element.elementCoordonate);
            element.elementCoordonate.world().func_147468_f(element.elementCoordonate.x, element.elementCoordonate.y, element.elementCoordonate.z);
        }
    }

    public void removeGhostNode(Coordonate c) {
        NodeBase node = NodeManager.instance.getNodeFromCoordonate(c);
        if (node == null) {
            return;
        }
        node.onBreakBlock();
    }

    public void removeGhostAndBlock(Coordonate coordonate) {
        this.removeGhost(coordonate);
        coordonate.world().func_147468_f(coordonate.x, coordonate.y, coordonate.z);
    }

    public void func_76184_a(NBTTagCompound nbt) {
    }

    public void func_76187_b(NBTTagCompound nbt) {
    }

    public void loadFromNBT(NBTTagCompound nbt) {
        Iterator<NBTTagCompound> iterator2 = Utils.getTags(nbt).iterator();
        while (iterator2.hasNext()) {
            NBTTagCompound o;
            NBTTagCompound tag = o = iterator2.next();
            GhostElement ghost = new GhostElement();
            ghost.readFromNBT(tag, "");
            this.ghostTable.put(ghost.elementCoordonate, ghost);
        }
    }

    public void saveToNBT(NBTTagCompound nbt, int dim) {
        int nodeCounter = 0;
        for (GhostElement ghost : this.ghostTable.values()) {
            if (dim != Integer.MIN_VALUE && ghost.elementCoordonate.dimention != dim) continue;
            NBTTagCompound nbtGhost = new NBTTagCompound();
            ghost.writeToNBT(nbtGhost, "");
            nbt.func_74782_a("n" + nodeCounter++, (NBTBase)nbtGhost);
        }
    }

    public void unload(int dimensionId) {
        Iterator<GhostElement> i = this.ghostTable.values().iterator();
        while (i.hasNext()) {
            GhostElement n = i.next();
            if (n.elementCoordonate.dimention != dimensionId) continue;
            i.remove();
        }
    }

    public boolean canCreateGhostAt(World world, int x, int y, int z) {
        if (!world.func_72863_F().func_73149_a(x >> 4, z >> 4)) {
            return false;
        }
        return world.func_147439_a(x, y, z) == Blocks.field_150350_a || world.func_147439_a(x, y, z).isReplaceable((IBlockAccess)world, x, y, z);
    }

    public void createGhost(Coordonate coordonate, Coordonate observerCoordonate, int UUID2) {
        this.createGhost(coordonate, observerCoordonate, UUID2, Eln.ghostBlock, 0);
    }

    public void createGhost(Coordonate coordonate, Coordonate observerCoordonate, int UUID2, Block block, int meta) {
        coordonate.world().func_147468_f(coordonate.x, coordonate.y, coordonate.z);
        if (coordonate.world().func_147465_d(coordonate.x, coordonate.y, coordonate.z, block, meta, 3)) {
            coordonate = new Coordonate(coordonate);
            GhostElement element = new GhostElement(coordonate, observerCoordonate, UUID2);
            this.ghostTable.put(element.elementCoordonate, element);
        }
    }
}

