/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.gridnode;

import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.UUID;
import mods.eln.generic.GenericItemBlockUsingDamageDescriptor;
import mods.eln.gridnode.GridDescriptor;
import mods.eln.gridnode.GridLink;
import mods.eln.misc.BoundingBox;
import mods.eln.misc.Coordonate;
import mods.eln.misc.Direction;
import mods.eln.misc.LRDU;
import mods.eln.misc.Obj3D;
import mods.eln.misc.Utils;
import mods.eln.node.transparent.TransparentNode;
import mods.eln.node.transparent.TransparentNodeDescriptor;
import mods.eln.node.transparent.TransparentNodeElement;
import mods.eln.sim.ElectricalLoad;
import mods.eln.sim.ThermalLoad;
import mods.eln.sixnode.electricalcable.ElectricalCableDescriptor;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.Vec3;
import org.apache.commons.lang3.tuple.Pair;

public abstract class GridElement
extends TransparentNodeElement {
    private static HashMap<UUID, Pair<Coordonate, Direction>> pending = new HashMap();
    public HashSet<GridLink> gridLinkList = new HashSet();
    public HashSet<GridLink> gridLinksBooting = new HashSet();
    GridDescriptor desc;
    int connectRange;
    private float idealRenderingAngle;

    public GridElement(TransparentNode transparentNode, TransparentNodeDescriptor descriptor, int connectRange) {
        super(transparentNode, descriptor);
        this.desc = (GridDescriptor)descriptor;
        this.connectRange = connectRange;
    }

    @Override
    public boolean onBlockActivated(EntityPlayer entityPlayer, Direction side, float vx, float vy, float vz) {
        ItemStack stack = entityPlayer.func_71045_bC();
        GenericItemBlockUsingDamageDescriptor itemDesc = GenericItemBlockUsingDamageDescriptor.getDescriptor(stack);
        if (itemDesc instanceof ElectricalCableDescriptor) {
            return this.onTryGridConnect(entityPlayer, stack, (ElectricalCableDescriptor)itemDesc, side);
        }
        return false;
    }

    private boolean onTryGridConnect(EntityPlayer entityPlayer, ItemStack stack, ElectricalCableDescriptor cable, Direction side) {
        UUID uuid = entityPlayer.getPersistentID();
        Pair<Coordonate, Direction> p = pending.get(uuid);
        GridElement other = null;
        if (p != null) {
            other = GridLink.getElementFromCoordinate((Coordonate)p.getLeft());
        }
        if (!cable.equals(this.desc.cableDescriptor)) {
            Utils.addChatMessage(entityPlayer, "Wrong cable, you need " + this.desc.cableDescriptor.name);
            return true;
        }
        if (other == null || other == this) {
            Utils.addChatMessage(entityPlayer, "Setting starting point");
            pending.put(uuid, (Pair<Coordonate, Direction>)Pair.of((Object)this.coordonate(), (Object)((Object)side)));
        } else {
            double distance = other.coordonate().trueDistanceTo(this.coordonate());
            int cableLength = (int)Math.ceil(distance);
            int range = Math.min(this.connectRange, other.connectRange);
            if ((double)stack.field_77994_a < distance) {
                Utils.addChatMessage(entityPlayer, "You need " + cableLength + " units of cable");
            } else if (distance > (double)range) {
                Utils.addChatMessage(entityPlayer, "Cannot connect, range " + Math.ceil(distance) + " and limit " + range + " blocks");
            } else if (!this.canConnect(other)) {
                Utils.addChatMessage(entityPlayer, "Cannot connect these two objects");
            } else if (!this.validLOS(other)) {
                Utils.addChatMessage(entityPlayer, "Cannot connect, no line of sight");
            } else if (GridLink.addLink(this, other, side, (Direction)((Object)p.getRight()), cable, cableLength)) {
                Utils.addChatMessage(entityPlayer, "Added connection");
                stack.func_77979_a(cableLength);
            } else {
                Utils.addChatMessage(entityPlayer, "Already connected");
            }
            pending.remove(uuid);
        }
        return true;
    }

    @Override
    public void initialize() {
        this.connect();
        for (GridLink link : this.gridLinksBooting) {
            link.connect();
        }
        this.gridLinksBooting.clear();
        this.updateIdealRenderAngle();
    }

    @Override
    public void connectJob() {
        super.connectJob();
        for (GridLink link : this.gridLinkList) {
            link.connect();
        }
    }

    @Override
    public void disconnectJob() {
        super.disconnectJob();
        for (GridLink link : this.gridLinkList) {
            link.disconnect();
        }
    }

    @Override
    public void onBreakElement() {
        super.onBreakElement();
        HashSet<GridLink> copy = new HashSet<GridLink>(this.gridLinkList);
        for (GridLink link : copy) {
            this.node.dropItem(link.onBreakElement());
        }
    }

    @Override
    public void selfDestroy() {
        super.selfDestroy();
        HashSet<GridLink> copy = new HashSet<GridLink>(this.gridLinkList);
        for (GridLink link : copy) {
            link.selfDestroy();
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        super.writeToNBT(nbt);
        Integer i = 0;
        NBTTagCompound gridLinks = Utils.newNbtTagCompund(nbt, "gridLinks");
        for (GridLink link : this.gridLinkList) {
            link.writeToNBT(Utils.newNbtTagCompund(gridLinks, i.toString()), "");
            Integer n = i;
            Integer n2 = i = Integer.valueOf(i + 1);
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        NBTTagCompound linkTag;
        super.readFromNBT(nbt);
        assert (this.gridLinkList.isEmpty());
        NBTTagCompound gridLinks = nbt.func_74775_l("gridLinks");
        Integer i = 0;
        while (!(linkTag = gridLinks.func_74775_l(i.toString())).func_82582_d()) {
            this.gridLinksBooting.add(new GridLink(linkTag, ""));
            Integer n = i;
            Integer n2 = i = Integer.valueOf(i + 1);
        }
    }

    protected abstract ElectricalLoad getGridElectricalLoad(Direction var1);

    private boolean validLOS(GridElement other) {
        return true;
    }

    protected boolean canConnect(GridElement other) {
        return true;
    }

    public void updateIdealRenderAngle() {
        if (this.desc.rotationIsFixed()) {
            switch (this.front) {
                case XN: {
                    this.idealRenderingAngle = 0.0f;
                    break;
                }
                case XP: {
                    this.idealRenderingAngle = 180.0f;
                    break;
                }
                case YN: {
                    this.idealRenderingAngle = 90.0f;
                    break;
                }
                case YP: {
                    this.idealRenderingAngle = 90.0f;
                    break;
                }
                case ZN: {
                    this.idealRenderingAngle = 270.0f;
                    break;
                }
                case ZP: {
                    this.idealRenderingAngle = 90.0f;
                }
            }
        } else if (this.gridLinkList.size() == 0) {
            this.idealRenderingAngle = 0.0f;
        } else {
            double[] angles = new double[this.gridLinkList.size()];
            int i = 0;
            for (GridLink link : this.gridLinkList) {
                Coordonate vec = link.a.subtract(link.b);
                if (vec.z < 0) {
                    vec = vec.negate();
                }
                double h = Math.sqrt(vec.x * vec.x + vec.z * vec.z);
                angles[i++] = Math.acos((double)vec.x / h);
            }
            double optAngle = 0.0;
            double optErr = Double.POSITIVE_INFINITY;
            for (i = 0; i < 128; ++i) {
                double angle = Math.PI * (double)i / 128.0;
                double error = 0.0;
                for (double a : angles) {
                    double err = Math.abs(Math.sin(angle - a));
                    error += err * err * err;
                }
                if (!(error < optErr)) continue;
                optAngle = angle;
                optErr = error;
            }
            this.idealRenderingAngle = (float)Math.toDegrees(-optAngle);
        }
    }

    @Override
    public void networkSerialize(DataOutputStream stream) {
        super.networkSerialize(stream);
        try {
            stream.writeFloat(this.idealRenderingAngle);
            ArrayList<GridLink> ourLinks = new ArrayList<GridLink>();
            for (GridLink link : this.gridLinkList) {
                if (!link.a.equals(this.coordonate())) continue;
                ourLinks.add(link);
            }
            stream.writeInt(ourLinks.size());
            for (GridLink link : ourLinks) {
                GridElement target = link.getOtherElement(this);
                Direction ourSide = link.getSide(this);
                Direction theirSide = link.getSide(target);
                Coordonate offset = link.b.subtract(link.a);
                for (int i = 0; i < 2; ++i) {
                    Vec3 start2 = this.getCablePoint(ourSide, i);
                    start2.func_72442_b((float)Math.toRadians(this.idealRenderingAngle));
                    Vec3 end = target.getCablePoint(theirSide, i);
                    end.func_72442_b((float)Math.toRadians(target.idealRenderingAngle));
                    end = end.func_72441_c((double)offset.x, (double)offset.y, (double)offset.z);
                    this.writeVec(stream, start2);
                    this.writeVec(stream, end);
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected Vec3 getCablePoint(Direction side, int i) {
        if (i >= 2) {
            throw new AssertionError((Object)"Invalid cable point index");
        }
        Obj3D.Obj3DPart part = (i == 0 ? this.desc.plus : this.desc.gnd).get(0);
        BoundingBox bb = part.boundingBox();
        return bb.centre();
    }

    private void writeVec(DataOutputStream stream, Vec3 sp) throws IOException {
        stream.writeFloat((float)sp.field_72450_a);
        stream.writeFloat((float)sp.field_72448_b);
        stream.writeFloat((float)sp.field_72449_c);
    }

    @Override
    public String multiMeterString(Direction side) {
        ElectricalLoad electricalLoad = this.getGridElectricalLoad(side);
        return Utils.plotUIP(electricalLoad.getU(), electricalLoad.getI());
    }

    @Override
    public String thermoMeterString(Direction side) {
        ThermalLoad thermalLoad = this.getThermalLoad(side, LRDU.Up);
        return Utils.plotCelsius("T", thermalLoad.Tc);
    }
}

