/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.gridnode;

import java.util.HashSet;
import java.util.Optional;
import mods.eln.Eln;
import mods.eln.gridnode.GridElement;
import mods.eln.misc.Coordonate;
import mods.eln.misc.Direction;
import mods.eln.misc.INBTTReady;
import mods.eln.node.NodeBase;
import mods.eln.node.NodeManager;
import mods.eln.node.transparent.TransparentNode;
import mods.eln.sim.ElectricalConnection;
import mods.eln.sim.ElectricalLoad;
import mods.eln.sixnode.electricalcable.ElectricalCableDescriptor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class GridLink
implements INBTTReady {
    Coordonate a = new Coordonate();
    Coordonate b = new Coordonate();
    boolean connected = false;
    ItemStack cable;
    private Direction as;
    private Direction bs;
    private Optional<GridElement> ae = Optional.empty();
    private Optional<GridElement> be = Optional.empty();
    private ElectricalConnection ab;
    private double rs = 1.0E9;

    public GridLink(Coordonate a, Coordonate b, Direction as, Direction bs, ItemStack cable, double rs) {
        this.rs = rs;
        assert (a != null && b != null && as != null && bs != null && cable != null);
        this.a = a;
        this.b = b;
        this.as = as;
        this.bs = bs;
        this.cable = cable;
    }

    public GridLink(NBTTagCompound nbt, String str) {
        this.readFromNBT(nbt, str);
    }

    public static GridElement getElementFromCoordinate(Coordonate coord) {
        if (coord == null) {
            return null;
        }
        NodeBase base = NodeManager.instance.getNodeFromCoordonate(coord);
        TransparentNode node = (TransparentNode)base;
        if (node != null && node.element instanceof GridElement) {
            return (GridElement)node.element;
        }
        return null;
    }

    public static boolean addLink(GridElement a, GridElement b, Direction as, Direction bs, ElectricalCableDescriptor cable, int cableLength) {
        for (GridLink link : a.gridLinkList) {
            if (!link.links(a, b)) continue;
            return false;
        }
        for (GridLink link : b.gridLinkList) {
            if (!link.links(a, b)) continue;
            return false;
        }
        GridLink link = new GridLink(a.coordonate(), b.coordonate(), as, bs, cable.newItemStack(cableLength), cable.electricalRs * (double)cableLength);
        link.connect();
        return true;
    }

    public GridElement elementA() {
        if (!this.ae.isPresent()) {
            this.ae = Optional.of(GridLink.getElementFromCoordinate(this.a));
        }
        return this.ae.get();
    }

    public GridElement elementB() {
        if (!this.be.isPresent()) {
            this.be = Optional.of(GridLink.getElementFromCoordinate(this.b));
        }
        return this.be.get();
    }

    public boolean connect() {
        GridElement a = GridLink.getElementFromCoordinate(this.a);
        GridElement b = GridLink.getElementFromCoordinate(this.b);
        if (a == null || b == null || this.connected) {
            return false;
        }
        ElectricalLoad aLoad = a.getGridElectricalLoad(this.as);
        ElectricalLoad bLoad = b.getGridElectricalLoad(this.bs);
        assert (aLoad != null);
        assert (bLoad != null);
        assert (this.ab == null);
        this.ab = new ElectricalConnection(aLoad, bLoad);
        Eln.simulator.addElectricalComponent(this.ab);
        this.ab.setR(this.rs);
        a.gridLinkList.add(this);
        b.gridLinkList.add(this);
        this.updateElement(a);
        this.updateElement(b);
        this.connected = true;
        return true;
    }

    private void updateElement(GridElement e) {
        e.updateIdealRenderAngle();
        HashSet<GridElement> s = new HashSet<GridElement>();
        s.add(e);
        for (GridLink link : e.gridLinkList) {
            s.add(link.elementA());
            s.add(link.elementB());
        }
        for (GridElement element : s) {
            element.needPublish();
        }
    }

    public void disconnect() {
        if (!this.connected) {
            return;
        }
        GridElement a = GridLink.getElementFromCoordinate(this.a);
        GridElement b = GridLink.getElementFromCoordinate(this.b);
        Eln.simulator.removeElectricalComponent(this.ab);
        this.ab = null;
        this.updateElement(a);
        this.updateElement(b);
        this.connected = false;
    }

    private boolean links(GridElement a, GridElement b) {
        if (this.a.equals(a.coordonate())) {
            return this.b.equals(b.coordonate());
        }
        if (this.a.equals(b.coordonate())) {
            return this.b.equals(a.coordonate());
        }
        return false;
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt, String str) {
        this.a.readFromNBT(nbt, str + "a");
        this.b.readFromNBT(nbt, str + "b");
        this.as = Direction.readFromNBT(nbt, str + "as");
        this.bs = Direction.readFromNBT(nbt, str + "bs");
        this.rs = nbt.func_74769_h(str + "rs");
        this.cable = ItemStack.func_77949_a((NBTTagCompound)nbt);
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt, String str) {
        this.a.writeToNBT(nbt, str + "a");
        this.b.writeToNBT(nbt, str + "b");
        this.as.writeToNBT(nbt, str + "as");
        this.bs.writeToNBT(nbt, str + "bs");
        nbt.func_74780_a(str + "rs", this.rs);
        this.cable.func_77955_b(nbt);
    }

    public void selfDestroy() {
        this.onBreakElement();
    }

    public ItemStack onBreakElement() {
        GridElement a = GridLink.getElementFromCoordinate(this.a);
        GridElement b = GridLink.getElementFromCoordinate(this.b);
        a.gridLinkList.remove(this);
        b.gridLinkList.remove(this);
        this.disconnect();
        return this.cable;
    }

    public Direction getSide(GridElement gridElement) {
        if (gridElement == this.elementA()) {
            return this.as;
        }
        return this.bs;
    }

    public GridElement getOtherElement(GridElement gridElement) {
        if (gridElement == this.elementA()) {
            return this.elementB();
        }
        return this.elementA();
    }
}

