/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.gridnode;

import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import mods.eln.gridnode.GridDescriptor;
import mods.eln.misc.UtilsClient;
import mods.eln.node.transparent.TransparentNodeDescriptor;
import mods.eln.node.transparent.TransparentNodeElementRender;
import mods.eln.node.transparent.TransparentNodeEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Vec3;
import org.lwjgl.opengl.GL11;

public abstract class GridRender
extends TransparentNodeElementRender {
    private final GridDescriptor descriptor;
    private final ResourceLocation cableTexture;
    private ArrayList<Catenary> catenaries = new ArrayList();
    private float idealRenderingAngle;

    public GridRender(TransparentNodeEntity tileEntity, TransparentNodeDescriptor descriptor) {
        super(tileEntity, descriptor);
        this.descriptor = (GridDescriptor)descriptor;
        this.cableTexture = new ResourceLocation("eln", this.descriptor.cableTexture);
    }

    @Override
    public void draw() {
        this.descriptor.draw(this.idealRenderingAngle);
        UtilsClient.bindTexture(this.cableTexture);
        GL11.glDisable((int)2884);
        for (Catenary catenary : this.catenaries) {
            catenary.draw();
        }
        GL11.glEnable((int)2884);
    }

    private Vec3 readVec(DataInputStream stream) throws IOException {
        return Vec3.func_72443_a((double)stream.readFloat(), (double)stream.readFloat(), (double)stream.readFloat());
    }

    @Override
    public void networkUnserialize(DataInputStream stream) {
        super.networkUnserialize(stream);
        try {
            for (Catenary catenary : this.catenaries) {
                catenary.destroy();
            }
            this.catenaries.clear();
            this.idealRenderingAngle = stream.readFloat();
            int linkCount = stream.readInt();
            for (int i = 0; i < linkCount; ++i) {
                Vec3 splus = this.readVec(stream);
                Vec3 tplus = this.readVec(stream);
                Vec3 sgnd = this.readVec(stream);
                Vec3 tgnd = this.readVec(stream);
                Vec3 dplus = splus.func_72444_a(tplus).func_72432_b();
                Vec3 dgnd = sgnd.func_72444_a(tgnd).func_72432_b();
                double straightV = dplus.func_72430_b(dgnd);
                dplus = splus.func_72444_a(tgnd).func_72432_b();
                double crossV = dplus.func_72430_b(dgnd = sgnd.func_72444_a(tplus).func_72432_b());
                if (crossV < straightV) {
                    this.catenaries.add(new Catenary(splus, tplus));
                    this.catenaries.add(new Catenary(sgnd, tgnd));
                    continue;
                }
                this.catenaries.add(new Catenary(splus, tgnd));
                this.catenaries.add(new Catenary(sgnd, tplus));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean cameraDrawOptimisation() {
        return false;
    }

    private class Catenary {
        final int list;
        final Vec3 origin = Vec3.func_72443_a((double)0.0, (double)0.0, (double)0.0);
        final int[] box = new int[]{3, 7, 5, 3, 5, 1, 4, 8, 6, 4, 6, 2, 1, 6, 5, 1, 2, 6, 3, 8, 7, 3, 4, 8};
        final int[] boxTex = new int[]{0, 0, 0, 1, 0, 1, 0, 0, 1, 0, 1, 1, 1, 1, 1, 0};
        private final double cableWidth = 0.05;

        Catenary(Vec3 start2, Vec3 end) {
            Vec3[] catenary = this.getConnectionCatenary(start2, end);
            this.list = GL11.glGenLists((int)1);
            GL11.glNewList((int)this.list, (int)4864);
            GL11.glBegin((int)4);
            if (start2.field_72450_a == end.field_72450_a && start2.field_72449_c == end.field_72449_c) {
                this.drawBox(this.spread(start2, end), this.spread(end, start2));
            } else {
                Vec3[] previous = this.spread(start2, catenary[0]);
                for (int i = 0; i < catenary.length - 1; ++i) {
                    Vec3[] next = this.spread(catenary[i], catenary[i + 1]);
                    this.drawBox(previous, next);
                    previous = next;
                }
                Vec3[] last = this.translate(previous, catenary[catenary.length - 2].func_72444_a(catenary[catenary.length - 1]));
                this.drawBox(previous, last);
            }
            GL11.glEnd();
            GL11.glEndList();
        }

        private void drawBox(Vec3[] from, Vec3[] to) {
            Vec3[] v = new Vec3[]{from[0], from[1], from[2], from[3], to[0], to[1], to[2], to[3]};
            for (int i = 0; i < this.box.length; ++i) {
                int bc = this.box[i] - 1;
                GL11.glTexCoord2f((float)this.boxTex[bc * 2], (float)this.boxTex[bc * 2 + 1]);
                GL11.glVertex3f((float)((float)v[bc].field_72450_a), (float)((float)v[bc].field_72448_b), (float)((float)v[bc].field_72449_c));
            }
        }

        private Vec3[] translate(Vec3[] start2, Vec3 delta) {
            Vec3[] ret = new Vec3[start2.length];
            for (int i = 0; i < start2.length; ++i) {
                ret[i] = start2[i].func_72441_c(delta.field_72450_a, delta.field_72448_b, delta.field_72449_c);
            }
            return ret;
        }

        private Vec3[] spread(Vec3 a, Vec3 b) {
            Vec3 delta = b.func_72444_a(a);
            Vec3 r = delta.func_72432_b();
            r.func_72442_b(1.0f);
            r.func_72440_a(1.0f);
            Vec3 x1 = this.multiply(delta.func_72431_c(r).func_72432_b(), 0.05);
            Vec3 y1 = this.multiply(delta.func_72431_c(x1).func_72432_b(), 0.05);
            Vec3 x2 = this.negate(x1);
            Vec3 y2 = this.negate(y1);
            return this.translate(new Vec3[]{x1, y1, y2, x2}, a);
        }

        private Vec3 negate(Vec3 v) {
            return v.func_72444_a(this.origin);
        }

        Vec3 multiply(Vec3 a, double b) {
            return Vec3.func_72443_a((double)(a.field_72450_a * b), (double)(a.field_72448_b * b), (double)(a.field_72449_c * b));
        }

        private Vec3[] getConnectionCatenary(Vec3 start2, Vec3 end) {
            double slack = 1.005;
            int vertices = 16;
            double dx = end.field_72450_a - start2.field_72450_a;
            double dy = end.field_72448_b - start2.field_72448_b;
            double dz = end.field_72449_c - start2.field_72449_c;
            double dw = Math.sqrt(dx * dx + dz * dz);
            double k = Math.sqrt(dx * dx + dy * dy + dz * dz) * 1.005;
            double l = 0.0;
            for (int limiter = 0; limiter < 300; ++limiter) {
                if (!(Math.sinh(l += 0.01) / l >= Math.sqrt(k * k - dy * dy) / dw)) continue;
            }
            double a = dw / 2.0 / l;
            double p = (0.0 + dw - a * Math.log((k + dy) / (k - dy))) * 0.5;
            double q = (dy + 0.0 - k * Math.cosh(l) / Math.sinh(l)) * 0.5;
            Vec3[] vex = new Vec3[16];
            for (int i = 0; i < 16; ++i) {
                float n1 = (float)(i + 1) / 16.0f;
                double x1 = 0.0 + dx * (double)n1;
                double z1 = 0.0 + dz * (double)n1;
                double y1 = a * Math.cosh((Math.sqrt(x1 * x1 + z1 * z1) - p) / a) + q;
                vex[i] = Vec3.func_72443_a((double)(start2.field_72450_a + x1), (double)(start2.field_72448_b + y1), (double)(start2.field_72449_c + z1));
            }
            return vex;
        }

        public void draw() {
            GL11.glCallList((int)this.list);
        }

        public void destroy() {
            GL11.glDeleteLists((int)this.list, (int)1);
        }
    }
}

