/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.gridnode.downlink;

import mods.eln.gridnode.GridElement;
import mods.eln.gridnode.downlink.DownlinkDescriptor;
import mods.eln.misc.Direction;
import mods.eln.misc.LRDU;
import mods.eln.node.transparent.TransparentNode;
import mods.eln.node.transparent.TransparentNodeDescriptor;
import mods.eln.sim.ElectricalLoad;
import mods.eln.sim.ThermalLoad;
import mods.eln.sim.nbt.NbtElectricalLoad;
import mods.eln.sim.nbt.NbtThermalLoad;
import mods.eln.sim.process.destruct.ThermalLoadWatchDog;
import mods.eln.sim.process.destruct.VoltageStateWatchDog;
import mods.eln.sim.process.destruct.WorldExplosion;
import mods.eln.sim.process.heater.ElectricalLoadHeatThermalLoad;
import mods.eln.sixnode.electricalcable.ElectricalCableDescriptor;

public class DownlinkElement
extends GridElement {
    DownlinkDescriptor desc;
    ElectricalCableDescriptor cableDescriptor;
    NbtElectricalLoad electricalLoad = new NbtElectricalLoad("electricalLoad");
    NbtThermalLoad thermalLoad = new NbtThermalLoad("thermalLoad");
    ElectricalLoadHeatThermalLoad heater = new ElectricalLoadHeatThermalLoad(this.electricalLoad, this.thermalLoad);
    ThermalLoadWatchDog thermalWatchdog = new ThermalLoadWatchDog();
    VoltageStateWatchDog voltageWatchdog = new VoltageStateWatchDog();

    public DownlinkElement(TransparentNode node, TransparentNodeDescriptor descriptor) {
        super(node, descriptor, 6);
        this.desc = (DownlinkDescriptor)descriptor;
        this.electricalLoad.setCanBeSimplifiedByLine(true);
        this.desc.cableDescriptor.applyTo(this.electricalLoad);
        this.desc.cableDescriptor.applyTo(this.thermalLoad);
        this.electricalLoadList.add(this.electricalLoad);
        this.thermalLoadList.add(this.thermalLoad);
        this.slowProcessList.add(this.heater);
        this.thermalLoad.setAsSlow();
        this.slowProcessList.add(this.thermalWatchdog);
        this.thermalWatchdog.set(this.thermalLoad).setLimit(this.desc.cableDescriptor.thermalWarmLimit, this.desc.cableDescriptor.thermalCoolLimit).set(new WorldExplosion(this).cableExplosion());
        this.slowProcessList.add(this.voltageWatchdog);
        this.voltageWatchdog.set(this.electricalLoad).setUMaxMin(this.desc.cableDescriptor.electricalNominalVoltage * 16.0).set(new WorldExplosion(this).cableExplosion());
    }

    @Override
    protected ElectricalLoad getGridElectricalLoad(Direction side) {
        return this.electricalLoad;
    }

    @Override
    public ElectricalLoad getElectricalLoad(Direction side, LRDU lrdu) {
        return this.electricalLoad;
    }

    @Override
    public ThermalLoad getThermalLoad(Direction side, LRDU lrdu) {
        return this.thermalLoad;
    }

    @Override
    public int getConnectionMask(Direction side, LRDU lrdu) {
        return 1;
    }
}

