/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.gridnode.electricalpole;

import java.io.DataOutputStream;
import mods.eln.Eln;
import mods.eln.gridnode.GridElement;
import mods.eln.gridnode.electricalpole.ElectricalPoleDescriptor;
import mods.eln.misc.Direction;
import mods.eln.misc.LRDU;
import mods.eln.misc.Utils;
import mods.eln.node.transparent.TransparentNode;
import mods.eln.node.transparent.TransparentNodeDescriptor;
import mods.eln.sim.ElectricalLoad;
import mods.eln.sim.ThermalLoad;
import mods.eln.sim.mna.component.VoltageSource;
import mods.eln.sim.mna.process.TransformerInterSystemProcess;
import mods.eln.sim.nbt.NbtElectricalLoad;
import mods.eln.sim.nbt.NbtThermalLoad;
import mods.eln.sim.process.destruct.ThermalLoadWatchDog;
import mods.eln.sim.process.destruct.VoltageStateWatchDog;
import mods.eln.sim.process.destruct.WorldExplosion;
import mods.eln.sim.process.heater.ElectricalLoadHeatThermalLoad;
import mods.eln.sound.SoundCommand;
import mods.eln.sound.SoundLooper;

public class ElectricalPoleElement
extends GridElement {
    public NbtElectricalLoad electricalLoad = new NbtElectricalLoad("electricalLoad");
    public NbtThermalLoad thermalLoad = new NbtThermalLoad("thermalLoad");
    public NbtElectricalLoad secondaryLoad;
    public VoltageSource primaryVoltageSource;
    public VoltageSource secondaryVoltageSource;
    public TransformerInterSystemProcess interSystemProcess;
    ElectricalPoleDescriptor desc;
    ElectricalLoadHeatThermalLoad heater = new ElectricalLoadHeatThermalLoad(this.electricalLoad, this.thermalLoad);
    ThermalLoadWatchDog thermalWatchdog = new ThermalLoadWatchDog();
    VoltageStateWatchDog voltageWatchdog = new VoltageStateWatchDog();
    float secondaryMaxCurrent = 0.0f;
    SoundLooper highLoadSoundLooper;
    VoltageStateWatchDog voltageSecondaryWatchdog;

    public ElectricalPoleElement(TransparentNode node, TransparentNodeDescriptor descriptor) {
        super(node, descriptor, 24);
        this.desc = (ElectricalPoleDescriptor)descriptor;
        this.electricalLoad.setCanBeSimplifiedByLine(true);
        this.desc.cableDescriptor.applyTo(this.electricalLoad);
        this.desc.cableDescriptor.applyTo(this.thermalLoad);
        this.electricalLoadList.add(this.electricalLoad);
        this.thermalLoadList.add(this.thermalLoad);
        this.slowProcessList.add(this.heater);
        this.thermalLoad.setAsSlow();
        this.slowProcessList.add(this.thermalWatchdog);
        this.thermalWatchdog.set(this.thermalLoad).setLimit(this.desc.cableDescriptor.thermalWarmLimit, this.desc.cableDescriptor.thermalCoolLimit).set(new WorldExplosion(this).cableExplosion());
        this.slowProcessList.add(this.voltageWatchdog);
        WorldExplosion exp = this.desc.includeTransformer ? new WorldExplosion(this).machineExplosion() : new WorldExplosion(this).cableExplosion();
        this.voltageWatchdog.set(this.electricalLoad).setUMaxMin(this.desc.cableDescriptor.electricalNominalVoltage * 16.0).set(exp);
        if (this.desc.includeTransformer) {
            this.secondaryLoad = new NbtElectricalLoad("secondaryLoad");
            this.desc.cableDescriptor.applyTo(this.secondaryLoad, 4.0);
            this.primaryVoltageSource = new VoltageSource("primaryVoltageSource", this.electricalLoad, null);
            this.secondaryVoltageSource = new VoltageSource("secondaryVoltageSource", this.secondaryLoad, null);
            this.interSystemProcess = new TransformerInterSystemProcess(this.electricalLoad, this.secondaryLoad, this.primaryVoltageSource, this.secondaryVoltageSource);
            this.voltageSecondaryWatchdog = new VoltageStateWatchDog();
            this.electricalLoadList.add(this.secondaryLoad);
            this.electricalComponentList.add(this.primaryVoltageSource);
            this.electricalComponentList.add(this.secondaryVoltageSource);
            this.slowProcessList.add(this.voltageSecondaryWatchdog.set(this.secondaryLoad).set(exp));
            this.highLoadSoundLooper = new SoundLooper(this){

                @Override
                public SoundCommand mustStart() {
                    float load;
                    if (ElectricalPoleElement.this.secondaryMaxCurrent != 0.0f && (load = (float)(ElectricalPoleElement.this.secondaryLoad.getI() / (double)ElectricalPoleElement.this.secondaryMaxCurrent)) > ElectricalPoleElement.this.desc.minimalLoadToHum) {
                        return ElectricalPoleElement.this.desc.highLoadSound.copy().mulVolume(0.2f * (load - ElectricalPoleElement.this.desc.minimalLoadToHum) / (1.0f - ElectricalPoleElement.this.desc.minimalLoadToHum), 1.0f).smallRange();
                    }
                    return null;
                }
            };
            this.slowProcessList.add(this.highLoadSoundLooper);
        }
    }

    @Override
    public void disconnectJob() {
        super.disconnectJob();
        if (this.desc.includeTransformer) {
            Eln.simulator.mna.removeProcess(this.interSystemProcess);
        }
    }

    @Override
    public void connectJob() {
        if (this.desc.includeTransformer) {
            Eln.simulator.mna.addProcess(this.interSystemProcess);
        }
        super.connectJob();
    }

    @Override
    public String multiMeterString(Direction side) {
        if (this.desc.includeTransformer) {
            return Utils.plotVolt("GridU:", this.electricalLoad.getU()) + Utils.plotAmpere("GridP:", this.electricalLoad.getCurrent()) + Utils.plotVolt("  GroundU:", this.secondaryLoad.getU()) + Utils.plotAmpere("GroundP:", this.secondaryLoad.getCurrent());
        }
        return super.multiMeterString(side);
    }

    @Override
    public ElectricalLoad getElectricalLoad(Direction side, LRDU lrdu) {
        return this.secondaryLoad;
    }

    @Override
    public ElectricalLoad getGridElectricalLoad(Direction side) {
        return this.electricalLoad;
    }

    @Override
    public ThermalLoad getThermalLoad(Direction side, LRDU lrdu) {
        return this.thermalLoad;
    }

    @Override
    public int getConnectionMask(Direction side, LRDU lrdu) {
        if (this.desc.includeTransformer) {
            return 1;
        }
        return 0;
    }

    @Override
    public void initialize() {
        if (this.desc.includeTransformer) {
            this.setupTransformer();
        }
        super.initialize();
    }

    public void setupTransformer() {
        this.voltageSecondaryWatchdog.setUNominal(3200.0);
        this.secondaryMaxCurrent = (float)this.desc.cableDescriptor.electricalMaximalCurrent;
        this.interSystemProcess.setRatio(0.25);
    }

    @Override
    public void networkSerialize(DataOutputStream stream) {
        super.networkSerialize(stream);
        this.node.lrduCubeMask.getTranslate(this.front.down()).serialize(stream);
    }
}

