/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.gridnode.transformer;

import mods.eln.Eln;
import mods.eln.gridnode.GridElement;
import mods.eln.gridnode.transformer.GridTransformerDescriptor;
import mods.eln.misc.BoundingBox;
import mods.eln.misc.Direction;
import mods.eln.misc.LRDU;
import mods.eln.misc.Obj3D;
import mods.eln.misc.Utils;
import mods.eln.node.transparent.TransparentNode;
import mods.eln.node.transparent.TransparentNodeDescriptor;
import mods.eln.sim.ElectricalLoad;
import mods.eln.sim.ThermalLoad;
import mods.eln.sim.mna.component.VoltageSource;
import mods.eln.sim.mna.process.TransformerInterSystemProcess;
import mods.eln.sim.nbt.NbtElectricalLoad;
import mods.eln.sim.process.destruct.VoltageStateWatchDog;
import mods.eln.sim.process.destruct.WorldExplosion;
import mods.eln.sound.SoundCommand;
import mods.eln.sound.SoundLooper;
import net.minecraft.util.Vec3;

public class GridTransformerElement
extends GridElement {
    public NbtElectricalLoad primaryLoad = new NbtElectricalLoad("primaryLoad");
    public NbtElectricalLoad secondaryLoad = new NbtElectricalLoad("secondaryLoad");
    public VoltageSource primaryVoltageSource = new VoltageSource("primaryVoltageSource", this.primaryLoad, null);
    public VoltageSource secondaryVoltageSource = new VoltageSource("secondaryVoltageSource", this.secondaryLoad, null);
    public TransformerInterSystemProcess interSystemProcess = new TransformerInterSystemProcess(this.primaryLoad, this.secondaryLoad, this.primaryVoltageSource, this.secondaryVoltageSource);
    GridTransformerDescriptor desc;
    float primaryMaxCurrent = 0.0f;
    float secondaryMaxCurrent = 0.0f;
    SoundLooper highLoadSoundLooper;
    VoltageStateWatchDog voltagePrimaryWatchdog = new VoltageStateWatchDog();
    VoltageStateWatchDog voltageSecondaryWatchdog = new VoltageStateWatchDog();

    public GridTransformerElement(TransparentNode node, TransparentNodeDescriptor descriptor) {
        super(node, descriptor, 4);
        this.desc = (GridTransformerDescriptor)descriptor;
        this.electricalLoadList.add(this.primaryLoad);
        this.electricalLoadList.add(this.secondaryLoad);
        this.electricalComponentList.add(this.primaryVoltageSource);
        this.electricalComponentList.add(this.secondaryVoltageSource);
        WorldExplosion exp = new WorldExplosion(this).machineExplosion();
        this.slowProcessList.add(this.voltagePrimaryWatchdog.set(this.primaryLoad).set(exp));
        this.slowProcessList.add(this.voltageSecondaryWatchdog.set(this.secondaryLoad).set(exp));
        this.desc.cableDescriptor.applyTo(this.primaryLoad);
        this.desc.cableDescriptor.applyTo(this.secondaryLoad, 4.0);
        this.highLoadSoundLooper = new SoundLooper(this){

            @Override
            public SoundCommand mustStart() {
                float load;
                if (GridTransformerElement.this.primaryMaxCurrent != 0.0f && GridTransformerElement.this.secondaryMaxCurrent != 0.0f && (load = (float)Math.max(GridTransformerElement.this.primaryLoad.getI() / (double)GridTransformerElement.this.primaryMaxCurrent, GridTransformerElement.this.secondaryLoad.getI() / (double)GridTransformerElement.this.secondaryMaxCurrent)) > GridTransformerElement.this.desc.minimalLoadToHum) {
                    return GridTransformerElement.this.desc.highLoadSound.copy().mulVolume(0.2f * (load - GridTransformerElement.this.desc.minimalLoadToHum) / (1.0f - GridTransformerElement.this.desc.minimalLoadToHum), 1.0f).smallRange();
                }
                return null;
            }
        };
        this.slowProcessList.add(this.highLoadSoundLooper);
    }

    @Override
    public int getConnectionMask(Direction side, LRDU lrdu) {
        return 0;
    }

    @Override
    public void disconnectJob() {
        super.disconnectJob();
        Eln.simulator.mna.removeProcess(this.interSystemProcess);
    }

    @Override
    public void connectJob() {
        Eln.simulator.mna.addProcess(this.interSystemProcess);
        super.connectJob();
    }

    @Override
    public ElectricalLoad getElectricalLoad(Direction side, LRDU lrdu) {
        if (lrdu != LRDU.Down) {
            return null;
        }
        if (side == this.front.up()) {
            return this.primaryLoad;
        }
        return this.secondaryLoad;
    }

    @Override
    public Vec3 getCablePoint(Direction side, int i) {
        if (i >= 2) {
            throw new AssertionError((Object)"Invalid cable point index");
        }
        int idx = side == this.front.up() ? 1 : 0;
        Obj3D.Obj3DPart part = (Obj3D.Obj3DPart)(i == 0 ? this.desc.plus : this.desc.gnd).get(idx);
        BoundingBox bb = part.boundingBox();
        return bb.centre();
    }

    @Override
    public ElectricalLoad getGridElectricalLoad(Direction side) {
        return this.getElectricalLoad(side, LRDU.Down);
    }

    @Override
    public ThermalLoad getThermalLoad(Direction side, LRDU lrdu) {
        return null;
    }

    @Override
    public String multiMeterString(Direction side) {
        if (side == this.front.up()) {
            return Utils.plotVolt("UP+:", this.primaryLoad.getU()) + Utils.plotAmpere("IP+:", this.primaryLoad.getCurrent());
        }
        if (side == this.front.left()) {
            return Utils.plotVolt("US+:", this.secondaryLoad.getU()) + Utils.plotAmpere("IS+:", this.secondaryLoad.getCurrent());
        }
        return Utils.plotVolt("UP+:", this.primaryLoad.getU()) + Utils.plotAmpere("IP+:", this.primaryLoad.getCurrent()) + Utils.plotVolt("  US+:", this.secondaryLoad.getU()) + Utils.plotAmpere("IS+:", this.secondaryLoad.getCurrent());
    }

    @Override
    public String thermoMeterString(Direction side) {
        return null;
    }

    @Override
    public void initialize() {
        this.computeInventory();
        super.initialize();
    }

    public void computeInventory() {
        this.voltagePrimaryWatchdog.setUNominal(12800.0);
        this.voltageSecondaryWatchdog.setUNominal(51200.0);
        this.primaryMaxCurrent = (float)this.desc.cableDescriptor.electricalMaximalCurrent;
        this.secondaryMaxCurrent = (float)this.desc.cableDescriptor.electricalMaximalCurrent;
        this.interSystemProcess.setRatio(0.25);
    }

    @Override
    public float getLightOpacity() {
        return 1.0f;
    }
}

