/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.gui;

import java.util.ArrayList;
import java.util.List;
import mods.eln.gui.GuiButtonEln;
import mods.eln.gui.GuiTextFieldEln;
import mods.eln.gui.GuiVerticalProgressBar;
import mods.eln.gui.GuiVerticalTrackBar;
import mods.eln.gui.GuiVerticalTrackBarHeat;
import mods.eln.gui.IGuiObject;
import mods.eln.misc.UtilsClient;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class GuiHelper {
    public GuiScreen screen;
    public int xSize;
    public int ySize;
    ResourceLocation background;
    static final ResourceLocation helperTexture = new ResourceLocation("eln", "sprites/gui/helpertexture.png");
    static final ResourceLocation slotSkin = new ResourceLocation("textures/gui/container/furnace.png");
    public static final Tessellator tessellator = new Tessellator();
    ArrayList<IGuiObject> objectList = new ArrayList();

    public GuiHelper(GuiScreen screen, int xSize, int ySize, String backgroundName) {
        this.screen = screen;
        this.xSize = xSize;
        this.ySize = ySize;
        this.background = new ResourceLocation("eln", "sprites/gui/" + backgroundName);
    }

    public GuiHelper(GuiScreen screen, int xSize, int ySize) {
        this.screen = screen;
        this.xSize = xSize;
        this.ySize = ySize;
    }

    GuiTextFieldEln newGuiTextField(int x, int y, int width) {
        GuiTextFieldEln o = new GuiTextFieldEln(Minecraft.func_71410_x().field_71466_p, this.screen.field_146294_l / 2 - this.xSize / 2 + x, this.screen.field_146295_m / 2 - this.ySize / 2 + y, width, 12, this);
        this.objectList.add(o);
        return o;
    }

    GuiButtonEln newGuiButton(int x, int y, int width, String name) {
        GuiButtonEln o = new GuiButtonEln(this.screen.field_146294_l / 2 - this.xSize / 2 + x, this.screen.field_146295_m / 2 - this.ySize / 2 + y, width, 20, name);
        o.setHelper(this);
        this.objectList.add(o);
        return o;
    }

    GuiVerticalTrackBar newGuiVerticalTrackBar(int x, int y, int width, int height) {
        GuiVerticalTrackBar o = new GuiVerticalTrackBar(this.screen.field_146294_l / 2 - this.xSize / 2 + x, this.screen.field_146295_m / 2 - this.ySize / 2 + y, width, height, this);
        this.objectList.add(o);
        return o;
    }

    GuiVerticalTrackBarHeat newGuiVerticalTrackBarHeat(int x, int y, int width, int height) {
        GuiVerticalTrackBarHeat o = new GuiVerticalTrackBarHeat(this.screen.field_146294_l / 2 - this.xSize / 2 + x, this.screen.field_146295_m / 2 - this.ySize / 2 + y, width, height, this);
        this.objectList.add(o);
        return o;
    }

    public GuiVerticalProgressBar newGuiVerticalProgressBar(int x, int y, int width, int height) {
        GuiVerticalProgressBar o = new GuiVerticalProgressBar(this.screen.field_146294_l / 2 - this.xSize / 2 + x, this.screen.field_146295_m / 2 - this.ySize / 2 + y, width, height, this);
        this.objectList.add(o);
        return o;
    }

    public void add(IGuiObject o) {
        o.translate(this.screen.field_146294_l / 2 - this.xSize / 2, this.screen.field_146295_m / 2 - this.ySize / 2);
        this.objectList.add(o);
    }

    public void remove(IGuiObject o) {
        o.translate(-this.screen.field_146294_l / 2 + this.xSize / 2, -this.screen.field_146295_m / 2 + this.ySize / 2);
        this.objectList.remove(o);
    }

    void draw(int x, int y, float f) {
        this.screen.func_146276_q_();
        if (this.background != null) {
            UtilsClient.drawGuiBackground(this.background, this.screen, this.xSize, this.ySize);
        } else {
            UtilsClient.bindTexture(helperTexture);
            int px = 0;
            int py = 0;
            GuiScreen.func_73734_a((int)((px += (this.screen.field_146294_l - this.xSize) / 2) + 2), (int)((py += (this.screen.field_146295_m - this.ySize) / 2) + 2), (int)(px + this.xSize - 2), (int)(py + this.ySize - 2), (int)-3750202);
            GuiScreen.func_73734_a((int)(px + 4), (int)py, (int)(px + this.xSize - 4), (int)(py + 1), (int)-16777216);
            GuiScreen.func_73734_a((int)(px + 4), (int)(py + 1), (int)(px + this.xSize - 4), (int)(py + 3), (int)-1);
            GuiScreen.func_73734_a((int)(px + 4), (int)(py + this.ySize - 1), (int)(px + this.xSize - 4), (int)(py + this.ySize - 0), (int)-16777216);
            GuiScreen.func_73734_a((int)(px + 4), (int)(py + this.ySize - 3), (int)(px + this.xSize - 4), (int)(py + this.ySize - 1), (int)-11184811);
            GuiScreen.func_73734_a((int)px, (int)(py + 4), (int)(px + 1), (int)(py + this.ySize - 4), (int)-16777216);
            GuiScreen.func_73734_a((int)(px + 1), (int)(py + 4), (int)(px + 3), (int)(py + this.ySize - 4), (int)-1);
            GuiScreen.func_73734_a((int)(px + this.xSize - 1), (int)(py + 4), (int)(px + this.xSize - 0), (int)(py + this.ySize - 4), (int)-16777216);
            GuiScreen.func_73734_a((int)(px + this.xSize - 3), (int)(py + 4), (int)(px + this.xSize - 1), (int)(py + this.ySize - 4), (int)-11184811);
            GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
            this.screen.func_73729_b(px, py, 0, 0, 4, 4);
            this.screen.func_73729_b(px + this.xSize - 4, py, 4, 0, 4, 4);
            this.screen.func_73729_b(px, py + this.ySize - 4, 0, 4, 4, 4);
            this.screen.func_73729_b(px + this.xSize - 4, py + this.ySize - 4, 4, 4, 4, 4);
        }
        for (IGuiObject o : this.objectList) {
            o.idraw(x, y, f);
        }
    }

    public void drawTexturedModalRect(int x, int y, int u, int v, int width, int height) {
        this.screen.func_73729_b(x += (this.screen.field_146294_l - this.xSize) / 2, y += (this.screen.field_146295_m - this.ySize) / 2, u, v, width, height);
    }

    public void drawRect(int x0, int y0, int x1, int y1, int color) {
        int dx = (this.screen.field_146294_l - this.xSize) / 2;
        int dy = (this.screen.field_146295_m - this.ySize) / 2;
        GuiScreen.func_73734_a((int)(x0 + dx), (int)(y0 + dy), (int)(x1 + dx), (int)(y1 + dy), (int)color);
    }

    IGuiObject[] objectListCopy() {
        IGuiObject[] cpy = new IGuiObject[this.objectList.size()];
        for (int idx = 0; idx < cpy.length; ++idx) {
            cpy[idx] = this.objectList.get(idx);
        }
        return cpy;
    }

    protected void keyTyped(char key, int code) {
        for (IGuiObject o : this.objectListCopy()) {
            o.ikeyTyped(key, code);
        }
    }

    protected void mouseClicked(int x, int y, int code) {
        for (IGuiObject o : this.objectListCopy()) {
            o.imouseClicked(x, y, code);
        }
    }

    protected void mouseMove(int x, int y) {
        for (IGuiObject o : this.objectList) {
            o.imouseMove(x, y);
        }
    }

    protected void mouseMovedOrUp(int x, int y, int witch) {
        for (IGuiObject o : this.objectList) {
            o.imouseMovedOrUp(x, y, witch);
        }
    }

    public void drawString(int x, int y, int color, String str) {
        Minecraft.func_71410_x().field_71466_p.func_78276_b(str, this.screen.field_146294_l / 2 - this.xSize / 2 + x, this.screen.field_146295_m / 2 - this.ySize / 2 + y, color);
    }

    public void draw2(int x, int y) {
        for (IGuiObject o : this.objectList) {
            o.idraw2(x, y);
        }
    }

    public void drawHoveringText(List par1List, int x, int y, FontRenderer font) {
        if (!par1List.isEmpty()) {
            if (this.screen instanceof GuiContainer) {
                x -= (this.screen.field_146294_l - this.xSize) / 2;
                y -= (this.screen.field_146295_m - this.ySize) / 2;
            }
            GL11.glDisable((int)32826);
            RenderHelper.func_74518_a();
            GL11.glDisable((int)2896);
            GL11.glDisable((int)2929);
            int textWidth = 0;
            for (String s : par1List) {
                int l = font.func_78256_a(s);
                if (l <= textWidth) continue;
                textWidth = l;
            }
            if (this.screen instanceof GuiContainer) {
                if (x + (this.screen.field_146294_l - this.xSize) / 2 + textWidth + 30 > this.screen.field_146294_l) {
                    x -= textWidth + 24;
                }
            } else if (x + textWidth + 30 > this.screen.field_146294_l) {
                x -= textWidth + 24;
            }
            int i1 = x + 12;
            int j1 = y - 12;
            int k1 = 8;
            if (par1List.size() > 1) {
                k1 += 2 + (par1List.size() - 1) * 10;
            }
            int l1 = -267386864;
            this.drawGradientRect(i1 - 3, j1 - 4, i1 + textWidth + 3, j1 - 3, l1, l1);
            this.drawGradientRect(i1 - 3, j1 + k1 + 3, i1 + textWidth + 3, j1 + k1 + 4, l1, l1);
            this.drawGradientRect(i1 - 3, j1 - 3, i1 + textWidth + 3, j1 + k1 + 3, l1, l1);
            this.drawGradientRect(i1 - 4, j1 - 3, i1 - 3, j1 + k1 + 3, l1, l1);
            this.drawGradientRect(i1 + textWidth + 3, j1 - 3, i1 + textWidth + 4, j1 + k1 + 3, l1, l1);
            int i2 = 0x505000FF;
            int j2 = (i2 & 0xFEFEFE) >> 1 | i2 & 0xFF000000;
            this.drawGradientRect(i1 - 3, j1 - 3 + 1, i1 - 3 + 1, j1 + k1 + 3 - 1, i2, j2);
            this.drawGradientRect(i1 + textWidth + 2, j1 - 3 + 1, i1 + textWidth + 3, j1 + k1 + 3 - 1, i2, j2);
            this.drawGradientRect(i1 - 3, j1 - 3, i1 + textWidth + 3, j1 - 3 + 1, i2, i2);
            this.drawGradientRect(i1 - 3, j1 + k1 + 2, i1 + textWidth + 3, j1 + k1 + 3, j2, j2);
            for (int k2 = 0; k2 < par1List.size(); ++k2) {
                String s1 = (String)par1List.get(k2);
                font.func_78261_a(s1, i1, j1, -1);
                if (k2 == 0) {
                    j1 += 2;
                }
                j1 += 10;
            }
            GL11.glEnable((int)2896);
            GL11.glEnable((int)2929);
            RenderHelper.func_74519_b();
            GL11.glEnable((int)32826);
        }
    }

    public void drawGradientRect(int par1, int par2, int par3, int par4, int par5, int par6) {
        float f = (float)(par5 >> 24 & 0xFF) / 255.0f;
        float f1 = (float)(par5 >> 16 & 0xFF) / 255.0f;
        float f2 = (float)(par5 >> 8 & 0xFF) / 255.0f;
        float f3 = (float)(par5 & 0xFF) / 255.0f;
        float f4 = (float)(par6 >> 24 & 0xFF) / 255.0f;
        float f5 = (float)(par6 >> 16 & 0xFF) / 255.0f;
        float f6 = (float)(par6 >> 8 & 0xFF) / 255.0f;
        float f7 = (float)(par6 & 0xFF) / 255.0f;
        GL11.glDisable((int)3553);
        GL11.glEnable((int)3042);
        GL11.glDisable((int)3008);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glShadeModel((int)7425);
        tessellator.func_78382_b();
        tessellator.func_78369_a(f1, f2, f3, f);
        tessellator.func_78377_a((double)par3, (double)par2, 0.0);
        tessellator.func_78377_a((double)par1, (double)par2, 0.0);
        tessellator.func_78369_a(f5, f6, f7, f4);
        tessellator.func_78377_a((double)par1, (double)par4, 0.0);
        tessellator.func_78377_a((double)par3, (double)par4, 0.0);
        tessellator.func_78381_a();
        GL11.glShadeModel((int)7424);
        GL11.glDisable((int)3042);
        GL11.glEnable((int)3008);
        GL11.glEnable((int)3553);
    }

    public int getHoveringTextWidth(List<String> comment, FontRenderer fontRenderer) {
        int strWidth = 0;
        for (String str : comment) {
            int size = fontRenderer.func_78256_a(str);
            if (size <= strWidth) continue;
            strWidth = size;
        }
        return strWidth + 5;
    }

    public int getHoveringTextHeight(List<String> comment, FontRenderer fontRenderer) {
        return comment.size() * 9 - 4;
    }

    public void drawProcess(int x, int y, float value) {
        UtilsClient.bindTexture(helperTexture);
        this.drawTexturedModalRect(x, y, 8, 0, 22, 16);
        this.drawTexturedModalRect(x, y, 30, 0, (int)(22.0f * value), 16);
    }

    protected void drawSlot(int x, int y) {
        UtilsClient.bindTexture(slotSkin);
        this.drawTexturedModalRect(x - 1, y - 1, 55, 16, 18, 18);
    }
}

