/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.i18n;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import mods.eln.i18n.LanguageFileGenerator;
import mods.eln.i18n.SourceCodeParser;
import mods.eln.i18n.TranslationItem;

class LanguageFileUpdater {
    private LanguageFileUpdater() {
    }

    private static void updateFile(File languageFile, Map<String, Set<TranslationItem>> stringsToTranslate) throws IOException {
        Properties existingTranslations = new Properties();
        existingTranslations.load(new FileInputStream(languageFile));
        LanguageFileGenerator.updateFile(languageFile, stringsToTranslate, existingTranslations);
    }

    public static void main(String ... args) {
        try {
            if (args.length != 2) {
                System.exit(1);
            }
            File srcFolder = new File(args[0]);
            File languageFileOrFolder = new File(args[1]);
            if (!srcFolder.isDirectory()) {
                System.exit(1);
            }
            Map<String, Set<TranslationItem>> stringsToTranslate = SourceCodeParser.parseSourceFolder(srcFolder);
            if (languageFileOrFolder.isFile()) {
                LanguageFileUpdater.updateFile(languageFileOrFolder, stringsToTranslate);
            } else if (languageFileOrFolder.isDirectory()) {
                for (File file : languageFileOrFolder.listFiles()) {
                    if (!file.getName().endsWith(".lang") || file.getName().startsWith("_")) continue;
                    LanguageFileUpdater.updateFile(file, stringsToTranslate);
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            Runtime.getRuntime().exit(1);
        }
    }
}

