/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.i18n;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import mods.eln.i18n.I18N;
import mods.eln.i18n.TranslationItem;

class SourceCodeParser {
    private static final Pattern JAVA_TR_PATTERN = Pattern.compile("(?:tr|TR)\\s*\\(\\s*\"(.*?)\"\\s*[,)]");
    private static final Pattern JAVA_FORGE_PATTERN = Pattern.compile("TR_([A-Z]*)\\s*\\(\\s*(?:I18N.)?Type.(.*?)\\s*,\\s\"(.*?)\"\\s*\\)");
    private static final String MULTIPLE_LOCATIONS = "Appearing in multiple source files";

    private SourceCodeParser() {
    }

    public static Map<String, Set<TranslationItem>> parseSourceFolder(File file) throws IOException {
        TreeMap<String, Set<TranslationItem>> strings = new TreeMap<String, Set<TranslationItem>>();
        strings.put(MULTIPLE_LOCATIONS, new TreeSet());
        SourceCodeParser.parseSourceFolderRecursive(file, strings);
        return strings;
    }

    private static void parseSourceFolderRecursive(File folder, Map<String, Set<TranslationItem>> strings) throws IOException {
        if (folder != null && folder.exists()) {
            for (File file : folder.listFiles()) {
                if (file.isDirectory()) {
                    SourceCodeParser.parseSourceFolderRecursive(file, strings);
                    continue;
                }
                if (file.isFile() && file.getName().endsWith(".java")) {
                    System.out.println("Parsing Java source file: " + file.getName() + "...");
                    SourceCodeParser.parseJavaFile(file, strings);
                    continue;
                }
                if (!file.isFile() || !file.getName().endsWith(".kt")) continue;
                System.out.println("Parsing Kotlin source file: " + file.getName() + "...");
                SourceCodeParser.parseKotlinFile(file, strings);
            }
        }
    }

    private static void parseJavaFile(File file, Map<String, Set<TranslationItem>> strings) throws IOException {
        String content = new Scanner(file).useDelimiter("\\Z").next();
        TreeSet<TranslationItem> textsToTranslate = new TreeSet<TranslationItem>();
        Matcher trMatcher = JAVA_TR_PATTERN.matcher(content);
        while (trMatcher.find()) {
            TranslationItem textToTranslate = new TranslationItem(trMatcher.group(1));
            System.out.println("  " + textToTranslate.getKey());
            if (SourceCodeParser.isStringAlreadyPresent(textToTranslate, strings)) continue;
            textsToTranslate.add(textToTranslate);
        }
        Matcher forgeMatcher = JAVA_FORGE_PATTERN.matcher(content);
        while (forgeMatcher.find()) {
            String property = forgeMatcher.group(1).toLowerCase();
            I18N.Type type = I18N.Type.valueOf(forgeMatcher.group(2));
            String text = forgeMatcher.group(3);
            TranslationItem textToTranslate = new TranslationItem(type.getPrefix() + I18N.encodeLangKey(text, type.isWhitespacesInFileReplaced()) + "." + property, text);
            System.out.println("  " + textToTranslate.getKey());
            if (SourceCodeParser.isStringAlreadyPresent(textToTranslate, strings)) continue;
            textsToTranslate.add(textToTranslate);
        }
        if (!textsToTranslate.isEmpty()) {
            strings.put(file.getPath(), textsToTranslate);
        }
    }

    private static void parseKotlinFile(File file, Map<String, Set<TranslationItem>> strings) throws IOException {
        SourceCodeParser.parseJavaFile(file, strings);
    }

    private static boolean isStringAlreadyPresent(TranslationItem string, Map<String, Set<TranslationItem>> strings) {
        for (String fileName : strings.keySet()) {
            if (MULTIPLE_LOCATIONS.equals(fileName)) {
                if (!strings.get(fileName).contains(string)) continue;
                return true;
            }
            if (!strings.get(fileName).remove(string)) continue;
            strings.get(MULTIPLE_LOCATIONS).add(string);
            return true;
        }
        return false;
    }
}

