/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.i18n;

import java.util.Properties;
import mods.eln.i18n.I18N;

class TranslationItem
implements Comparable<TranslationItem> {
    private final String key;
    private String text;

    public TranslationItem(String text) {
        this.key = I18N.encodeLangKey(text);
        this.text = text;
    }

    public TranslationItem(String key, String text) {
        this.key = key;
        this.text = text;
    }

    public String getKey() {
        return this.key;
    }

    public String getText() {
        return this.text;
    }

    public boolean isValid() {
        return this.key != null;
    }

    public void applyExistingTranslationIfPresent(Properties existing) {
        String text;
        if (existing != null && (text = existing.getProperty(this.key)) != null) {
            this.text = text;
        }
    }

    @Override
    public int compareTo(TranslationItem other) throws NullPointerException {
        return this.key.compareTo(other.key);
    }

    public boolean equals(Object object) {
        return object instanceof TranslationItem && this.compareTo((TranslationItem)object) == 0 || object instanceof String && this.key.compareTo((String)object) == 0;
    }

    public String toString() {
        return this.key + "=" + this.text.replace("\\\"", "\"") + "\n";
    }
}

