/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.item;

import java.util.List;
import mods.eln.generic.GenericItemUsingDamageDescriptor;
import mods.eln.i18n.I18N;
import mods.eln.misc.Utils;
import mods.eln.misc.UtilsClient;
import mods.eln.wiki.Data;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;

public class BrushDescriptor
extends GenericItemUsingDamageDescriptor {
    private final ResourceLocation icon;
    private static ResourceLocation dryOverlay = new ResourceLocation("eln", "textures/items/brushdryoverlay.png");

    public BrushDescriptor(String name) {
        super(name);
        this.icon = new ResourceLocation("eln", "textures/items/" + name.toLowerCase().replace(" ", "") + ".png");
    }

    @Override
    public String getName(ItemStack stack) {
        int color = this.getColor(stack);
        int life = this.getLife(stack);
        if (color == 15 && life == 0) {
            return "Empty " + super.getName(stack);
        }
        return super.getName(stack);
    }

    @Override
    public void setParent(Item item, int damage) {
        super.setParent(item, damage);
        Data.addWiring(this.newItemStack());
    }

    public int getColor(ItemStack stack) {
        return stack.func_77960_j() & 0xF;
    }

    public int getLife(ItemStack stack) {
        return stack.func_77978_p().func_74762_e("life");
    }

    public void setColor(ItemStack stack, int color) {
        stack.func_77964_b(stack.func_77960_j() & 0xFFFFFFF0 | color);
    }

    public void setLife(ItemStack stack, int life) {
        stack.func_77978_p().func_74768_a("life", life);
    }

    @Override
    public NBTTagCompound getDefaultNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74768_a("life", 32);
        return nbt;
    }

    @Override
    public ItemStack newItemStack(int size) {
        return super.newItemStack(size);
    }

    @Override
    public void addInformation(ItemStack itemStack, EntityPlayer entityPlayer, List list, boolean par4) {
        super.addInformation(itemStack, entityPlayer, list, par4);
        if (itemStack != null) {
            list.add(I18N.tr("Can paint %1$ blocks", itemStack.func_77978_p().func_74762_e("life")));
        }
    }

    public boolean use(ItemStack stack, EntityPlayer entityPlayer) {
        int life = stack.func_77978_p().func_74762_e("life");
        if (life != 0) {
            stack.func_77978_p().func_74768_a("life", --life);
            return true;
        }
        Utils.addChatMessage(entityPlayer, I18N.tr("Brush is dry", new Object[0]));
        return false;
    }

    @Override
    public boolean use2DIcon() {
        return true;
    }

    @Override
    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        return type == IItemRenderer.ItemRenderType.INVENTORY;
    }

    @Override
    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return type != IItemRenderer.ItemRenderType.INVENTORY;
    }

    @Override
    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        if (type == IItemRenderer.ItemRenderType.INVENTORY) {
            UtilsClient.drawIcon(type, this.icon);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)(0.75f - 0.75f * (float)this.getLife(item) / 32.0f));
            UtilsClient.drawIcon(type, dryOverlay);
            GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        } else {
            super.renderItem(type, item, data);
        }
    }
}

