/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.item;

import java.util.List;
import mods.eln.i18n.I18N;
import mods.eln.item.GenericItemUsingDamageDescriptorUpgrade;
import mods.eln.misc.VoltageLevelColor;
import mods.eln.sim.ElectricalLoad;
import mods.eln.sim.RegulatorThermalLoadToElectricalResistor;
import mods.eln.sixnode.electricalcable.ElectricalCableDescriptor;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;

public class HeatingCorpElement
extends GenericItemUsingDamageDescriptorUpgrade {
    public double electricalNominalU;
    double electricalNominalP;
    double electricalMaximalP;
    public ElectricalCableDescriptor cableDescriptor;
    double electricalR;
    double Umax;

    public HeatingCorpElement(String name, double electricalNominalU, double electricalNominalP, double electricalMaximalP, ElectricalCableDescriptor cableDescriptor) {
        super(name);
        this.electricalNominalU = electricalNominalU;
        this.electricalNominalP = electricalNominalP;
        this.electricalMaximalP = electricalMaximalP;
        this.cableDescriptor = cableDescriptor;
        this.electricalR = electricalNominalU * electricalNominalU / electricalNominalP;
        this.Umax = Math.sqrt(electricalMaximalP * this.electricalR);
        this.voltageLevelColor = VoltageLevelColor.fromVoltage(electricalNominalU);
    }

    public void applyTo(ElectricalLoad load) {
        this.cableDescriptor.applyTo(load);
    }

    public void applyTo(RegulatorThermalLoadToElectricalResistor regulator) {
        regulator.setRmin(this.electricalR);
    }

    @Override
    public void addInformation(ItemStack itemStack, EntityPlayer entityPlayer, List list, boolean par4) {
        super.addInformation(itemStack, entityPlayer, list, par4);
        list.add(I18N.tr("Nominal:", new Object[0]));
        list.add("  " + I18N.tr("Voltage: %1$V", this.electricalNominalU));
        list.add("  " + I18N.tr("Power: %1$W", this.electricalNominalP));
        list.add("  " + I18N.tr("Resistance: %1$\u2126", this.electricalR));
    }
}

