/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.item;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.List;
import mods.eln.Eln;
import mods.eln.i18n.I18N;
import mods.eln.item.GenericItemUsingDamageDescriptorUpgrade;
import mods.eln.misc.IConfigSharing;
import mods.eln.misc.Utils;
import mods.eln.misc.VoltageLevelColor;
import mods.eln.sim.mna.component.Resistor;
import mods.eln.sixnode.lampsocket.LampSocketType;
import mods.eln.wiki.Data;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class LampDescriptor
extends GenericItemUsingDamageDescriptorUpgrade
implements IConfigSharing {
    public double nominalP;
    public double nominalLight;
    public double nominalLife;
    public String name;
    public String description;
    public Type type;
    public LampSocketType socket;
    public double nominalU;
    public double minimalU;
    public double stableU;
    public double stableUNormalised;
    public double stableTime;
    public double vegetableGrowRate;
    double serverNominalLife;

    public LampDescriptor(String name, String iconName, Type type, LampSocketType socket, double nominalU, double nominalP, double nominalLight, double nominalLife, double vegetableGrowRate) {
        super(name);
        this.changeDefaultIcon(iconName);
        this.type = type;
        this.socket = socket;
        this.nominalU = nominalU;
        this.nominalP = nominalP;
        this.nominalLight = nominalLight;
        this.nominalLife = nominalLife;
        this.vegetableGrowRate = vegetableGrowRate;
        switch (type) {
            case Incandescent: {
                this.minimalU = nominalU * 0.5;
                break;
            }
            case eco: {
                this.stableUNormalised = 0.75;
                this.minimalU = nominalU * 0.5;
                this.stableU = nominalU * this.stableUNormalised;
                this.stableTime = 4.0;
                break;
            }
            case LED: {
                this.minimalU = nominalU * 0.75;
                break;
            }
        }
        Eln.instance.configShared.add(this);
        this.voltageLevelColor = VoltageLevelColor.fromVoltage(nominalU);
    }

    @Override
    public void setParent(Item item, int damage) {
        super.setParent(item, damage);
        Data.addLight(this.newItemStack());
    }

    public double getR() {
        return this.nominalU * this.nominalU / this.nominalP;
    }

    public double getLifeInTag(ItemStack stack) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(this.getDefaultNBT());
        }
        if (stack.func_77978_p().func_74764_b("life")) {
            return stack.func_77978_p().func_74769_h("life");
        }
        return Utils.rand(0.75, 1.5);
    }

    public void setLifeInTag(ItemStack stack, double life) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(this.getDefaultNBT());
        }
        stack.func_77978_p().func_74780_a("life", life);
    }

    @Override
    public NBTTagCompound getDefaultNBT() {
        return new NBTTagCompound();
    }

    @Override
    public ItemStack newItemStack(int size) {
        return super.newItemStack(size);
    }

    public void applyTo(Resistor resistor) {
        resistor.setR(this.getR());
    }

    @Override
    public void addInformation(ItemStack itemStack, EntityPlayer entityPlayer, List list, boolean par4) {
        super.addInformation(itemStack, entityPlayer, list, par4);
        list.add(I18N.tr("Technology: %1$", new Object[]{this.type}));
        list.add(I18N.tr("Range: %1$ blocks", (int)(this.nominalLight * 15.0)));
        list.add(I18N.tr("Power: %1$W", (int)this.nominalP));
        list.add(I18N.tr("Resistance: %1$\u2126", this.getR()));
        list.add(I18N.tr("Nominal lifetime: %1$h", this.serverNominalLife));
        if (itemStack != null) {
            if (!itemStack.func_77942_o() || !itemStack.func_77978_p().func_74764_b("life")) {
                list.add(I18N.tr("Condition:", new Object[0]) + " " + I18N.tr("New", new Object[0]));
            } else if (this.getLifeInTag(itemStack) > 0.5) {
                list.add(I18N.tr("Condition:", new Object[0]) + " " + I18N.tr("Good", new Object[0]));
            } else if (this.getLifeInTag(itemStack) > 0.2) {
                list.add(I18N.tr("Condition:", new Object[0]) + " " + I18N.tr("Used", new Object[0]));
            } else if (this.getLifeInTag(itemStack) > 0.1) {
                list.add(I18N.tr("Condition:", new Object[0]) + " " + I18N.tr("End of life", new Object[0]));
            } else {
                list.add(I18N.tr("Condition:", new Object[0]) + " " + I18N.tr("Bad", new Object[0]));
            }
        }
    }

    @Override
    public void serializeConfig(DataOutputStream stream) throws IOException {
        stream.writeDouble(this.nominalLife);
    }

    @Override
    public void deserialize(DataInputStream stream) throws IOException {
        this.serverNominalLife = stream.readDouble();
    }

    public static enum Type {
        Incandescent,
        eco,
        LED;

    }
}

