/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.item.electricalitem;

import java.util.List;
import mods.eln.generic.GenericItemUsingDamageDescriptor;
import mods.eln.i18n.I18N;
import mods.eln.item.electricalinterface.IItemEnergyBattery;
import mods.eln.misc.UtilsClient;
import mods.eln.wiki.Data;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.IItemRenderer;

public class BatteryItem
extends GenericItemUsingDamageDescriptor
implements IItemEnergyBattery {
    private int priority;
    ResourceLocation iconResource;
    double energyStorage;
    double dischargePower;
    double chargePower;

    public BatteryItem(String name, double energyStorage, double chargePower, double dischargePower, int priority) {
        super(name);
        this.priority = priority;
        this.chargePower = chargePower;
        this.dischargePower = dischargePower;
        this.energyStorage = energyStorage;
        this.iconResource = new ResourceLocation("eln", "textures/items/" + name.replace(" ", "").toLowerCase() + ".png");
    }

    @Override
    public void setParent(Item item, int damage) {
        super.setParent(item, damage);
        Data.addPortable(this.newItemStack());
    }

    @Override
    public NBTTagCompound getDefaultNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74780_a("energy", 0.0);
        return nbt;
    }

    @Override
    public void addInformation(ItemStack itemStack, EntityPlayer entityPlayer, List list, boolean par4) {
        super.addInformation(itemStack, entityPlayer, list, par4);
        list.add(I18N.tr("Charge power: %1$W", (int)this.chargePower));
        list.add(I18N.tr("Discharge power: %1$W", (int)this.dischargePower));
        if (itemStack != null) {
            list.add(I18N.tr("Stored energy: %1$J (%2$%)", this.getEnergy(itemStack), (int)(this.getEnergy(itemStack) / this.energyStorage * 100.0)));
        }
    }

    @Override
    public double getEnergy(ItemStack stack) {
        return this.getNbt(stack).func_74769_h("energy");
    }

    @Override
    public void setEnergy(ItemStack stack, double value) {
        if (value < 0.0) {
            value = 0.0;
        }
        this.getNbt(stack).func_74780_a("energy", value);
    }

    @Override
    public double getEnergyMax(ItemStack stack) {
        return this.energyStorage;
    }

    @Override
    public double getChargePower(ItemStack stack) {
        return this.chargePower;
    }

    @Override
    public double getDischagePower(ItemStack stack) {
        return this.dischargePower;
    }

    @Override
    public int getPriority(ItemStack stack) {
        return this.priority;
    }

    @Override
    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return type != IItemRenderer.ItemRenderType.INVENTORY;
    }

    @Override
    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        return true;
    }

    @Override
    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        if (type == IItemRenderer.ItemRenderType.INVENTORY) {
            UtilsClient.drawEnergyBare(type, (float)(this.getEnergy(item) / this.getEnergyMax(item)));
        }
        UtilsClient.drawIcon(type, this.iconResource);
    }

    @Override
    public void electricalItemUpdate(ItemStack stack, double time) {
    }
}

