/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.item.electricalitem;

import java.util.List;
import mods.eln.generic.genericArmorItem;
import mods.eln.i18n.I18N;
import mods.eln.item.electricalinterface.IItemEnergyBattery;
import mods.eln.misc.Utils;
import mods.eln.wiki.Data;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraftforge.common.ISpecialArmor;

public class ElectricalArmor
extends genericArmorItem
implements IItemEnergyBattery,
ISpecialArmor {
    double ratioMax;
    double ratioMaxEnergy;
    double energyPerDamage;
    double energyStorage;
    double chargePower;

    public ElectricalArmor(ItemArmor.ArmorMaterial par2EnumArmorMaterial, int par3, genericArmorItem.ArmourType type, String t1, String t2, double energyStorage, double chargePower, double ratioMax, double ratioMaxEnergy, double energyPerDamage) {
        super(par2EnumArmorMaterial, par3, type, t1, t2);
        this.chargePower = chargePower;
        this.energyStorage = energyStorage;
        this.ratioMax = ratioMax;
        this.ratioMaxEnergy = ratioMaxEnergy;
        this.energyPerDamage = energyPerDamage;
        Data.addPortable(new ItemStack((Item)this));
    }

    public ISpecialArmor.ArmorProperties getProperties(EntityLivingBase player, ItemStack armor, DamageSource source, double damage, int slot) {
        return new ISpecialArmor.ArmorProperties(100, Math.min(1.0, this.getEnergy(armor) / this.ratioMaxEnergy) * this.ratioMax, (int)(this.getEnergy(armor) / this.energyPerDamage * 25.0));
    }

    public int getArmorDisplay(EntityPlayer player, ItemStack armor, int slot) {
        return (int)(Math.min(1.0, this.getEnergy(armor) / this.ratioMaxEnergy) * this.ratioMax * 20.0);
    }

    public void damageArmor(EntityLivingBase entity, ItemStack stack, DamageSource source, int damage, int slot) {
        double e = this.getEnergy(stack);
        e = Math.max(0.0, e - (double)damage * this.energyPerDamage);
        this.setEnergy(stack, e);
        Utils.println("armor hit  damage=" + damage + " energy=" + e + " energyLost=" + (double)damage * this.energyPerDamage);
    }

    public boolean func_82789_a(ItemStack par1ItemStack, ItemStack par2ItemStack) {
        return false;
    }

    public boolean func_82816_b_(ItemStack par1ItemStack) {
        return false;
    }

    public NBTTagCompound getDefaultNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74780_a("energy", 0.0);
        nbt.func_74757_a("powerOn", false);
        nbt.func_74768_a("rand", (int)(Math.random() * 2.68435455E8));
        return nbt;
    }

    protected NBTTagCompound getNbt(ItemStack stack) {
        NBTTagCompound nbt = stack.func_77978_p();
        if (nbt == null) {
            nbt = this.getDefaultNBT();
            stack.func_77982_d(nbt);
        }
        return nbt;
    }

    boolean getPowerOn(ItemStack stack) {
        return this.getNbt(stack).func_74767_n("powerOn");
    }

    void setPowerOn(ItemStack stack, boolean value) {
        this.getNbt(stack).func_74757_a("powerOn", value);
    }

    public void func_77624_a(ItemStack itemStack, EntityPlayer entityPlayer, List list, boolean par4) {
        super.func_77624_a(itemStack, entityPlayer, list, par4);
        list.add(I18N.tr("Charge power: %1$W", (int)this.chargePower));
        list.add(I18N.tr("Stored energy: %1$J (%2$%)", this.getEnergy(itemStack), (int)(this.getEnergy(itemStack) / this.energyStorage * 100.0)));
    }

    @Override
    public double getEnergy(ItemStack stack) {
        return this.getNbt(stack).func_74769_h("energy");
    }

    @Override
    public void setEnergy(ItemStack stack, double value) {
        this.getNbt(stack).func_74780_a("energy", value);
    }

    @Override
    public double getEnergyMax(ItemStack stack) {
        return this.energyStorage;
    }

    @Override
    public double getChargePower(ItemStack stack) {
        return this.chargePower;
    }

    @Override
    public double getDischagePower(ItemStack stack) {
        return 0.0;
    }

    @Override
    public int getPriority(ItemStack stack) {
        return 0;
    }

    @Override
    public void electricalItemUpdate(ItemStack stack, double time) {
    }

    public int func_77619_b() {
        return 0;
    }
}

